/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Amazon EventBridge global endpoint. The endpoint can improve your application’s
 * availability by making it Regional-fault tolerant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEventsEndpointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEventsEndpointDetails.Builder, AwsEventsEndpointDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsEventsEndpointDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsEventsEndpointDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(AwsEventsEndpointDetails::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointUrl").getter(getter(AwsEventsEndpointDetails::endpointUrl)).setter(setter(Builder::endpointUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()).build();

    private static final SdkField<List<AwsEventsEndpointEventBusesDetails>> EVENT_BUSES_FIELD = SdkField
            .<List<AwsEventsEndpointEventBusesDetails>> builder(MarshallingType.LIST)
            .memberName("EventBuses")
            .getter(getter(AwsEventsEndpointDetails::eventBuses))
            .setter(setter(Builder::eventBuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEventsEndpointEventBusesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEventsEndpointEventBusesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEventsEndpointDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsEventsEndpointReplicationConfigDetails> REPLICATION_CONFIG_FIELD = SdkField
            .<AwsEventsEndpointReplicationConfigDetails> builder(MarshallingType.SDK_POJO).memberName("ReplicationConfig")
            .getter(getter(AwsEventsEndpointDetails::replicationConfig)).setter(setter(Builder::replicationConfig))
            .constructor(AwsEventsEndpointReplicationConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AwsEventsEndpointDetails::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<AwsEventsEndpointRoutingConfigDetails> ROUTING_CONFIG_FIELD = SdkField
            .<AwsEventsEndpointRoutingConfigDetails> builder(MarshallingType.SDK_POJO).memberName("RoutingConfig")
            .getter(getter(AwsEventsEndpointDetails::routingConfig)).setter(setter(Builder::routingConfig))
            .constructor(AwsEventsEndpointRoutingConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AwsEventsEndpointDetails::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(AwsEventsEndpointDetails::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            ENDPOINT_ID_FIELD, ENDPOINT_URL_FIELD, EVENT_BUSES_FIELD, NAME_FIELD, REPLICATION_CONFIG_FIELD, ROLE_ARN_FIELD,
            ROUTING_CONFIG_FIELD, STATE_FIELD, STATE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String description;

    private final String endpointId;

    private final String endpointUrl;

    private final List<AwsEventsEndpointEventBusesDetails> eventBuses;

    private final String name;

    private final AwsEventsEndpointReplicationConfigDetails replicationConfig;

    private final String roleArn;

    private final AwsEventsEndpointRoutingConfigDetails routingConfig;

    private final String state;

    private final String stateReason;

    private AwsEventsEndpointDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.description = builder.description;
        this.endpointId = builder.endpointId;
        this.endpointUrl = builder.endpointUrl;
        this.eventBuses = builder.eventBuses;
        this.name = builder.name;
        this.replicationConfig = builder.replicationConfig;
        this.roleArn = builder.roleArn;
        this.routingConfig = builder.routingConfig;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A description of the endpoint.
     * </p>
     * 
     * @return A description of the endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The URL subdomain of the endpoint. For example, if <code>EndpointUrl</code> is
     * <code>https://abcde.veo.endpoints.event.amazonaws.com</code>, then the <code>EndpointId</code> is
     * <code>abcde.veo</code>.
     * </p>
     * 
     * @return The URL subdomain of the endpoint. For example, if <code>EndpointUrl</code> is
     *         <code>https://abcde.veo.endpoints.event.amazonaws.com</code>, then the <code>EndpointId</code> is
     *         <code>abcde.veo</code>.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The URL of the endpoint.
     * </p>
     * 
     * @return The URL of the endpoint.
     */
    public final String endpointUrl() {
        return endpointUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventBuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventBuses() {
        return eventBuses != null && !(eventBuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event buses being used by the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventBuses} method.
     * </p>
     * 
     * @return The event buses being used by the endpoint.
     */
    public final List<AwsEventsEndpointEventBusesDetails> eventBuses() {
        return eventBuses;
    }

    /**
     * <p>
     * The name of the endpoint.
     * </p>
     * 
     * @return The name of the endpoint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Whether event replication was enabled or disabled for this endpoint. The default state is <code>ENABLED</code>,
     * which means you must supply a <code>RoleArn</code>. If you don't have a <code>RoleArn</code> or you don't want
     * event replication enabled, set the state to <code>DISABLED</code>.
     * </p>
     * 
     * @return Whether event replication was enabled or disabled for this endpoint. The default state is
     *         <code>ENABLED</code>, which means you must supply a <code>RoleArn</code>. If you don't have a
     *         <code>RoleArn</code> or you don't want event replication enabled, set the state to <code>DISABLED</code>.
     */
    public final AwsEventsEndpointReplicationConfigDetails replicationConfig() {
        return replicationConfig;
    }

    /**
     * <p>
     * The ARN of the role used by event replication for the endpoint.
     * </p>
     * 
     * @return The ARN of the role used by event replication for the endpoint.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The routing configuration of the endpoint.
     * </p>
     * 
     * @return The routing configuration of the endpoint.
     */
    public final AwsEventsEndpointRoutingConfigDetails routingConfig() {
        return routingConfig;
    }

    /**
     * <p>
     * The current state of the endpoint.
     * </p>
     * 
     * @return The current state of the endpoint.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The reason the endpoint is in its current state.
     * </p>
     * 
     * @return The reason the endpoint is in its current state.
     */
    public final String stateReason() {
        return stateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventBuses() ? eventBuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEventsEndpointDetails)) {
            return false;
        }
        AwsEventsEndpointDetails other = (AwsEventsEndpointDetails) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(endpointId(), other.endpointId()) && Objects.equals(endpointUrl(), other.endpointUrl())
                && hasEventBuses() == other.hasEventBuses() && Objects.equals(eventBuses(), other.eventBuses())
                && Objects.equals(name(), other.name()) && Objects.equals(replicationConfig(), other.replicationConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(routingConfig(), other.routingConfig())
                && Objects.equals(state(), other.state()) && Objects.equals(stateReason(), other.stateReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEventsEndpointDetails").add("Arn", arn()).add("Description", description())
                .add("EndpointId", endpointId()).add("EndpointUrl", endpointUrl())
                .add("EventBuses", hasEventBuses() ? eventBuses() : null).add("Name", name())
                .add("ReplicationConfig", replicationConfig()).add("RoleArn", roleArn()).add("RoutingConfig", routingConfig())
                .add("State", state()).add("StateReason", stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "EndpointUrl":
            return Optional.ofNullable(clazz.cast(endpointUrl()));
        case "EventBuses":
            return Optional.ofNullable(clazz.cast(eventBuses()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ReplicationConfig":
            return Optional.ofNullable(clazz.cast(replicationConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "RoutingConfig":
            return Optional.ofNullable(clazz.cast(routingConfig()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("EndpointUrl", ENDPOINT_URL_FIELD);
        map.put("EventBuses", EVENT_BUSES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ReplicationConfig", REPLICATION_CONFIG_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("RoutingConfig", ROUTING_CONFIG_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEventsEndpointDetails, T> g) {
        return obj -> g.apply((AwsEventsEndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEventsEndpointDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A description of the endpoint.
         * </p>
         * 
         * @param description
         *        A description of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URL subdomain of the endpoint. For example, if <code>EndpointUrl</code> is
         * <code>https://abcde.veo.endpoints.event.amazonaws.com</code>, then the <code>EndpointId</code> is
         * <code>abcde.veo</code>.
         * </p>
         * 
         * @param endpointId
         *        The URL subdomain of the endpoint. For example, if <code>EndpointUrl</code> is
         *        <code>https://abcde.veo.endpoints.event.amazonaws.com</code>, then the <code>EndpointId</code> is
         *        <code>abcde.veo</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The URL of the endpoint.
         * </p>
         * 
         * @param endpointUrl
         *        The URL of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointUrl(String endpointUrl);

        /**
         * <p>
         * The event buses being used by the endpoint.
         * </p>
         * 
         * @param eventBuses
         *        The event buses being used by the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(Collection<AwsEventsEndpointEventBusesDetails> eventBuses);

        /**
         * <p>
         * The event buses being used by the endpoint.
         * </p>
         * 
         * @param eventBuses
         *        The event buses being used by the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(AwsEventsEndpointEventBusesDetails... eventBuses);

        /**
         * <p>
         * The event buses being used by the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #eventBuses(List<AwsEventsEndpointEventBusesDetails>)}.
         * 
         * @param eventBuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBuses(java.util.Collection<AwsEventsEndpointEventBusesDetails>)
         */
        Builder eventBuses(Consumer<AwsEventsEndpointEventBusesDetails.Builder>... eventBuses);

        /**
         * <p>
         * The name of the endpoint.
         * </p>
         * 
         * @param name
         *        The name of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Whether event replication was enabled or disabled for this endpoint. The default state is
         * <code>ENABLED</code>, which means you must supply a <code>RoleArn</code>. If you don't have a
         * <code>RoleArn</code> or you don't want event replication enabled, set the state to <code>DISABLED</code>.
         * </p>
         * 
         * @param replicationConfig
         *        Whether event replication was enabled or disabled for this endpoint. The default state is
         *        <code>ENABLED</code>, which means you must supply a <code>RoleArn</code>. If you don't have a
         *        <code>RoleArn</code> or you don't want event replication enabled, set the state to
         *        <code>DISABLED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfig(AwsEventsEndpointReplicationConfigDetails replicationConfig);

        /**
         * <p>
         * Whether event replication was enabled or disabled for this endpoint. The default state is
         * <code>ENABLED</code>, which means you must supply a <code>RoleArn</code>. If you don't have a
         * <code>RoleArn</code> or you don't want event replication enabled, set the state to <code>DISABLED</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEventsEndpointReplicationConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEventsEndpointReplicationConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEventsEndpointReplicationConfigDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #replicationConfig(AwsEventsEndpointReplicationConfigDetails)}.
         * 
         * @param replicationConfig
         *        a consumer that will call methods on {@link AwsEventsEndpointReplicationConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationConfig(AwsEventsEndpointReplicationConfigDetails)
         */
        default Builder replicationConfig(Consumer<AwsEventsEndpointReplicationConfigDetails.Builder> replicationConfig) {
            return replicationConfig(AwsEventsEndpointReplicationConfigDetails.builder().applyMutation(replicationConfig).build());
        }

        /**
         * <p>
         * The ARN of the role used by event replication for the endpoint.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role used by event replication for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The routing configuration of the endpoint.
         * </p>
         * 
         * @param routingConfig
         *        The routing configuration of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfig(AwsEventsEndpointRoutingConfigDetails routingConfig);

        /**
         * <p>
         * The routing configuration of the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEventsEndpointRoutingConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEventsEndpointRoutingConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEventsEndpointRoutingConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #routingConfig(AwsEventsEndpointRoutingConfigDetails)}.
         * 
         * @param routingConfig
         *        a consumer that will call methods on {@link AwsEventsEndpointRoutingConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfig(AwsEventsEndpointRoutingConfigDetails)
         */
        default Builder routingConfig(Consumer<AwsEventsEndpointRoutingConfigDetails.Builder> routingConfig) {
            return routingConfig(AwsEventsEndpointRoutingConfigDetails.builder().applyMutation(routingConfig).build());
        }

        /**
         * <p>
         * The current state of the endpoint.
         * </p>
         * 
         * @param state
         *        The current state of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The reason the endpoint is in its current state.
         * </p>
         * 
         * @param stateReason
         *        The reason the endpoint is in its current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String description;

        private String endpointId;

        private String endpointUrl;

        private List<AwsEventsEndpointEventBusesDetails> eventBuses = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private AwsEventsEndpointReplicationConfigDetails replicationConfig;

        private String roleArn;

        private AwsEventsEndpointRoutingConfigDetails routingConfig;

        private String state;

        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEventsEndpointDetails model) {
            arn(model.arn);
            description(model.description);
            endpointId(model.endpointId);
            endpointUrl(model.endpointUrl);
            eventBuses(model.eventBuses);
            name(model.name);
            replicationConfig(model.replicationConfig);
            roleArn(model.roleArn);
            routingConfig(model.routingConfig);
            state(model.state);
            stateReason(model.stateReason);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getEndpointUrl() {
            return endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final List<AwsEventsEndpointEventBusesDetails.Builder> getEventBuses() {
            List<AwsEventsEndpointEventBusesDetails.Builder> result = AwsEventsEndpointEventBusesListCopier
                    .copyToBuilder(this.eventBuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventBuses(Collection<AwsEventsEndpointEventBusesDetails.BuilderImpl> eventBuses) {
            this.eventBuses = AwsEventsEndpointEventBusesListCopier.copyFromBuilder(eventBuses);
        }

        @Override
        public final Builder eventBuses(Collection<AwsEventsEndpointEventBusesDetails> eventBuses) {
            this.eventBuses = AwsEventsEndpointEventBusesListCopier.copy(eventBuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(AwsEventsEndpointEventBusesDetails... eventBuses) {
            eventBuses(Arrays.asList(eventBuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(Consumer<AwsEventsEndpointEventBusesDetails.Builder>... eventBuses) {
            eventBuses(Stream.of(eventBuses).map(c -> AwsEventsEndpointEventBusesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsEventsEndpointReplicationConfigDetails.Builder getReplicationConfig() {
            return replicationConfig != null ? replicationConfig.toBuilder() : null;
        }

        public final void setReplicationConfig(AwsEventsEndpointReplicationConfigDetails.BuilderImpl replicationConfig) {
            this.replicationConfig = replicationConfig != null ? replicationConfig.build() : null;
        }

        @Override
        public final Builder replicationConfig(AwsEventsEndpointReplicationConfigDetails replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final AwsEventsEndpointRoutingConfigDetails.Builder getRoutingConfig() {
            return routingConfig != null ? routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(AwsEventsEndpointRoutingConfigDetails.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public final Builder routingConfig(AwsEventsEndpointRoutingConfigDetails routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        @Override
        public AwsEventsEndpointDetails build() {
            return new AwsEventsEndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
