/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a link to another environment that is in the same group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElasticBeanstalkEnvironmentEnvironmentLink implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder, AwsElasticBeanstalkEnvironmentEnvironmentLink> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(AwsElasticBeanstalkEnvironmentEnvironmentLink::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkName").getter(getter(AwsElasticBeanstalkEnvironmentEnvironmentLink::linkName))
            .setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD,
            LINK_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String environmentName;

    private final String linkName;

    private AwsElasticBeanstalkEnvironmentEnvironmentLink(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.linkName = builder.linkName;
    }

    /**
     * <p>
     * The name of the linked environment.
     * </p>
     * 
     * @return The name of the linked environment.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The name of the environment link.
     * </p>
     * 
     * @return The name of the environment link.
     */
    public final String linkName() {
        return linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticBeanstalkEnvironmentEnvironmentLink)) {
            return false;
        }
        AwsElasticBeanstalkEnvironmentEnvironmentLink other = (AwsElasticBeanstalkEnvironmentEnvironmentLink) obj;
        return Objects.equals(environmentName(), other.environmentName()) && Objects.equals(linkName(), other.linkName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElasticBeanstalkEnvironmentEnvironmentLink").add("EnvironmentName", environmentName())
                .add("LinkName", linkName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
        map.put("LinkName", LINK_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticBeanstalkEnvironmentEnvironmentLink, T> g) {
        return obj -> g.apply((AwsElasticBeanstalkEnvironmentEnvironmentLink) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElasticBeanstalkEnvironmentEnvironmentLink> {
        /**
         * <p>
         * The name of the linked environment.
         * </p>
         * 
         * @param environmentName
         *        The name of the linked environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The name of the environment link.
         * </p>
         * 
         * @param linkName
         *        The name of the environment link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);
    }

    static final class BuilderImpl implements Builder {
        private String environmentName;

        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticBeanstalkEnvironmentEnvironmentLink model) {
            environmentName(model.environmentName);
            linkName(model.linkName);
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getLinkName() {
            return linkName;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        @Override
        public AwsElasticBeanstalkEnvironmentEnvironmentLink build() {
            return new AwsElasticBeanstalkEnvironmentEnvironmentLink(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
