/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the directory on the Amazon EFS file system that the access point exposes as the root
 * directory to NFS clients using the access point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEfsAccessPointRootDirectoryDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEfsAccessPointRootDirectoryDetails.Builder, AwsEfsAccessPointRootDirectoryDetails> {
    private static final SdkField<AwsEfsAccessPointRootDirectoryCreationInfoDetails> CREATION_INFO_FIELD = SdkField
            .<AwsEfsAccessPointRootDirectoryCreationInfoDetails> builder(MarshallingType.SDK_POJO).memberName("CreationInfo")
            .getter(getter(AwsEfsAccessPointRootDirectoryDetails::creationInfo)).setter(setter(Builder::creationInfo))
            .constructor(AwsEfsAccessPointRootDirectoryCreationInfoDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationInfo").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(AwsEfsAccessPointRootDirectoryDetails::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_INFO_FIELD,
            PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsEfsAccessPointRootDirectoryCreationInfoDetails creationInfo;

    private final String path;

    private AwsEfsAccessPointRootDirectoryDetails(BuilderImpl builder) {
        this.creationInfo = builder.creationInfo;
        this.path = builder.path;
    }

    /**
     * <p>
     * Specifies the POSIX IDs and permissions to apply to the access point's root directory.
     * </p>
     * 
     * @return Specifies the POSIX IDs and permissions to apply to the access point's root directory.
     */
    public final AwsEfsAccessPointRootDirectoryCreationInfoDetails creationInfo() {
        return creationInfo;
    }

    /**
     * <p>
     * Specifies the path on the Amazon EFS file system to expose as the root directory to NFS clients using the access
     * point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not
     * exist, you are required to provide <code>CreationInfo</code>.
     * </p>
     * 
     * @return Specifies the path on the Amazon EFS file system to expose as the root directory to NFS clients using the
     *         access point to access the EFS file system. A path can have up to four subdirectories. If the specified
     *         path does not exist, you are required to provide <code>CreationInfo</code>.
     */
    public final String path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEfsAccessPointRootDirectoryDetails)) {
            return false;
        }
        AwsEfsAccessPointRootDirectoryDetails other = (AwsEfsAccessPointRootDirectoryDetails) obj;
        return Objects.equals(creationInfo(), other.creationInfo()) && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEfsAccessPointRootDirectoryDetails").add("CreationInfo", creationInfo()).add("Path", path())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationInfo":
            return Optional.ofNullable(clazz.cast(creationInfo()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationInfo", CREATION_INFO_FIELD);
        map.put("Path", PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEfsAccessPointRootDirectoryDetails, T> g) {
        return obj -> g.apply((AwsEfsAccessPointRootDirectoryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEfsAccessPointRootDirectoryDetails> {
        /**
         * <p>
         * Specifies the POSIX IDs and permissions to apply to the access point's root directory.
         * </p>
         * 
         * @param creationInfo
         *        Specifies the POSIX IDs and permissions to apply to the access point's root directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationInfo(AwsEfsAccessPointRootDirectoryCreationInfoDetails creationInfo);

        /**
         * <p>
         * Specifies the POSIX IDs and permissions to apply to the access point's root directory.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEfsAccessPointRootDirectoryCreationInfoDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEfsAccessPointRootDirectoryCreationInfoDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEfsAccessPointRootDirectoryCreationInfoDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #creationInfo(AwsEfsAccessPointRootDirectoryCreationInfoDetails)}.
         * 
         * @param creationInfo
         *        a consumer that will call methods on {@link AwsEfsAccessPointRootDirectoryCreationInfoDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creationInfo(AwsEfsAccessPointRootDirectoryCreationInfoDetails)
         */
        default Builder creationInfo(Consumer<AwsEfsAccessPointRootDirectoryCreationInfoDetails.Builder> creationInfo) {
            return creationInfo(AwsEfsAccessPointRootDirectoryCreationInfoDetails.builder().applyMutation(creationInfo).build());
        }

        /**
         * <p>
         * Specifies the path on the Amazon EFS file system to expose as the root directory to NFS clients using the
         * access point to access the EFS file system. A path can have up to four subdirectories. If the specified path
         * does not exist, you are required to provide <code>CreationInfo</code>.
         * </p>
         * 
         * @param path
         *        Specifies the path on the Amazon EFS file system to expose as the root directory to NFS clients using
         *        the access point to access the EFS file system. A path can have up to four subdirectories. If the
         *        specified path does not exist, you are required to provide <code>CreationInfo</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);
    }

    static final class BuilderImpl implements Builder {
        private AwsEfsAccessPointRootDirectoryCreationInfoDetails creationInfo;

        private String path;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEfsAccessPointRootDirectoryDetails model) {
            creationInfo(model.creationInfo);
            path(model.path);
        }

        public final AwsEfsAccessPointRootDirectoryCreationInfoDetails.Builder getCreationInfo() {
            return creationInfo != null ? creationInfo.toBuilder() : null;
        }

        public final void setCreationInfo(AwsEfsAccessPointRootDirectoryCreationInfoDetails.BuilderImpl creationInfo) {
            this.creationInfo = creationInfo != null ? creationInfo.build() : null;
        }

        @Override
        public final Builder creationInfo(AwsEfsAccessPointRootDirectoryCreationInfoDetails creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public AwsEfsAccessPointRootDirectoryDetails build() {
            return new AwsEfsAccessPointRootDirectoryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
