/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a task in a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsTaskDetails.Builder, AwsEcsTaskDetails> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(AwsEcsTaskDetails::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskDefinitionArn").getter(getter(AwsEcsTaskDetails::taskDefinitionArn))
            .setter(setter(Builder::taskDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDefinitionArn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(AwsEcsTaskDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(AwsEcsTaskDetails::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> STARTED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartedAt").getter(getter(AwsEcsTaskDetails::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartedBy").getter(getter(AwsEcsTaskDetails::startedBy)).setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBy").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(AwsEcsTaskDetails::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<List<AwsEcsTaskVolumeDetails>> VOLUMES_FIELD = SdkField
            .<List<AwsEcsTaskVolumeDetails>> builder(MarshallingType.LIST)
            .memberName("Volumes")
            .getter(getter(AwsEcsTaskDetails::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskVolumeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskVolumeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEcsContainerDetails>> CONTAINERS_FIELD = SdkField
            .<List<AwsEcsContainerDetails>> builder(MarshallingType.LIST)
            .memberName("Containers")
            .getter(getter(AwsEcsTaskDetails::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsContainerDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsContainerDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            TASK_DEFINITION_ARN_FIELD, VERSION_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, STARTED_BY_FIELD, GROUP_FIELD,
            VOLUMES_FIELD, CONTAINERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final String taskDefinitionArn;

    private final String version;

    private final String createdAt;

    private final String startedAt;

    private final String startedBy;

    private final String group;

    private final List<AwsEcsTaskVolumeDetails> volumes;

    private final List<AwsEcsContainerDetails> containers;

    private AwsEcsTaskDetails(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.version = builder.version;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.startedBy = builder.startedBy;
        this.group = builder.group;
        this.volumes = builder.volumes;
        this.containers = builder.containers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster that hosts the task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster that hosts the task.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The ARN of the task definition that creates the task.
     * </p>
     * 
     * @return The ARN of the task definition that creates the task.
     */
    public final String taskDefinitionArn() {
        return taskDefinitionArn;
    }

    /**
     * <p>
     * The version counter for the task.
     * </p>
     * 
     * @return The version counter for the task.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task
     * entered the <code>PENDING</code> state.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task was created. More specifically, it's for the time when the
     *         task entered the <code>PENDING</code> state.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     * transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     *         transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     */
    public final String startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The tag specified when a task is started. If an Amazon ECS service started the task, the <code>startedBy</code>
     * parameter contains the deployment ID of that service.
     * </p>
     * 
     * @return The tag specified when a task is started. If an Amazon ECS service started the task, the
     *         <code>startedBy</code> parameter contains the deployment ID of that service.
     */
    public final String startedBy() {
        return startedBy;
    }

    /**
     * <p>
     * The name of the task group that's associated with the task.
     * </p>
     * 
     * @return The name of the task group that's associated with the task.
     */
    public final String group() {
        return group;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the data volume that is used in a task definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return Details about the data volume that is used in a task definition.
     */
    public final List<AwsEcsTaskVolumeDetails> volumes() {
        return volumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The containers that are associated with the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The containers that are associated with the task.
     */
    public final List<AwsEcsContainerDetails> containers() {
        return containers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDetails)) {
            return false;
        }
        AwsEcsTaskDetails other = (AwsEcsTaskDetails) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(taskDefinitionArn(), other.taskDefinitionArn())
                && Objects.equals(version(), other.version()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(startedBy(), other.startedBy())
                && Objects.equals(group(), other.group()) && hasVolumes() == other.hasVolumes()
                && Objects.equals(volumes(), other.volumes()) && hasContainers() == other.hasContainers()
                && Objects.equals(containers(), other.containers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDetails").add("ClusterArn", clusterArn())
                .add("TaskDefinitionArn", taskDefinitionArn()).add("Version", version()).add("CreatedAt", createdAt())
                .add("StartedAt", startedAt()).add("StartedBy", startedBy()).add("Group", group())
                .add("Volumes", hasVolumes() ? volumes() : null).add("Containers", hasContainers() ? containers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "TaskDefinitionArn":
            return Optional.ofNullable(clazz.cast(taskDefinitionArn()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "StartedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "Volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        case "Containers":
            return Optional.ofNullable(clazz.cast(containers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("TaskDefinitionArn", TASK_DEFINITION_ARN_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("StartedBy", STARTED_BY_FIELD);
        map.put("Group", GROUP_FIELD);
        map.put("Volumes", VOLUMES_FIELD);
        map.put("Containers", CONTAINERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster that hosts the task.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the cluster that hosts the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The ARN of the task definition that creates the task.
         * </p>
         * 
         * @param taskDefinitionArn
         *        The ARN of the task definition that creates the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinitionArn(String taskDefinitionArn);

        /**
         * <p>
         * The version counter for the task.
         * </p>
         * 
         * @param version
         *        The version counter for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task
         * entered the <code>PENDING</code> state.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp for the time when the task was created. More specifically, it's for the time when
         *        the task entered the <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
         * transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp for the time when the task started. More specifically, it's for the time when the
         *        task transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(String startedAt);

        /**
         * <p>
         * The tag specified when a task is started. If an Amazon ECS service started the task, the
         * <code>startedBy</code> parameter contains the deployment ID of that service.
         * </p>
         * 
         * @param startedBy
         *        The tag specified when a task is started. If an Amazon ECS service started the task, the
         *        <code>startedBy</code> parameter contains the deployment ID of that service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);

        /**
         * <p>
         * The name of the task group that's associated with the task.
         * </p>
         * 
         * @param group
         *        The name of the task group that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * Details about the data volume that is used in a task definition.
         * </p>
         * 
         * @param volumes
         *        Details about the data volume that is used in a task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<AwsEcsTaskVolumeDetails> volumes);

        /**
         * <p>
         * Details about the data volume that is used in a task definition.
         * </p>
         * 
         * @param volumes
         *        Details about the data volume that is used in a task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(AwsEcsTaskVolumeDetails... volumes);

        /**
         * <p>
         * Details about the data volume that is used in a task definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #volumes(List<AwsEcsTaskVolumeDetails>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(java.util.Collection<AwsEcsTaskVolumeDetails>)
         */
        Builder volumes(Consumer<AwsEcsTaskVolumeDetails.Builder>... volumes);

        /**
         * <p>
         * The containers that are associated with the task.
         * </p>
         * 
         * @param containers
         *        The containers that are associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<AwsEcsContainerDetails> containers);

        /**
         * <p>
         * The containers that are associated with the task.
         * </p>
         * 
         * @param containers
         *        The containers that are associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(AwsEcsContainerDetails... containers);

        /**
         * <p>
         * The containers that are associated with the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #containers(List<AwsEcsContainerDetails>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<AwsEcsContainerDetails>)
         */
        Builder containers(Consumer<AwsEcsContainerDetails.Builder>... containers);
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private String taskDefinitionArn;

        private String version;

        private String createdAt;

        private String startedAt;

        private String startedBy;

        private String group;

        private List<AwsEcsTaskVolumeDetails> volumes = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEcsContainerDetails> containers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDetails model) {
            clusterArn(model.clusterArn);
            taskDefinitionArn(model.taskDefinitionArn);
            version(model.version);
            createdAt(model.createdAt);
            startedAt(model.startedAt);
            startedBy(model.startedBy);
            group(model.group);
            volumes(model.volumes);
            containers(model.containers);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getTaskDefinitionArn() {
            return taskDefinitionArn;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(String startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(String startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<AwsEcsTaskVolumeDetails.Builder> getVolumes() {
            List<AwsEcsTaskVolumeDetails.Builder> result = AwsEcsTaskVolumeDetailsListCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<AwsEcsTaskVolumeDetails.BuilderImpl> volumes) {
            this.volumes = AwsEcsTaskVolumeDetailsListCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<AwsEcsTaskVolumeDetails> volumes) {
            this.volumes = AwsEcsTaskVolumeDetailsListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(AwsEcsTaskVolumeDetails... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<AwsEcsTaskVolumeDetails.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> AwsEcsTaskVolumeDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEcsContainerDetails.Builder> getContainers() {
            List<AwsEcsContainerDetails.Builder> result = AwsEcsContainerDetailsListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<AwsEcsContainerDetails.BuilderImpl> containers) {
            this.containers = AwsEcsContainerDetailsListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<AwsEcsContainerDetails> containers) {
            this.containers = AwsEcsContainerDetailsListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(AwsEcsContainerDetails... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<AwsEcsContainerDetails.Builder>... containers) {
            containers(Stream.of(containers).map(c -> AwsEcsContainerDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEcsTaskDetails build() {
            return new AwsEcsTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
