/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for the App Mesh proxy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionProxyConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionProxyConfigurationDetails.Builder, AwsEcsTaskDefinitionProxyConfigurationDetails> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerName").getter(getter(AwsEcsTaskDefinitionProxyConfigurationDetails::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails>> PROXY_CONFIGURATION_PROPERTIES_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails>> builder(MarshallingType.LIST)
            .memberName("ProxyConfigurationProperties")
            .getter(getter(AwsEcsTaskDefinitionProxyConfigurationDetails::proxyConfigurationProperties))
            .setter(setter(Builder::proxyConfigurationProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsEcsTaskDefinitionProxyConfigurationDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            PROXY_CONFIGURATION_PROPERTIES_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String containerName;

    private final List<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails> proxyConfigurationProperties;

    private final String type;

    private AwsEcsTaskDefinitionProxyConfigurationDetails(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.proxyConfigurationProperties = builder.proxyConfigurationProperties;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the container that will serve as the App Mesh proxy.
     * </p>
     * 
     * @return The name of the container that will serve as the App Mesh proxy.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProxyConfigurationProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProxyConfigurationProperties() {
        return proxyConfigurationProperties != null && !(proxyConfigurationProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin, specified
     * as key-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProxyConfigurationProperties} method.
     * </p>
     * 
     * @return The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin,
     *         specified as key-value pairs.
     */
    public final List<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails> proxyConfigurationProperties() {
        return proxyConfigurationProperties;
    }

    /**
     * <p>
     * The proxy type.
     * </p>
     * 
     * @return The proxy type.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProxyConfigurationProperties() ? proxyConfigurationProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionProxyConfigurationDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionProxyConfigurationDetails other = (AwsEcsTaskDefinitionProxyConfigurationDetails) obj;
        return Objects.equals(containerName(), other.containerName())
                && hasProxyConfigurationProperties() == other.hasProxyConfigurationProperties()
                && Objects.equals(proxyConfigurationProperties(), other.proxyConfigurationProperties())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionProxyConfigurationDetails").add("ContainerName", containerName())
                .add("ProxyConfigurationProperties", hasProxyConfigurationProperties() ? proxyConfigurationProperties() : null)
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "ProxyConfigurationProperties":
            return Optional.ofNullable(clazz.cast(proxyConfigurationProperties()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerName", CONTAINER_NAME_FIELD);
        map.put("ProxyConfigurationProperties", PROXY_CONFIGURATION_PROPERTIES_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionProxyConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionProxyConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDefinitionProxyConfigurationDetails> {
        /**
         * <p>
         * The name of the container that will serve as the App Mesh proxy.
         * </p>
         * 
         * @param containerName
         *        The name of the container that will serve as the App Mesh proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin,
         * specified as key-value pairs.
         * </p>
         * 
         * @param proxyConfigurationProperties
         *        The set of network configuration parameters to provide to the Container Network Interface (CNI)
         *        plugin, specified as key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationProperties(
                Collection<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails> proxyConfigurationProperties);

        /**
         * <p>
         * The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin,
         * specified as key-value pairs.
         * </p>
         * 
         * @param proxyConfigurationProperties
         *        The set of network configuration parameters to provide to the Container Network Interface (CNI)
         *        plugin, specified as key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationProperties(
                AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails... proxyConfigurationProperties);

        /**
         * <p>
         * The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin,
         * specified as key-value pairs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link 
         * #proxyConfigurationProperties(List<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
         * >)}.
         * 
         * @param proxyConfigurationProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxyConfigurationProperties(java.util.Collection<
         *      AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails>)
         */
        Builder proxyConfigurationProperties(
                Consumer<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.Builder>... proxyConfigurationProperties);

        /**
         * <p>
         * The proxy type.
         * </p>
         * 
         * @param type
         *        The proxy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String containerName;

        private List<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails> proxyConfigurationProperties = DefaultSdkAutoConstructList
                .getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionProxyConfigurationDetails model) {
            containerName(model.containerName);
            proxyConfigurationProperties(model.proxyConfigurationProperties);
            type(model.type);
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final List<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.Builder> getProxyConfigurationProperties() {
            List<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.Builder> result = AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesListCopier
                    .copyToBuilder(this.proxyConfigurationProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProxyConfigurationProperties(
                Collection<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.BuilderImpl> proxyConfigurationProperties) {
            this.proxyConfigurationProperties = AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesListCopier
                    .copyFromBuilder(proxyConfigurationProperties);
        }

        @Override
        public final Builder proxyConfigurationProperties(
                Collection<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails> proxyConfigurationProperties) {
            this.proxyConfigurationProperties = AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesListCopier
                    .copy(proxyConfigurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyConfigurationProperties(
                AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails... proxyConfigurationProperties) {
            proxyConfigurationProperties(Arrays.asList(proxyConfigurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyConfigurationProperties(
                Consumer<AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.Builder>... proxyConfigurationProperties) {
            proxyConfigurationProperties(Stream
                    .of(proxyConfigurationProperties)
                    .map(c -> AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.builder()
                            .applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionProxyConfigurationDetails build() {
            return new AwsEcsTaskDefinitionProxyConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
