/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A ulimit to set in the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails> {
    private static final SdkField<Integer> HARD_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HardLimit").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails::hardLimit))
            .setter(setter(Builder::hardLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HardLimit").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> SOFT_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SoftLimit").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails::softLimit))
            .setter(setter(Builder::softLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HARD_LIMIT_FIELD, NAME_FIELD,
            SOFT_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer hardLimit;

    private final String name;

    private final Integer softLimit;

    private AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(BuilderImpl builder) {
        this.hardLimit = builder.hardLimit;
        this.name = builder.name;
        this.softLimit = builder.softLimit;
    }

    /**
     * <p>
     * The hard limit for the ulimit type.
     * </p>
     * 
     * @return The hard limit for the ulimit type.
     */
    public final Integer hardLimit() {
        return hardLimit;
    }

    /**
     * <p>
     * The type of the ulimit. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>core</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cpu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>data</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fsize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>locks</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>memlock</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>msgqueue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>nice</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>nofile</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>nproc</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rss</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rtprio</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rttime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sigpending</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stack</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of the ulimit. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>core</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cpu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>data</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fsize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>locks</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>memlock</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>msgqueue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>nice</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>nofile</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>nproc</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rss</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rtprio</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rttime</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sigpending</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stack</code>
     *         </p>
     *         </li>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The soft limit for the ulimit type.
     * </p>
     * 
     * @return The soft limit for the ulimit type.
     */
    public final Integer softLimit() {
        return softLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(softLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) obj;
        return Objects.equals(hardLimit(), other.hardLimit()) && Objects.equals(name(), other.name())
                && Objects.equals(softLimit(), other.softLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails").add("HardLimit", hardLimit())
                .add("Name", name()).add("SoftLimit", softLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HardLimit":
            return Optional.ofNullable(clazz.cast(hardLimit()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SoftLimit":
            return Optional.ofNullable(clazz.cast(softLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HardLimit", HARD_LIMIT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("SoftLimit", SOFT_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails> {
        /**
         * <p>
         * The hard limit for the ulimit type.
         * </p>
         * 
         * @param hardLimit
         *        The hard limit for the ulimit type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardLimit(Integer hardLimit);

        /**
         * <p>
         * The type of the ulimit. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>core</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cpu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>data</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fsize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>locks</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>memlock</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>msgqueue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>nice</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>nofile</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>nproc</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rss</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rtprio</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rttime</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sigpending</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stack</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The type of the ulimit. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>core</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cpu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>data</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fsize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>locks</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>memlock</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>msgqueue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>nice</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>nofile</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>nproc</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rss</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rtprio</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rttime</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sigpending</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stack</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The soft limit for the ulimit type.
         * </p>
         * 
         * @param softLimit
         *        The soft limit for the ulimit type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softLimit(Integer softLimit);
    }

    static final class BuilderImpl implements Builder {
        private Integer hardLimit;

        private String name;

        private Integer softLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails model) {
            hardLimit(model.hardLimit);
            name(model.name);
            softLimit(model.softLimit);
        }

        public final Integer getHardLimit() {
            return hardLimit;
        }

        public final void setHardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
        }

        @Override
        public final Builder hardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getSoftLimit() {
            return softLimit;
        }

        public final void setSoftLimit(Integer softLimit) {
            this.softLimit = softLimit;
        }

        @Override
        public final Builder softLimit(Integer softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
