/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * &gt;Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails> {
    private static final SdkField<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails> CAPABILITIES_FIELD = SdkField
            .<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Capabilities")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails::capabilities))
            .setter(setter(Builder::capabilities))
            .constructor(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails>> DEVICES_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails>> builder(MarshallingType.LIST)
            .memberName("Devices")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INIT_PROCESS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InitProcessEnabled")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails::initProcessEnabled))
            .setter(setter(Builder::initProcessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitProcessEnabled").build())
            .build();

    private static final SdkField<Integer> MAX_SWAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSwap").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails::maxSwap))
            .setter(setter(Builder::maxSwap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSwap").build()).build();

    private static final SdkField<Integer> SHARED_MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SharedMemorySize")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails::sharedMemorySize))
            .setter(setter(Builder::sharedMemorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedMemorySize").build()).build();

    private static final SdkField<Integer> SWAPPINESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Swappiness").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails::swappiness))
            .setter(setter(Builder::swappiness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Swappiness").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails>> TMPFS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails>> builder(MarshallingType.LIST)
            .memberName("Tmpfs")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails::tmpfs))
            .setter(setter(Builder::tmpfs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tmpfs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITIES_FIELD,
            DEVICES_FIELD, INIT_PROCESS_ENABLED_FIELD, MAX_SWAP_FIELD, SHARED_MEMORY_SIZE_FIELD, SWAPPINESS_FIELD, TMPFS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails capabilities;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> devices;

    private final Boolean initProcessEnabled;

    private final Integer maxSwap;

    private final Integer sharedMemorySize;

    private final Integer swappiness;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> tmpfs;

    private AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(BuilderImpl builder) {
        this.capabilities = builder.capabilities;
        this.devices = builder.devices;
        this.initProcessEnabled = builder.initProcessEnabled;
        this.maxSwap = builder.maxSwap;
        this.sharedMemorySize = builder.sharedMemorySize;
        this.swappiness = builder.swappiness;
        this.tmpfs = builder.tmpfs;
    }

    /**
     * <p>
     * The Linux capabilities for the container that are added to or dropped from the default configuration provided by
     * Docker.
     * </p>
     * 
     * @return The Linux capabilities for the container that are added to or dropped from the default configuration
     *         provided by Docker.
     */
    public final AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails capabilities() {
        return capabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Devices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDevices() {
        return devices != null && !(devices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The host devices to expose to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevices} method.
     * </p>
     * 
     * @return The host devices to expose to the container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> devices() {
        return devices;
    }

    /**
     * <p>
     * Whether to run an <code>init</code> process inside the container that forwards signals and reaps processes.
     * </p>
     * 
     * @return Whether to run an <code>init</code> process inside the container that forwards signals and reaps
     *         processes.
     */
    public final Boolean initProcessEnabled() {
        return initProcessEnabled;
    }

    /**
     * <p>
     * The total amount of swap memory (in MiB) that a container can use.
     * </p>
     * 
     * @return The total amount of swap memory (in MiB) that a container can use.
     */
    public final Integer maxSwap() {
        return maxSwap;
    }

    /**
     * <p>
     * The value for the size (in MiB) of the <b>/dev/shm</b> volume.
     * </p>
     * 
     * @return The value for the size (in MiB) of the <b>/dev/shm</b> volume.
     */
    public final Integer sharedMemorySize() {
        return sharedMemorySize;
    }

    /**
     * <p>
     * Configures the container's memory swappiness behavior. Determines how aggressively pages are swapped. The higher
     * the value, the more aggressive the swappiness. The default is 60.
     * </p>
     * 
     * @return Configures the container's memory swappiness behavior. Determines how aggressively pages are swapped. The
     *         higher the value, the more aggressive the swappiness. The default is 60.
     */
    public final Integer swappiness() {
        return swappiness;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tmpfs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTmpfs() {
        return tmpfs != null && !(tmpfs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container path, mount options, and size (in MiB) of the tmpfs mount.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTmpfs} method.
     * </p>
     * 
     * @return The container path, mount options, and size (in MiB) of the tmpfs mount.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> tmpfs() {
        return tmpfs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(hasDevices() ? devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(initProcessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(maxSwap());
        hashCode = 31 * hashCode + Objects.hashCode(sharedMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(swappiness());
        hashCode = 31 * hashCode + Objects.hashCode(hasTmpfs() ? tmpfs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails other = (AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) obj;
        return Objects.equals(capabilities(), other.capabilities()) && hasDevices() == other.hasDevices()
                && Objects.equals(devices(), other.devices()) && Objects.equals(initProcessEnabled(), other.initProcessEnabled())
                && Objects.equals(maxSwap(), other.maxSwap()) && Objects.equals(sharedMemorySize(), other.sharedMemorySize())
                && Objects.equals(swappiness(), other.swappiness()) && hasTmpfs() == other.hasTmpfs()
                && Objects.equals(tmpfs(), other.tmpfs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails")
                .add("Capabilities", capabilities()).add("Devices", hasDevices() ? devices() : null)
                .add("InitProcessEnabled", initProcessEnabled()).add("MaxSwap", maxSwap())
                .add("SharedMemorySize", sharedMemorySize()).add("Swappiness", swappiness())
                .add("Tmpfs", hasTmpfs() ? tmpfs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "Devices":
            return Optional.ofNullable(clazz.cast(devices()));
        case "InitProcessEnabled":
            return Optional.ofNullable(clazz.cast(initProcessEnabled()));
        case "MaxSwap":
            return Optional.ofNullable(clazz.cast(maxSwap()));
        case "SharedMemorySize":
            return Optional.ofNullable(clazz.cast(sharedMemorySize()));
        case "Swappiness":
            return Optional.ofNullable(clazz.cast(swappiness()));
        case "Tmpfs":
            return Optional.ofNullable(clazz.cast(tmpfs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("Devices", DEVICES_FIELD);
        map.put("InitProcessEnabled", INIT_PROCESS_ENABLED_FIELD);
        map.put("MaxSwap", MAX_SWAP_FIELD);
        map.put("SharedMemorySize", SHARED_MEMORY_SIZE_FIELD);
        map.put("Swappiness", SWAPPINESS_FIELD);
        map.put("Tmpfs", TMPFS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails> {
        /**
         * <p>
         * The Linux capabilities for the container that are added to or dropped from the default configuration provided
         * by Docker.
         * </p>
         * 
         * @param capabilities
         *        The Linux capabilities for the container that are added to or dropped from the default configuration
         *        provided by Docker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails capabilities);

        /**
         * <p>
         * The Linux capabilities for the container that are added to or dropped from the default configuration provided
         * by Docker.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.Builder} avoiding the need
         * to create one manually via
         * {@link AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #capabilities(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails)
         */
        default Builder capabilities(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.Builder> capabilities) {
            return capabilities(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.builder()
                    .applyMutation(capabilities).build());
        }

        /**
         * <p>
         * The host devices to expose to the container.
         * </p>
         * 
         * @param devices
         *        The host devices to expose to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> devices);

        /**
         * <p>
         * The host devices to expose to the container.
         * </p>
         * 
         * @param devices
         *        The host devices to expose to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails... devices);

        /**
         * <p>
         * The host devices to expose to the container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #devices(List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails>)}.
         * 
         * @param devices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(java.util.Collection<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails>)
         */
        Builder devices(Consumer<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.Builder>... devices);

        /**
         * <p>
         * Whether to run an <code>init</code> process inside the container that forwards signals and reaps processes.
         * </p>
         * 
         * @param initProcessEnabled
         *        Whether to run an <code>init</code> process inside the container that forwards signals and reaps
         *        processes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initProcessEnabled(Boolean initProcessEnabled);

        /**
         * <p>
         * The total amount of swap memory (in MiB) that a container can use.
         * </p>
         * 
         * @param maxSwap
         *        The total amount of swap memory (in MiB) that a container can use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSwap(Integer maxSwap);

        /**
         * <p>
         * The value for the size (in MiB) of the <b>/dev/shm</b> volume.
         * </p>
         * 
         * @param sharedMemorySize
         *        The value for the size (in MiB) of the <b>/dev/shm</b> volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedMemorySize(Integer sharedMemorySize);

        /**
         * <p>
         * Configures the container's memory swappiness behavior. Determines how aggressively pages are swapped. The
         * higher the value, the more aggressive the swappiness. The default is 60.
         * </p>
         * 
         * @param swappiness
         *        Configures the container's memory swappiness behavior. Determines how aggressively pages are swapped.
         *        The higher the value, the more aggressive the swappiness. The default is 60.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder swappiness(Integer swappiness);

        /**
         * <p>
         * The container path, mount options, and size (in MiB) of the tmpfs mount.
         * </p>
         * 
         * @param tmpfs
         *        The container path, mount options, and size (in MiB) of the tmpfs mount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tmpfs(Collection<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> tmpfs);

        /**
         * <p>
         * The container path, mount options, and size (in MiB) of the tmpfs mount.
         * </p>
         * 
         * @param tmpfs
         *        The container path, mount options, and size (in MiB) of the tmpfs mount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tmpfs(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails... tmpfs);

        /**
         * <p>
         * The container path, mount options, and size (in MiB) of the tmpfs mount.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #tmpfs(List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails>)}.
         * 
         * @param tmpfs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tmpfs(java.util.Collection<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails>)
         */
        Builder tmpfs(Consumer<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.Builder>... tmpfs);
    }

    static final class BuilderImpl implements Builder {
        private AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails capabilities;

        private List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> devices = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean initProcessEnabled;

        private Integer maxSwap;

        private Integer sharedMemorySize;

        private Integer swappiness;

        private List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> tmpfs = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails model) {
            capabilities(model.capabilities);
            devices(model.devices);
            initProcessEnabled(model.initProcessEnabled);
            maxSwap(model.maxSwap);
            sharedMemorySize(model.sharedMemorySize);
            swappiness(model.swappiness);
            tmpfs(model.tmpfs);
        }

        public final AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(
                AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.Builder> getDevices() {
            List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesListCopier
                    .copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevices(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.BuilderImpl> devices) {
            this.devices = AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesListCopier.copyFromBuilder(devices);
        }

        @Override
        public final Builder devices(Collection<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> devices) {
            this.devices = AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.Builder>... devices) {
            devices(Stream
                    .of(devices)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.builder().applyMutation(c)
                            .build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getInitProcessEnabled() {
            return initProcessEnabled;
        }

        public final void setInitProcessEnabled(Boolean initProcessEnabled) {
            this.initProcessEnabled = initProcessEnabled;
        }

        @Override
        public final Builder initProcessEnabled(Boolean initProcessEnabled) {
            this.initProcessEnabled = initProcessEnabled;
            return this;
        }

        public final Integer getMaxSwap() {
            return maxSwap;
        }

        public final void setMaxSwap(Integer maxSwap) {
            this.maxSwap = maxSwap;
        }

        @Override
        public final Builder maxSwap(Integer maxSwap) {
            this.maxSwap = maxSwap;
            return this;
        }

        public final Integer getSharedMemorySize() {
            return sharedMemorySize;
        }

        public final void setSharedMemorySize(Integer sharedMemorySize) {
            this.sharedMemorySize = sharedMemorySize;
        }

        @Override
        public final Builder sharedMemorySize(Integer sharedMemorySize) {
            this.sharedMemorySize = sharedMemorySize;
            return this;
        }

        public final Integer getSwappiness() {
            return swappiness;
        }

        public final void setSwappiness(Integer swappiness) {
            this.swappiness = swappiness;
        }

        @Override
        public final Builder swappiness(Integer swappiness) {
            this.swappiness = swappiness;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.Builder> getTmpfs() {
            List<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsListCopier
                    .copyToBuilder(this.tmpfs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTmpfs(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.BuilderImpl> tmpfs) {
            this.tmpfs = AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsListCopier.copyFromBuilder(tmpfs);
        }

        @Override
        public final Builder tmpfs(Collection<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> tmpfs) {
            this.tmpfs = AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsListCopier.copy(tmpfs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tmpfs(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails... tmpfs) {
            tmpfs(Arrays.asList(tmpfs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tmpfs(Consumer<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.Builder>... tmpfs) {
            tmpfs(Stream
                    .of(tmpfs)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.builder().applyMutation(c)
                            .build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
