/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The FireLens configuration for the container. The configuration specifies and configures a log router for container
 * logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails> {
    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Options")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> options;

    private final String type;

    private AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(BuilderImpl builder) {
        this.options = builder.options;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The options to use to configure the log router.
     * </p>
     * <p>
     * The valid option keys are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>enable-ecs-log-metadata</code>. The value can be <code>true</code> or <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>config-file-type</code>. The value can be <code>s3</code> or <code>file</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>config-file-value</code>. The value is either an S3 ARN or a file path.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The options to use to configure the log router.</p>
     *         <p>
     *         The valid option keys are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>enable-ecs-log-metadata</code>. The value can be <code>true</code> or <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>config-file-type</code>. The value can be <code>s3</code> or <code>file</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>config-file-value</code>. The value is either an S3 ARN or a file path.
     *         </p>
     *         </li>
     */
    public final Map<String, String> options() {
        return options;
    }

    /**
     * <p>
     * The log router to use. Valid values are <code>fluentbit</code> or <code>fluentd</code>.
     * </p>
     * 
     * @return The log router to use. Valid values are <code>fluentbit</code> or <code>fluentd</code>.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails other = (AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) obj;
        return hasOptions() == other.hasOptions() && Objects.equals(options(), other.options())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails")
                .add("Options", hasOptions() ? options() : null).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Options", OPTIONS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails> {
        /**
         * <p>
         * The options to use to configure the log router.
         * </p>
         * <p>
         * The valid option keys are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>enable-ecs-log-metadata</code>. The value can be <code>true</code> or <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>config-file-type</code>. The value can be <code>s3</code> or <code>file</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>config-file-value</code>. The value is either an S3 ARN or a file path.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        The options to use to configure the log router.</p>
         *        <p>
         *        The valid option keys are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>enable-ecs-log-metadata</code>. The value can be <code>true</code> or <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>config-file-type</code>. The value can be <code>s3</code> or <code>file</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>config-file-value</code>. The value is either an S3 ARN or a file path.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Map<String, String> options);

        /**
         * <p>
         * The log router to use. Valid values are <code>fluentbit</code> or <code>fluentd</code>.
         * </p>
         * 
         * @param type
         *        The log router to use. Valid values are <code>fluentbit</code> or <code>fluentd</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails model) {
            options(model.options);
            type(model.type);
        }

        public final Map<String, String> getOptions() {
            if (options instanceof SdkAutoConstructMap) {
                return null;
            }
            return options;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = FieldMapCopier.copy(options);
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = FieldMapCopier.copy(options);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
