/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The VPN tunnel options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VpnConnectionOptionsTunnelOptionsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder, AwsEc2VpnConnectionOptionsTunnelOptionsDetails> {
    private static final SdkField<Integer> DPD_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DpdTimeoutSeconds").getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::dpdTimeoutSeconds))
            .setter(setter(Builder::dpdTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpdTimeoutSeconds").build()).build();

    private static final SdkField<List<String>> IKE_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IkeVersions")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::ikeVersions))
            .setter(setter(Builder::ikeVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IkeVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OUTSIDE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutsideIpAddress").getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::outsideIpAddress))
            .setter(setter(Builder::outsideIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddress").build()).build();

    private static final SdkField<List<Integer>> PHASE1_DH_GROUP_NUMBERS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Phase1DhGroupNumbers")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase1DhGroupNumbers))
            .setter(setter(Builder::phase1DhGroupNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1DhGroupNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PHASE1_ENCRYPTION_ALGORITHMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Phase1EncryptionAlgorithms")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase1EncryptionAlgorithms))
            .setter(setter(Builder::phase1EncryptionAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1EncryptionAlgorithms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PHASE1_INTEGRITY_ALGORITHMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Phase1IntegrityAlgorithms")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase1IntegrityAlgorithms))
            .setter(setter(Builder::phase1IntegrityAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1IntegrityAlgorithms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PHASE1_LIFETIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Phase1LifetimeSeconds")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase1LifetimeSeconds))
            .setter(setter(Builder::phase1LifetimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1LifetimeSeconds").build())
            .build();

    private static final SdkField<List<Integer>> PHASE2_DH_GROUP_NUMBERS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Phase2DhGroupNumbers")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase2DhGroupNumbers))
            .setter(setter(Builder::phase2DhGroupNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2DhGroupNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PHASE2_ENCRYPTION_ALGORITHMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Phase2EncryptionAlgorithms")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase2EncryptionAlgorithms))
            .setter(setter(Builder::phase2EncryptionAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2EncryptionAlgorithms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PHASE2_INTEGRITY_ALGORITHMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Phase2IntegrityAlgorithms")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase2IntegrityAlgorithms))
            .setter(setter(Builder::phase2IntegrityAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2IntegrityAlgorithms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PHASE2_LIFETIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Phase2LifetimeSeconds")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase2LifetimeSeconds))
            .setter(setter(Builder::phase2LifetimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2LifetimeSeconds").build())
            .build();

    private static final SdkField<String> PRE_SHARED_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreSharedKey").getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::preSharedKey))
            .setter(setter(Builder::preSharedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSharedKey").build()).build();

    private static final SdkField<Integer> REKEY_FUZZ_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RekeyFuzzPercentage")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::rekeyFuzzPercentage))
            .setter(setter(Builder::rekeyFuzzPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyFuzzPercentage").build())
            .build();

    private static final SdkField<Integer> REKEY_MARGIN_TIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RekeyMarginTimeSeconds")
            .getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::rekeyMarginTimeSeconds))
            .setter(setter(Builder::rekeyMarginTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyMarginTimeSeconds").build())
            .build();

    private static final SdkField<Integer> REPLAY_WINDOW_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplayWindowSize").getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::replayWindowSize))
            .setter(setter(Builder::replayWindowSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayWindowSize").build()).build();

    private static final SdkField<String> TUNNEL_INSIDE_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TunnelInsideCidr").getter(getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::tunnelInsideCidr))
            .setter(setter(Builder::tunnelInsideCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DPD_TIMEOUT_SECONDS_FIELD,
            IKE_VERSIONS_FIELD, OUTSIDE_IP_ADDRESS_FIELD, PHASE1_DH_GROUP_NUMBERS_FIELD, PHASE1_ENCRYPTION_ALGORITHMS_FIELD,
            PHASE1_INTEGRITY_ALGORITHMS_FIELD, PHASE1_LIFETIME_SECONDS_FIELD, PHASE2_DH_GROUP_NUMBERS_FIELD,
            PHASE2_ENCRYPTION_ALGORITHMS_FIELD, PHASE2_INTEGRITY_ALGORITHMS_FIELD, PHASE2_LIFETIME_SECONDS_FIELD,
            PRE_SHARED_KEY_FIELD, REKEY_FUZZ_PERCENTAGE_FIELD, REKEY_MARGIN_TIME_SECONDS_FIELD, REPLAY_WINDOW_SIZE_FIELD,
            TUNNEL_INSIDE_CIDR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dpdTimeoutSeconds;

    private final List<String> ikeVersions;

    private final String outsideIpAddress;

    private final List<Integer> phase1DhGroupNumbers;

    private final List<String> phase1EncryptionAlgorithms;

    private final List<String> phase1IntegrityAlgorithms;

    private final Integer phase1LifetimeSeconds;

    private final List<Integer> phase2DhGroupNumbers;

    private final List<String> phase2EncryptionAlgorithms;

    private final List<String> phase2IntegrityAlgorithms;

    private final Integer phase2LifetimeSeconds;

    private final String preSharedKey;

    private final Integer rekeyFuzzPercentage;

    private final Integer rekeyMarginTimeSeconds;

    private final Integer replayWindowSize;

    private final String tunnelInsideCidr;

    private AwsEc2VpnConnectionOptionsTunnelOptionsDetails(BuilderImpl builder) {
        this.dpdTimeoutSeconds = builder.dpdTimeoutSeconds;
        this.ikeVersions = builder.ikeVersions;
        this.outsideIpAddress = builder.outsideIpAddress;
        this.phase1DhGroupNumbers = builder.phase1DhGroupNumbers;
        this.phase1EncryptionAlgorithms = builder.phase1EncryptionAlgorithms;
        this.phase1IntegrityAlgorithms = builder.phase1IntegrityAlgorithms;
        this.phase1LifetimeSeconds = builder.phase1LifetimeSeconds;
        this.phase2DhGroupNumbers = builder.phase2DhGroupNumbers;
        this.phase2EncryptionAlgorithms = builder.phase2EncryptionAlgorithms;
        this.phase2IntegrityAlgorithms = builder.phase2IntegrityAlgorithms;
        this.phase2LifetimeSeconds = builder.phase2LifetimeSeconds;
        this.preSharedKey = builder.preSharedKey;
        this.rekeyFuzzPercentage = builder.rekeyFuzzPercentage;
        this.rekeyMarginTimeSeconds = builder.rekeyMarginTimeSeconds;
        this.replayWindowSize = builder.replayWindowSize;
        this.tunnelInsideCidr = builder.tunnelInsideCidr;
    }

    /**
     * <p>
     * The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
     * </p>
     * 
     * @return The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
     */
    public final Integer dpdTimeoutSeconds() {
        return dpdTimeoutSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the IkeVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIkeVersions() {
        return ikeVersions != null && !(ikeVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIkeVersions} method.
     * </p>
     * 
     * @return The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
     */
    public final List<String> ikeVersions() {
        return ikeVersions;
    }

    /**
     * <p>
     * The external IP address of the VPN tunnel.
     * </p>
     * 
     * @return The external IP address of the VPN tunnel.
     */
    public final String outsideIpAddress() {
        return outsideIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase1DhGroupNumbers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhase1DhGroupNumbers() {
        return phase1DhGroupNumbers != null && !(phase1DhGroupNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase1DhGroupNumbers} method.
     * </p>
     * 
     * @return The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
     */
    public final List<Integer> phase1DhGroupNumbers() {
        return phase1DhGroupNumbers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase1EncryptionAlgorithms property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhase1EncryptionAlgorithms() {
        return phase1EncryptionAlgorithms != null && !(phase1EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase1EncryptionAlgorithms} method.
     * </p>
     * 
     * @return The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
     */
    public final List<String> phase1EncryptionAlgorithms() {
        return phase1EncryptionAlgorithms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase1IntegrityAlgorithms property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhase1IntegrityAlgorithms() {
        return phase1IntegrityAlgorithms != null && !(phase1IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase1IntegrityAlgorithms} method.
     * </p>
     * 
     * @return The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
     */
    public final List<String> phase1IntegrityAlgorithms() {
        return phase1IntegrityAlgorithms;
    }

    /**
     * <p>
     * The lifetime for phase 1 of the IKE negotiation, in seconds.
     * </p>
     * 
     * @return The lifetime for phase 1 of the IKE negotiation, in seconds.
     */
    public final Integer phase1LifetimeSeconds() {
        return phase1LifetimeSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase2DhGroupNumbers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhase2DhGroupNumbers() {
        return phase2DhGroupNumbers != null && !(phase2DhGroupNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase2DhGroupNumbers} method.
     * </p>
     * 
     * @return The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
     */
    public final List<Integer> phase2DhGroupNumbers() {
        return phase2DhGroupNumbers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase2EncryptionAlgorithms property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhase2EncryptionAlgorithms() {
        return phase2EncryptionAlgorithms != null && !(phase2EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase2EncryptionAlgorithms} method.
     * </p>
     * 
     * @return The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
     */
    public final List<String> phase2EncryptionAlgorithms() {
        return phase2EncryptionAlgorithms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase2IntegrityAlgorithms property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhase2IntegrityAlgorithms() {
        return phase2IntegrityAlgorithms != null && !(phase2IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase2IntegrityAlgorithms} method.
     * </p>
     * 
     * @return The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
     */
    public final List<String> phase2IntegrityAlgorithms() {
        return phase2IntegrityAlgorithms;
    }

    /**
     * <p>
     * The lifetime for phase 2 of the IKE negotiation, in seconds.
     * </p>
     * 
     * @return The lifetime for phase 2 of the IKE negotiation, in seconds.
     */
    public final Integer phase2LifetimeSeconds() {
        return phase2LifetimeSeconds;
    }

    /**
     * <p>
     * The preshared key to establish initial authentication between the virtual private gateway and the customer
     * gateway.
     * </p>
     * 
     * @return The preshared key to establish initial authentication between the virtual private gateway and the
     *         customer gateway.
     */
    public final String preSharedKey() {
        return preSharedKey;
    }

    /**
     * <p>
     * The percentage of the rekey window, which is determined by <code>RekeyMarginTimeSeconds</code> during which the
     * rekey time is randomly selected.
     * </p>
     * 
     * @return The percentage of the rekey window, which is determined by <code>RekeyMarginTimeSeconds</code> during
     *         which the rekey time is randomly selected.
     */
    public final Integer rekeyFuzzPercentage() {
        return rekeyFuzzPercentage;
    }

    /**
     * <p>
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services side of
     * the VPN connection performs an IKE rekey.
     * </p>
     * 
     * @return The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services
     *         side of the VPN connection performs an IKE rekey.
     */
    public final Integer rekeyMarginTimeSeconds() {
        return rekeyMarginTimeSeconds;
    }

    /**
     * <p>
     * The number of packets in an IKE replay window.
     * </p>
     * 
     * @return The number of packets in an IKE replay window.
     */
    public final Integer replayWindowSize() {
        return replayWindowSize;
    }

    /**
     * <p>
     * The range of inside IPv4 addresses for the tunnel.
     * </p>
     * 
     * @return The range of inside IPv4 addresses for the tunnel.
     */
    public final String tunnelInsideCidr() {
        return tunnelInsideCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dpdTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasIkeVersions() ? ikeVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1DhGroupNumbers() ? phase1DhGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1EncryptionAlgorithms() ? phase1EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1IntegrityAlgorithms() ? phase1IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(phase1LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2DhGroupNumbers() ? phase2DhGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2EncryptionAlgorithms() ? phase2EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2IntegrityAlgorithms() ? phase2IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(phase2LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(preSharedKey());
        hashCode = 31 * hashCode + Objects.hashCode(rekeyFuzzPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(rekeyMarginTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(replayWindowSize());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelInsideCidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpnConnectionOptionsTunnelOptionsDetails)) {
            return false;
        }
        AwsEc2VpnConnectionOptionsTunnelOptionsDetails other = (AwsEc2VpnConnectionOptionsTunnelOptionsDetails) obj;
        return Objects.equals(dpdTimeoutSeconds(), other.dpdTimeoutSeconds()) && hasIkeVersions() == other.hasIkeVersions()
                && Objects.equals(ikeVersions(), other.ikeVersions())
                && Objects.equals(outsideIpAddress(), other.outsideIpAddress())
                && hasPhase1DhGroupNumbers() == other.hasPhase1DhGroupNumbers()
                && Objects.equals(phase1DhGroupNumbers(), other.phase1DhGroupNumbers())
                && hasPhase1EncryptionAlgorithms() == other.hasPhase1EncryptionAlgorithms()
                && Objects.equals(phase1EncryptionAlgorithms(), other.phase1EncryptionAlgorithms())
                && hasPhase1IntegrityAlgorithms() == other.hasPhase1IntegrityAlgorithms()
                && Objects.equals(phase1IntegrityAlgorithms(), other.phase1IntegrityAlgorithms())
                && Objects.equals(phase1LifetimeSeconds(), other.phase1LifetimeSeconds())
                && hasPhase2DhGroupNumbers() == other.hasPhase2DhGroupNumbers()
                && Objects.equals(phase2DhGroupNumbers(), other.phase2DhGroupNumbers())
                && hasPhase2EncryptionAlgorithms() == other.hasPhase2EncryptionAlgorithms()
                && Objects.equals(phase2EncryptionAlgorithms(), other.phase2EncryptionAlgorithms())
                && hasPhase2IntegrityAlgorithms() == other.hasPhase2IntegrityAlgorithms()
                && Objects.equals(phase2IntegrityAlgorithms(), other.phase2IntegrityAlgorithms())
                && Objects.equals(phase2LifetimeSeconds(), other.phase2LifetimeSeconds())
                && Objects.equals(preSharedKey(), other.preSharedKey())
                && Objects.equals(rekeyFuzzPercentage(), other.rekeyFuzzPercentage())
                && Objects.equals(rekeyMarginTimeSeconds(), other.rekeyMarginTimeSeconds())
                && Objects.equals(replayWindowSize(), other.replayWindowSize())
                && Objects.equals(tunnelInsideCidr(), other.tunnelInsideCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VpnConnectionOptionsTunnelOptionsDetails").add("DpdTimeoutSeconds", dpdTimeoutSeconds())
                .add("IkeVersions", hasIkeVersions() ? ikeVersions() : null).add("OutsideIpAddress", outsideIpAddress())
                .add("Phase1DhGroupNumbers", hasPhase1DhGroupNumbers() ? phase1DhGroupNumbers() : null)
                .add("Phase1EncryptionAlgorithms", hasPhase1EncryptionAlgorithms() ? phase1EncryptionAlgorithms() : null)
                .add("Phase1IntegrityAlgorithms", hasPhase1IntegrityAlgorithms() ? phase1IntegrityAlgorithms() : null)
                .add("Phase1LifetimeSeconds", phase1LifetimeSeconds())
                .add("Phase2DhGroupNumbers", hasPhase2DhGroupNumbers() ? phase2DhGroupNumbers() : null)
                .add("Phase2EncryptionAlgorithms", hasPhase2EncryptionAlgorithms() ? phase2EncryptionAlgorithms() : null)
                .add("Phase2IntegrityAlgorithms", hasPhase2IntegrityAlgorithms() ? phase2IntegrityAlgorithms() : null)
                .add("Phase2LifetimeSeconds", phase2LifetimeSeconds()).add("PreSharedKey", preSharedKey())
                .add("RekeyFuzzPercentage", rekeyFuzzPercentage()).add("RekeyMarginTimeSeconds", rekeyMarginTimeSeconds())
                .add("ReplayWindowSize", replayWindowSize()).add("TunnelInsideCidr", tunnelInsideCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DpdTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(dpdTimeoutSeconds()));
        case "IkeVersions":
            return Optional.ofNullable(clazz.cast(ikeVersions()));
        case "OutsideIpAddress":
            return Optional.ofNullable(clazz.cast(outsideIpAddress()));
        case "Phase1DhGroupNumbers":
            return Optional.ofNullable(clazz.cast(phase1DhGroupNumbers()));
        case "Phase1EncryptionAlgorithms":
            return Optional.ofNullable(clazz.cast(phase1EncryptionAlgorithms()));
        case "Phase1IntegrityAlgorithms":
            return Optional.ofNullable(clazz.cast(phase1IntegrityAlgorithms()));
        case "Phase1LifetimeSeconds":
            return Optional.ofNullable(clazz.cast(phase1LifetimeSeconds()));
        case "Phase2DhGroupNumbers":
            return Optional.ofNullable(clazz.cast(phase2DhGroupNumbers()));
        case "Phase2EncryptionAlgorithms":
            return Optional.ofNullable(clazz.cast(phase2EncryptionAlgorithms()));
        case "Phase2IntegrityAlgorithms":
            return Optional.ofNullable(clazz.cast(phase2IntegrityAlgorithms()));
        case "Phase2LifetimeSeconds":
            return Optional.ofNullable(clazz.cast(phase2LifetimeSeconds()));
        case "PreSharedKey":
            return Optional.ofNullable(clazz.cast(preSharedKey()));
        case "RekeyFuzzPercentage":
            return Optional.ofNullable(clazz.cast(rekeyFuzzPercentage()));
        case "RekeyMarginTimeSeconds":
            return Optional.ofNullable(clazz.cast(rekeyMarginTimeSeconds()));
        case "ReplayWindowSize":
            return Optional.ofNullable(clazz.cast(replayWindowSize()));
        case "TunnelInsideCidr":
            return Optional.ofNullable(clazz.cast(tunnelInsideCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DpdTimeoutSeconds", DPD_TIMEOUT_SECONDS_FIELD);
        map.put("IkeVersions", IKE_VERSIONS_FIELD);
        map.put("OutsideIpAddress", OUTSIDE_IP_ADDRESS_FIELD);
        map.put("Phase1DhGroupNumbers", PHASE1_DH_GROUP_NUMBERS_FIELD);
        map.put("Phase1EncryptionAlgorithms", PHASE1_ENCRYPTION_ALGORITHMS_FIELD);
        map.put("Phase1IntegrityAlgorithms", PHASE1_INTEGRITY_ALGORITHMS_FIELD);
        map.put("Phase1LifetimeSeconds", PHASE1_LIFETIME_SECONDS_FIELD);
        map.put("Phase2DhGroupNumbers", PHASE2_DH_GROUP_NUMBERS_FIELD);
        map.put("Phase2EncryptionAlgorithms", PHASE2_ENCRYPTION_ALGORITHMS_FIELD);
        map.put("Phase2IntegrityAlgorithms", PHASE2_INTEGRITY_ALGORITHMS_FIELD);
        map.put("Phase2LifetimeSeconds", PHASE2_LIFETIME_SECONDS_FIELD);
        map.put("PreSharedKey", PRE_SHARED_KEY_FIELD);
        map.put("RekeyFuzzPercentage", REKEY_FUZZ_PERCENTAGE_FIELD);
        map.put("RekeyMarginTimeSeconds", REKEY_MARGIN_TIME_SECONDS_FIELD);
        map.put("ReplayWindowSize", REPLAY_WINDOW_SIZE_FIELD);
        map.put("TunnelInsideCidr", TUNNEL_INSIDE_CIDR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpnConnectionOptionsTunnelOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2VpnConnectionOptionsTunnelOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VpnConnectionOptionsTunnelOptionsDetails> {
        /**
         * <p>
         * The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
         * </p>
         * 
         * @param dpdTimeoutSeconds
         *        The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds);

        /**
         * <p>
         * The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
         * </p>
         * 
         * @param ikeVersions
         *        The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ikeVersions(Collection<String> ikeVersions);

        /**
         * <p>
         * The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
         * </p>
         * 
         * @param ikeVersions
         *        The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ikeVersions(String... ikeVersions);

        /**
         * <p>
         * The external IP address of the VPN tunnel.
         * </p>
         * 
         * @param outsideIpAddress
         *        The external IP address of the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outsideIpAddress(String outsideIpAddress);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1DhGroupNumbers
         *        The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1DhGroupNumbers(Collection<Integer> phase1DhGroupNumbers);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1DhGroupNumbers
         *        The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1DhGroupNumbers(Integer... phase1DhGroupNumbers);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1EncryptionAlgorithms
         *        The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1EncryptionAlgorithms(Collection<String> phase1EncryptionAlgorithms);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1EncryptionAlgorithms
         *        The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1EncryptionAlgorithms(String... phase1EncryptionAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1IntegrityAlgorithms
         *        The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1IntegrityAlgorithms(Collection<String> phase1IntegrityAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1IntegrityAlgorithms
         *        The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1IntegrityAlgorithms(String... phase1IntegrityAlgorithms);

        /**
         * <p>
         * The lifetime for phase 1 of the IKE negotiation, in seconds.
         * </p>
         * 
         * @param phase1LifetimeSeconds
         *        The lifetime for phase 1 of the IKE negotiation, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2DhGroupNumbers
         *        The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2DhGroupNumbers(Collection<Integer> phase2DhGroupNumbers);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2DhGroupNumbers
         *        The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2DhGroupNumbers(Integer... phase2DhGroupNumbers);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2EncryptionAlgorithms
         *        The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2EncryptionAlgorithms(Collection<String> phase2EncryptionAlgorithms);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2EncryptionAlgorithms
         *        The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2EncryptionAlgorithms(String... phase2EncryptionAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2IntegrityAlgorithms
         *        The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2IntegrityAlgorithms(Collection<String> phase2IntegrityAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2IntegrityAlgorithms
         *        The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2IntegrityAlgorithms(String... phase2IntegrityAlgorithms);

        /**
         * <p>
         * The lifetime for phase 2 of the IKE negotiation, in seconds.
         * </p>
         * 
         * @param phase2LifetimeSeconds
         *        The lifetime for phase 2 of the IKE negotiation, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds);

        /**
         * <p>
         * The preshared key to establish initial authentication between the virtual private gateway and the customer
         * gateway.
         * </p>
         * 
         * @param preSharedKey
         *        The preshared key to establish initial authentication between the virtual private gateway and the
         *        customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSharedKey(String preSharedKey);

        /**
         * <p>
         * The percentage of the rekey window, which is determined by <code>RekeyMarginTimeSeconds</code> during which
         * the rekey time is randomly selected.
         * </p>
         * 
         * @param rekeyFuzzPercentage
         *        The percentage of the rekey window, which is determined by <code>RekeyMarginTimeSeconds</code> during
         *        which the rekey time is randomly selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage);

        /**
         * <p>
         * The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services side
         * of the VPN connection performs an IKE rekey.
         * </p>
         * 
         * @param rekeyMarginTimeSeconds
         *        The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services
         *        side of the VPN connection performs an IKE rekey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds);

        /**
         * <p>
         * The number of packets in an IKE replay window.
         * </p>
         * 
         * @param replayWindowSize
         *        The number of packets in an IKE replay window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayWindowSize(Integer replayWindowSize);

        /**
         * <p>
         * The range of inside IPv4 addresses for the tunnel.
         * </p>
         * 
         * @param tunnelInsideCidr
         *        The range of inside IPv4 addresses for the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelInsideCidr(String tunnelInsideCidr);
    }

    static final class BuilderImpl implements Builder {
        private Integer dpdTimeoutSeconds;

        private List<String> ikeVersions = DefaultSdkAutoConstructList.getInstance();

        private String outsideIpAddress;

        private List<Integer> phase1DhGroupNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<String> phase1EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private List<String> phase1IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private Integer phase1LifetimeSeconds;

        private List<Integer> phase2DhGroupNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<String> phase2EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private List<String> phase2IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private Integer phase2LifetimeSeconds;

        private String preSharedKey;

        private Integer rekeyFuzzPercentage;

        private Integer rekeyMarginTimeSeconds;

        private Integer replayWindowSize;

        private String tunnelInsideCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpnConnectionOptionsTunnelOptionsDetails model) {
            dpdTimeoutSeconds(model.dpdTimeoutSeconds);
            ikeVersions(model.ikeVersions);
            outsideIpAddress(model.outsideIpAddress);
            phase1DhGroupNumbers(model.phase1DhGroupNumbers);
            phase1EncryptionAlgorithms(model.phase1EncryptionAlgorithms);
            phase1IntegrityAlgorithms(model.phase1IntegrityAlgorithms);
            phase1LifetimeSeconds(model.phase1LifetimeSeconds);
            phase2DhGroupNumbers(model.phase2DhGroupNumbers);
            phase2EncryptionAlgorithms(model.phase2EncryptionAlgorithms);
            phase2IntegrityAlgorithms(model.phase2IntegrityAlgorithms);
            phase2LifetimeSeconds(model.phase2LifetimeSeconds);
            preSharedKey(model.preSharedKey);
            rekeyFuzzPercentage(model.rekeyFuzzPercentage);
            rekeyMarginTimeSeconds(model.rekeyMarginTimeSeconds);
            replayWindowSize(model.replayWindowSize);
            tunnelInsideCidr(model.tunnelInsideCidr);
        }

        public final Integer getDpdTimeoutSeconds() {
            return dpdTimeoutSeconds;
        }

        public final void setDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        }

        @Override
        public final Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
            return this;
        }

        public final Collection<String> getIkeVersions() {
            if (ikeVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return ikeVersions;
        }

        public final void setIkeVersions(Collection<String> ikeVersions) {
            this.ikeVersions = NonEmptyStringListCopier.copy(ikeVersions);
        }

        @Override
        public final Builder ikeVersions(Collection<String> ikeVersions) {
            this.ikeVersions = NonEmptyStringListCopier.copy(ikeVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(String... ikeVersions) {
            ikeVersions(Arrays.asList(ikeVersions));
            return this;
        }

        public final String getOutsideIpAddress() {
            return outsideIpAddress;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final Collection<Integer> getPhase1DhGroupNumbers() {
            if (phase1DhGroupNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return phase1DhGroupNumbers;
        }

        public final void setPhase1DhGroupNumbers(Collection<Integer> phase1DhGroupNumbers) {
            this.phase1DhGroupNumbers = IntegerListCopier.copy(phase1DhGroupNumbers);
        }

        @Override
        public final Builder phase1DhGroupNumbers(Collection<Integer> phase1DhGroupNumbers) {
            this.phase1DhGroupNumbers = IntegerListCopier.copy(phase1DhGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DhGroupNumbers(Integer... phase1DhGroupNumbers) {
            phase1DhGroupNumbers(Arrays.asList(phase1DhGroupNumbers));
            return this;
        }

        public final Collection<String> getPhase1EncryptionAlgorithms() {
            if (phase1EncryptionAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return phase1EncryptionAlgorithms;
        }

        public final void setPhase1EncryptionAlgorithms(Collection<String> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = NonEmptyStringListCopier.copy(phase1EncryptionAlgorithms);
        }

        @Override
        public final Builder phase1EncryptionAlgorithms(Collection<String> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = NonEmptyStringListCopier.copy(phase1EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(String... phase1EncryptionAlgorithms) {
            phase1EncryptionAlgorithms(Arrays.asList(phase1EncryptionAlgorithms));
            return this;
        }

        public final Collection<String> getPhase1IntegrityAlgorithms() {
            if (phase1IntegrityAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return phase1IntegrityAlgorithms;
        }

        public final void setPhase1IntegrityAlgorithms(Collection<String> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = NonEmptyStringListCopier.copy(phase1IntegrityAlgorithms);
        }

        @Override
        public final Builder phase1IntegrityAlgorithms(Collection<String> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = NonEmptyStringListCopier.copy(phase1IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(String... phase1IntegrityAlgorithms) {
            phase1IntegrityAlgorithms(Arrays.asList(phase1IntegrityAlgorithms));
            return this;
        }

        public final Integer getPhase1LifetimeSeconds() {
            return phase1LifetimeSeconds;
        }

        public final void setPhase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
        }

        @Override
        public final Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
            return this;
        }

        public final Collection<Integer> getPhase2DhGroupNumbers() {
            if (phase2DhGroupNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return phase2DhGroupNumbers;
        }

        public final void setPhase2DhGroupNumbers(Collection<Integer> phase2DhGroupNumbers) {
            this.phase2DhGroupNumbers = IntegerListCopier.copy(phase2DhGroupNumbers);
        }

        @Override
        public final Builder phase2DhGroupNumbers(Collection<Integer> phase2DhGroupNumbers) {
            this.phase2DhGroupNumbers = IntegerListCopier.copy(phase2DhGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DhGroupNumbers(Integer... phase2DhGroupNumbers) {
            phase2DhGroupNumbers(Arrays.asList(phase2DhGroupNumbers));
            return this;
        }

        public final Collection<String> getPhase2EncryptionAlgorithms() {
            if (phase2EncryptionAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return phase2EncryptionAlgorithms;
        }

        public final void setPhase2EncryptionAlgorithms(Collection<String> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = NonEmptyStringListCopier.copy(phase2EncryptionAlgorithms);
        }

        @Override
        public final Builder phase2EncryptionAlgorithms(Collection<String> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = NonEmptyStringListCopier.copy(phase2EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(String... phase2EncryptionAlgorithms) {
            phase2EncryptionAlgorithms(Arrays.asList(phase2EncryptionAlgorithms));
            return this;
        }

        public final Collection<String> getPhase2IntegrityAlgorithms() {
            if (phase2IntegrityAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return phase2IntegrityAlgorithms;
        }

        public final void setPhase2IntegrityAlgorithms(Collection<String> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = NonEmptyStringListCopier.copy(phase2IntegrityAlgorithms);
        }

        @Override
        public final Builder phase2IntegrityAlgorithms(Collection<String> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = NonEmptyStringListCopier.copy(phase2IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(String... phase2IntegrityAlgorithms) {
            phase2IntegrityAlgorithms(Arrays.asList(phase2IntegrityAlgorithms));
            return this;
        }

        public final Integer getPhase2LifetimeSeconds() {
            return phase2LifetimeSeconds;
        }

        public final void setPhase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
        }

        @Override
        public final Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
            return this;
        }

        public final String getPreSharedKey() {
            return preSharedKey;
        }

        public final void setPreSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
        }

        @Override
        public final Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        public final Integer getRekeyFuzzPercentage() {
            return rekeyFuzzPercentage;
        }

        public final void setRekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
        }

        @Override
        public final Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
            return this;
        }

        public final Integer getRekeyMarginTimeSeconds() {
            return rekeyMarginTimeSeconds;
        }

        public final void setRekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
        }

        @Override
        public final Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
            return this;
        }

        public final Integer getReplayWindowSize() {
            return replayWindowSize;
        }

        public final void setReplayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
        }

        @Override
        public final Builder replayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
            return this;
        }

        public final String getTunnelInsideCidr() {
            return tunnelInsideCidr;
        }

        public final void setTunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        @Override
        public final Builder tunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        @Override
        public AwsEc2VpnConnectionOptionsTunnelOptionsDetails build() {
            return new AwsEc2VpnConnectionOptionsTunnelOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
