/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an EC2 VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VpcDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VpcDetails.Builder, AwsEc2VpcDetails> {
    private static final SdkField<List<CidrBlockAssociation>> CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField
            .<List<CidrBlockAssociation>> builder(MarshallingType.LIST)
            .memberName("CidrBlockAssociationSet")
            .getter(getter(AwsEc2VpcDetails::cidrBlockAssociationSet))
            .setter(setter(Builder::cidrBlockAssociationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CidrBlockAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(CidrBlockAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Ipv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField
            .<List<Ipv6CidrBlockAssociation>> builder(MarshallingType.LIST)
            .memberName("Ipv6CidrBlockAssociationSet")
            .getter(getter(AwsEc2VpcDetails::ipv6CidrBlockAssociationSet))
            .setter(setter(Builder::ipv6CidrBlockAssociationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ipv6CidrBlockAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6CidrBlockAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DhcpOptionsId").getter(getter(AwsEc2VpcDetails::dhcpOptionsId)).setter(setter(Builder::dhcpOptionsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AwsEc2VpcDetails::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CIDR_BLOCK_ASSOCIATION_SET_FIELD, IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD, DHCP_OPTIONS_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CidrBlockAssociation> cidrBlockAssociationSet;

    private final List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private final String dhcpOptionsId;

    private final String state;

    private AwsEc2VpcDetails(BuilderImpl builder) {
        this.cidrBlockAssociationSet = builder.cidrBlockAssociationSet;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.state = builder.state;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrBlockAssociationSet property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCidrBlockAssociationSet() {
        return cidrBlockAssociationSet != null && !(cidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv4 CIDR blocks associated with the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrBlockAssociationSet} method.
     * </p>
     * 
     * @return Information about the IPv4 CIDR blocks associated with the VPC.
     */
    public final List<CidrBlockAssociation> cidrBlockAssociationSet() {
        return cidrBlockAssociationSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6CidrBlockAssociationSet property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet != null && !(ipv6CidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv6 CIDR blocks associated with the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6CidrBlockAssociationSet} method.
     * </p>
     * 
     * @return Information about the IPv6 CIDR blocks associated with the VPC.
     */
    public final List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet;
    }

    /**
     * <p>
     * The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options that are associated with the VPC.
     * If the default options are associated with the VPC, then this is default.
     * </p>
     * 
     * @return The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options that are associated with
     *         the VPC. If the default options are associated with the VPC, then this is default.
     */
    public final String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    /**
     * <p>
     * The current state of the VPC. Valid values are <code>available</code> or <code>pending</code>.
     * </p>
     * 
     * @return The current state of the VPC. Valid values are <code>available</code> or <code>pending</code>.
     */
    public final String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrBlockAssociationSet() ? cidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6CidrBlockAssociationSet() ? ipv6CidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpcDetails)) {
            return false;
        }
        AwsEc2VpcDetails other = (AwsEc2VpcDetails) obj;
        return hasCidrBlockAssociationSet() == other.hasCidrBlockAssociationSet()
                && Objects.equals(cidrBlockAssociationSet(), other.cidrBlockAssociationSet())
                && hasIpv6CidrBlockAssociationSet() == other.hasIpv6CidrBlockAssociationSet()
                && Objects.equals(ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet())
                && Objects.equals(dhcpOptionsId(), other.dhcpOptionsId()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VpcDetails")
                .add("CidrBlockAssociationSet", hasCidrBlockAssociationSet() ? cidrBlockAssociationSet() : null)
                .add("Ipv6CidrBlockAssociationSet", hasIpv6CidrBlockAssociationSet() ? ipv6CidrBlockAssociationSet() : null)
                .add("DhcpOptionsId", dhcpOptionsId()).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlockAssociationSet":
            return Optional.ofNullable(clazz.cast(cidrBlockAssociationSet()));
        case "Ipv6CidrBlockAssociationSet":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockAssociationSet()));
        case "DhcpOptionsId":
            return Optional.ofNullable(clazz.cast(dhcpOptionsId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CidrBlockAssociationSet", CIDR_BLOCK_ASSOCIATION_SET_FIELD);
        map.put("Ipv6CidrBlockAssociationSet", IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD);
        map.put("DhcpOptionsId", DHCP_OPTIONS_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpcDetails, T> g) {
        return obj -> g.apply((AwsEc2VpcDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VpcDetails> {
        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param cidrBlockAssociationSet
         *        Information about the IPv4 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockAssociationSet(Collection<CidrBlockAssociation> cidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param cidrBlockAssociationSet
         *        Information about the IPv4 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockAssociationSet(CidrBlockAssociation... cidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #cidrBlockAssociationSet(List<CidrBlockAssociation>)}.
         * 
         * @param cidrBlockAssociationSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlockAssociationSet(java.util.Collection<CidrBlockAssociation>)
         */
        Builder cidrBlockAssociationSet(Consumer<CidrBlockAssociation.Builder>... cidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Ipv6CidrBlockAssociation... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6CidrBlockAssociationSet(List<Ipv6CidrBlockAssociation>)}.
         * 
         * @param ipv6CidrBlockAssociationSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockAssociationSet(java.util.Collection<Ipv6CidrBlockAssociation>)
         */
        Builder ipv6CidrBlockAssociationSet(Consumer<Ipv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options that are associated with the
         * VPC. If the default options are associated with the VPC, then this is default.
         * </p>
         * 
         * @param dhcpOptionsId
         *        The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options that are associated
         *        with the VPC. If the default options are associated with the VPC, then this is default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);

        /**
         * <p>
         * The current state of the VPC. Valid values are <code>available</code> or <code>pending</code>.
         * </p>
         * 
         * @param state
         *        The current state of the VPC. Valid values are <code>available</code> or <code>pending</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private List<CidrBlockAssociation> cidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();

        private List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();

        private String dhcpOptionsId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpcDetails model) {
            cidrBlockAssociationSet(model.cidrBlockAssociationSet);
            ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            dhcpOptionsId(model.dhcpOptionsId);
            state(model.state);
        }

        public final List<CidrBlockAssociation.Builder> getCidrBlockAssociationSet() {
            List<CidrBlockAssociation.Builder> result = CidrBlockAssociationListCopier
                    .copyToBuilder(this.cidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlockAssociationSet(Collection<CidrBlockAssociation.BuilderImpl> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = CidrBlockAssociationListCopier.copyFromBuilder(cidrBlockAssociationSet);
        }

        @Override
        public final Builder cidrBlockAssociationSet(Collection<CidrBlockAssociation> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = CidrBlockAssociationListCopier.copy(cidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(CidrBlockAssociation... cidrBlockAssociationSet) {
            cidrBlockAssociationSet(Arrays.asList(cidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(Consumer<CidrBlockAssociation.Builder>... cidrBlockAssociationSet) {
            cidrBlockAssociationSet(Stream.of(cidrBlockAssociationSet)
                    .map(c -> CidrBlockAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Ipv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            List<Ipv6CidrBlockAssociation.Builder> result = Ipv6CidrBlockAssociationListCopier
                    .copyToBuilder(this.ipv6CidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockAssociationSet(
                Collection<Ipv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = Ipv6CidrBlockAssociationListCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = Ipv6CidrBlockAssociationListCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Ipv6CidrBlockAssociation... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(
                Consumer<Ipv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet)
                    .map(c -> Ipv6CidrBlockAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public AwsEc2VpcDetails build() {
            return new AwsEc2VpcDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
