/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a subnet in Amazon EC2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2SubnetDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2SubnetDetails.Builder, AwsEc2SubnetDetails> {
    private static final SdkField<Boolean> ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssignIpv6AddressOnCreation")
            .getter(getter(AwsEc2SubnetDetails::assignIpv6AddressOnCreation))
            .setter(setter(Builder::assignIpv6AddressOnCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignIpv6AddressOnCreation")
                    .build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(AwsEc2SubnetDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId").getter(getter(AwsEc2SubnetDetails::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_IP_ADDRESS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableIpAddressCount").getter(getter(AwsEc2SubnetDetails::availableIpAddressCount))
            .setter(setter(Builder::availableIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableIpAddressCount").build())
            .build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock").getter(getter(AwsEc2SubnetDetails::cidrBlock)).setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").build()).build();

    private static final SdkField<Boolean> DEFAULT_FOR_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultForAz").getter(getter(AwsEc2SubnetDetails::defaultForAz)).setter(setter(Builder::defaultForAz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultForAz").build()).build();

    private static final SdkField<Boolean> MAP_PUBLIC_IP_ON_LAUNCH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MapPublicIpOnLaunch").getter(getter(AwsEc2SubnetDetails::mapPublicIpOnLaunch))
            .setter(setter(Builder::mapPublicIpOnLaunch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapPublicIpOnLaunch").build())
            .build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(AwsEc2SubnetDetails::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AwsEc2SubnetDetails::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetArn").getter(getter(AwsEc2SubnetDetails::subnetArn)).setter(setter(Builder::subnetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(AwsEc2SubnetDetails::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsEc2SubnetDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<Ipv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField
            .<List<Ipv6CidrBlockAssociation>> builder(MarshallingType.LIST)
            .memberName("Ipv6CidrBlockAssociationSet")
            .getter(getter(AwsEc2SubnetDetails::ipv6CidrBlockAssociationSet))
            .setter(setter(Builder::ipv6CidrBlockAssociationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ipv6CidrBlockAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6CidrBlockAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD,
            AVAILABLE_IP_ADDRESS_COUNT_FIELD, CIDR_BLOCK_FIELD, DEFAULT_FOR_AZ_FIELD, MAP_PUBLIC_IP_ON_LAUNCH_FIELD,
            OWNER_ID_FIELD, STATE_FIELD, SUBNET_ARN_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD, IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean assignIpv6AddressOnCreation;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Integer availableIpAddressCount;

    private final String cidrBlock;

    private final Boolean defaultForAz;

    private final Boolean mapPublicIpOnLaunch;

    private final String ownerId;

    private final String state;

    private final String subnetArn;

    private final String subnetId;

    private final String vpcId;

    private final List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private AwsEc2SubnetDetails(BuilderImpl builder) {
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availableIpAddressCount = builder.availableIpAddressCount;
        this.cidrBlock = builder.cidrBlock;
        this.defaultForAz = builder.defaultForAz;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.subnetArn = builder.subnetArn;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
    }

    /**
     * <p>
     * Whether to assign an IPV6 address to a network interface that is created in this subnet.
     * </p>
     * 
     * @return Whether to assign an IPV6 address to a network interface that is created in this subnet.
     */
    public final Boolean assignIpv6AddressOnCreation() {
        return assignIpv6AddressOnCreation;
    }

    /**
     * <p>
     * The Availability Zone for the subnet.
     * </p>
     * 
     * @return The Availability Zone for the subnet.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The identifier of the Availability Zone for the subnet.
     * </p>
     * 
     * @return The identifier of the Availability Zone for the subnet.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The number of available IPV4 addresses in the subnet. Does not include addresses for stopped instances.
     * </p>
     * 
     * @return The number of available IPV4 addresses in the subnet. Does not include addresses for stopped instances.
     */
    public final Integer availableIpAddressCount() {
        return availableIpAddressCount;
    }

    /**
     * <p>
     * The IPV4 CIDR block that is assigned to the subnet.
     * </p>
     * 
     * @return The IPV4 CIDR block that is assigned to the subnet.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Whether this subnet is the default subnet for the Availability Zone.
     * </p>
     * 
     * @return Whether this subnet is the default subnet for the Availability Zone.
     */
    public final Boolean defaultForAz() {
        return defaultForAz;
    }

    /**
     * <p>
     * Whether instances in this subnet receive a public IP address.
     * </p>
     * 
     * @return Whether instances in this subnet receive a public IP address.
     */
    public final Boolean mapPublicIpOnLaunch() {
        return mapPublicIpOnLaunch;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account that owns the subnet.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account that owns the subnet.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The current state of the subnet. Valid values are <code>available</code> or <code>pending</code>.
     * </p>
     * 
     * @return The current state of the subnet. Valid values are <code>available</code> or <code>pending</code>.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The ARN of the subnet.
     * </p>
     * 
     * @return The ARN of the subnet.
     */
    public final String subnetArn() {
        return subnetArn;
    }

    /**
     * <p>
     * The identifier of the subnet.
     * </p>
     * 
     * @return The identifier of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The identifier of the VPC that contains the subnet.
     * </p>
     * 
     * @return The identifier of the VPC that contains the subnet.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6CidrBlockAssociationSet property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet != null && !(ipv6CidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPV6 CIDR blocks that are associated with the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6CidrBlockAssociationSet} method.
     * </p>
     * 
     * @return The IPV6 CIDR blocks that are associated with the subnet.
     */
    public final List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(availableIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(defaultForAz());
        hashCode = 31 * hashCode + Objects.hashCode(mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(subnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6CidrBlockAssociationSet() ? ipv6CidrBlockAssociationSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2SubnetDetails)) {
            return false;
        }
        AwsEc2SubnetDetails other = (AwsEc2SubnetDetails) obj;
        return Objects.equals(assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(availableIpAddressCount(), other.availableIpAddressCount())
                && Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(defaultForAz(), other.defaultForAz())
                && Objects.equals(mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(state(), other.state())
                && Objects.equals(subnetArn(), other.subnetArn()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId())
                && hasIpv6CidrBlockAssociationSet() == other.hasIpv6CidrBlockAssociationSet()
                && Objects.equals(ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2SubnetDetails").add("AssignIpv6AddressOnCreation", assignIpv6AddressOnCreation())
                .add("AvailabilityZone", availabilityZone()).add("AvailabilityZoneId", availabilityZoneId())
                .add("AvailableIpAddressCount", availableIpAddressCount()).add("CidrBlock", cidrBlock())
                .add("DefaultForAz", defaultForAz()).add("MapPublicIpOnLaunch", mapPublicIpOnLaunch()).add("OwnerId", ownerId())
                .add("State", state()).add("SubnetArn", subnetArn()).add("SubnetId", subnetId()).add("VpcId", vpcId())
                .add("Ipv6CidrBlockAssociationSet", hasIpv6CidrBlockAssociationSet() ? ipv6CidrBlockAssociationSet() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignIpv6AddressOnCreation":
            return Optional.ofNullable(clazz.cast(assignIpv6AddressOnCreation()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "AvailableIpAddressCount":
            return Optional.ofNullable(clazz.cast(availableIpAddressCount()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "DefaultForAz":
            return Optional.ofNullable(clazz.cast(defaultForAz()));
        case "MapPublicIpOnLaunch":
            return Optional.ofNullable(clazz.cast(mapPublicIpOnLaunch()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "SubnetArn":
            return Optional.ofNullable(clazz.cast(subnetArn()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Ipv6CidrBlockAssociationSet":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockAssociationSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssignIpv6AddressOnCreation", ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("AvailableIpAddressCount", AVAILABLE_IP_ADDRESS_COUNT_FIELD);
        map.put("CidrBlock", CIDR_BLOCK_FIELD);
        map.put("DefaultForAz", DEFAULT_FOR_AZ_FIELD);
        map.put("MapPublicIpOnLaunch", MAP_PUBLIC_IP_ON_LAUNCH_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("SubnetArn", SUBNET_ARN_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("Ipv6CidrBlockAssociationSet", IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2SubnetDetails, T> g) {
        return obj -> g.apply((AwsEc2SubnetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2SubnetDetails> {
        /**
         * <p>
         * Whether to assign an IPV6 address to a network interface that is created in this subnet.
         * </p>
         * 
         * @param assignIpv6AddressOnCreation
         *        Whether to assign an IPV6 address to a network interface that is created in this subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation);

        /**
         * <p>
         * The Availability Zone for the subnet.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The identifier of the Availability Zone for the subnet.
         * </p>
         * 
         * @param availabilityZoneId
         *        The identifier of the Availability Zone for the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The number of available IPV4 addresses in the subnet. Does not include addresses for stopped instances.
         * </p>
         * 
         * @param availableIpAddressCount
         *        The number of available IPV4 addresses in the subnet. Does not include addresses for stopped
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableIpAddressCount(Integer availableIpAddressCount);

        /**
         * <p>
         * The IPV4 CIDR block that is assigned to the subnet.
         * </p>
         * 
         * @param cidrBlock
         *        The IPV4 CIDR block that is assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Whether this subnet is the default subnet for the Availability Zone.
         * </p>
         * 
         * @param defaultForAz
         *        Whether this subnet is the default subnet for the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultForAz(Boolean defaultForAz);

        /**
         * <p>
         * Whether instances in this subnet receive a public IP address.
         * </p>
         * 
         * @param mapPublicIpOnLaunch
         *        Whether instances in this subnet receive a public IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch);

        /**
         * <p>
         * The identifier of the Amazon Web Services account that owns the subnet.
         * </p>
         * 
         * @param ownerId
         *        The identifier of the Amazon Web Services account that owns the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The current state of the subnet. Valid values are <code>available</code> or <code>pending</code>.
         * </p>
         * 
         * @param state
         *        The current state of the subnet. Valid values are <code>available</code> or <code>pending</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The ARN of the subnet.
         * </p>
         * 
         * @param subnetArn
         *        The ARN of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArn(String subnetArn);

        /**
         * <p>
         * The identifier of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The identifier of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The identifier of the VPC that contains the subnet.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC that contains the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The IPV6 CIDR blocks that are associated with the subnet.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        The IPV6 CIDR blocks that are associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * The IPV6 CIDR blocks that are associated with the subnet.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        The IPV6 CIDR blocks that are associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Ipv6CidrBlockAssociation... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * The IPV6 CIDR blocks that are associated with the subnet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6CidrBlockAssociationSet(List<Ipv6CidrBlockAssociation>)}.
         * 
         * @param ipv6CidrBlockAssociationSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockAssociationSet(java.util.Collection<Ipv6CidrBlockAssociation>)
         */
        Builder ipv6CidrBlockAssociationSet(Consumer<Ipv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet);
    }

    static final class BuilderImpl implements Builder {
        private Boolean assignIpv6AddressOnCreation;

        private String availabilityZone;

        private String availabilityZoneId;

        private Integer availableIpAddressCount;

        private String cidrBlock;

        private Boolean defaultForAz;

        private Boolean mapPublicIpOnLaunch;

        private String ownerId;

        private String state;

        private String subnetArn;

        private String subnetId;

        private String vpcId;

        private List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2SubnetDetails model) {
            assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            availableIpAddressCount(model.availableIpAddressCount);
            cidrBlock(model.cidrBlock);
            defaultForAz(model.defaultForAz);
            mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            ownerId(model.ownerId);
            state(model.state);
            subnetArn(model.subnetArn);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return assignIpv6AddressOnCreation;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Integer getAvailableIpAddressCount() {
            return availableIpAddressCount;
        }

        public final void setAvailableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
        }

        @Override
        public final Builder availableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final Boolean getDefaultForAz() {
            return defaultForAz;
        }

        public final void setDefaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
        }

        @Override
        public final Builder defaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
            return this;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return mapPublicIpOnLaunch;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getSubnetArn() {
            return subnetArn;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<Ipv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            List<Ipv6CidrBlockAssociation.Builder> result = Ipv6CidrBlockAssociationListCopier
                    .copyToBuilder(this.ipv6CidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockAssociationSet(
                Collection<Ipv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = Ipv6CidrBlockAssociationListCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = Ipv6CidrBlockAssociationListCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Ipv6CidrBlockAssociation... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(
                Consumer<Ipv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet)
                    .map(c -> Ipv6CidrBlockAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEc2SubnetDetails build() {
            return new AwsEc2SubnetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
