/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule for the network ACL. Each rule allows or denies access based on the IP address, traffic direction, port, and
 * protocol.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2NetworkAclEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2NetworkAclEntry.Builder, AwsEc2NetworkAclEntry> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock").getter(getter(AwsEc2NetworkAclEntry::cidrBlock)).setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").build()).build();

    private static final SdkField<Boolean> EGRESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Egress").getter(getter(AwsEc2NetworkAclEntry::egress)).setter(setter(Builder::egress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress").build()).build();

    private static final SdkField<IcmpTypeCode> ICMP_TYPE_CODE_FIELD = SdkField.<IcmpTypeCode> builder(MarshallingType.SDK_POJO)
            .memberName("IcmpTypeCode").getter(getter(AwsEc2NetworkAclEntry::icmpTypeCode)).setter(setter(Builder::icmpTypeCode))
            .constructor(IcmpTypeCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IcmpTypeCode").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock").getter(getter(AwsEc2NetworkAclEntry::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").build()).build();

    private static final SdkField<PortRangeFromTo> PORT_RANGE_FIELD = SdkField
            .<PortRangeFromTo> builder(MarshallingType.SDK_POJO).memberName("PortRange")
            .getter(getter(AwsEc2NetworkAclEntry::portRange)).setter(setter(Builder::portRange))
            .constructor(PortRangeFromTo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AwsEc2NetworkAclEntry::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleAction").getter(getter(AwsEc2NetworkAclEntry::ruleAction)).setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleNumber").getter(getter(AwsEc2NetworkAclEntry::ruleNumber)).setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD,
            EGRESS_FIELD, ICMP_TYPE_CODE_FIELD, IPV6_CIDR_BLOCK_FIELD, PORT_RANGE_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD,
            RULE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cidrBlock;

    private final Boolean egress;

    private final IcmpTypeCode icmpTypeCode;

    private final String ipv6CidrBlock;

    private final PortRangeFromTo portRange;

    private final String protocol;

    private final String ruleAction;

    private final Integer ruleNumber;

    private AwsEc2NetworkAclEntry(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    /**
     * <p>
     * The IPV4 network range for which to deny or allow access.
     * </p>
     * 
     * @return The IPV4 network range for which to deny or allow access.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Whether the rule is an egress rule. An egress rule is a rule that applies to traffic that leaves the subnet.
     * </p>
     * 
     * @return Whether the rule is an egress rule. An egress rule is a rule that applies to traffic that leaves the
     *         subnet.
     */
    public final Boolean egress() {
        return egress;
    }

    /**
     * <p>
     * The Internet Control Message Protocol (ICMP) type and code for which to deny or allow access.
     * </p>
     * 
     * @return The Internet Control Message Protocol (ICMP) type and code for which to deny or allow access.
     */
    public final IcmpTypeCode icmpTypeCode() {
        return icmpTypeCode;
    }

    /**
     * <p>
     * The IPV6 network range for which to deny or allow access.
     * </p>
     * 
     * @return The IPV6 network range for which to deny or allow access.
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * For TCP or UDP protocols, the range of ports that the rule applies to.
     * </p>
     * 
     * @return For TCP or UDP protocols, the range of ports that the rule applies to.
     */
    public final PortRangeFromTo portRange() {
        return portRange;
    }

    /**
     * <p>
     * The protocol that the rule applies to. To deny or allow access to all protocols, use the value <code>-1</code>.
     * </p>
     * 
     * @return The protocol that the rule applies to. To deny or allow access to all protocols, use the value
     *         <code>-1</code>.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Whether the rule is used to allow access or deny access.
     * </p>
     * 
     * @return Whether the rule is used to allow access or deny access.
     */
    public final String ruleAction() {
        return ruleAction;
    }

    /**
     * <p>
     * The rule number. The rules are processed in order by their number.
     * </p>
     * 
     * @return The rule number. The rules are processed in order by their number.
     */
    public final Integer ruleNumber() {
        return ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(egress());
        hashCode = 31 * hashCode + Objects.hashCode(icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(portRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(ruleAction());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkAclEntry)) {
            return false;
        }
        AwsEc2NetworkAclEntry other = (AwsEc2NetworkAclEntry) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(egress(), other.egress())
                && Objects.equals(icmpTypeCode(), other.icmpTypeCode()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(portRange(), other.portRange()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(ruleAction(), other.ruleAction()) && Objects.equals(ruleNumber(), other.ruleNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2NetworkAclEntry").add("CidrBlock", cidrBlock()).add("Egress", egress())
                .add("IcmpTypeCode", icmpTypeCode()).add("Ipv6CidrBlock", ipv6CidrBlock()).add("PortRange", portRange())
                .add("Protocol", protocol()).add("RuleAction", ruleAction()).add("RuleNumber", ruleNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "Egress":
            return Optional.ofNullable(clazz.cast(egress()));
        case "IcmpTypeCode":
            return Optional.ofNullable(clazz.cast(icmpTypeCode()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "PortRange":
            return Optional.ofNullable(clazz.cast(portRange()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleAction()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CidrBlock", CIDR_BLOCK_FIELD);
        map.put("Egress", EGRESS_FIELD);
        map.put("IcmpTypeCode", ICMP_TYPE_CODE_FIELD);
        map.put("Ipv6CidrBlock", IPV6_CIDR_BLOCK_FIELD);
        map.put("PortRange", PORT_RANGE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("RuleAction", RULE_ACTION_FIELD);
        map.put("RuleNumber", RULE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkAclEntry, T> g) {
        return obj -> g.apply((AwsEc2NetworkAclEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2NetworkAclEntry> {
        /**
         * <p>
         * The IPV4 network range for which to deny or allow access.
         * </p>
         * 
         * @param cidrBlock
         *        The IPV4 network range for which to deny or allow access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Whether the rule is an egress rule. An egress rule is a rule that applies to traffic that leaves the subnet.
         * </p>
         * 
         * @param egress
         *        Whether the rule is an egress rule. An egress rule is a rule that applies to traffic that leaves the
         *        subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(Boolean egress);

        /**
         * <p>
         * The Internet Control Message Protocol (ICMP) type and code for which to deny or allow access.
         * </p>
         * 
         * @param icmpTypeCode
         *        The Internet Control Message Protocol (ICMP) type and code for which to deny or allow access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icmpTypeCode(IcmpTypeCode icmpTypeCode);

        /**
         * <p>
         * The Internet Control Message Protocol (ICMP) type and code for which to deny or allow access.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcmpTypeCode.Builder} avoiding the need
         * to create one manually via {@link IcmpTypeCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcmpTypeCode.Builder#build()} is called immediately and its
         * result is passed to {@link #icmpTypeCode(IcmpTypeCode)}.
         * 
         * @param icmpTypeCode
         *        a consumer that will call methods on {@link IcmpTypeCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icmpTypeCode(IcmpTypeCode)
         */
        default Builder icmpTypeCode(Consumer<IcmpTypeCode.Builder> icmpTypeCode) {
            return icmpTypeCode(IcmpTypeCode.builder().applyMutation(icmpTypeCode).build());
        }

        /**
         * <p>
         * The IPV6 network range for which to deny or allow access.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPV6 network range for which to deny or allow access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * For TCP or UDP protocols, the range of ports that the rule applies to.
         * </p>
         * 
         * @param portRange
         *        For TCP or UDP protocols, the range of ports that the rule applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRangeFromTo portRange);

        /**
         * <p>
         * For TCP or UDP protocols, the range of ports that the rule applies to.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortRangeFromTo.Builder} avoiding the
         * need to create one manually via {@link PortRangeFromTo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortRangeFromTo.Builder#build()} is called immediately and its
         * result is passed to {@link #portRange(PortRangeFromTo)}.
         * 
         * @param portRange
         *        a consumer that will call methods on {@link PortRangeFromTo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRange(PortRangeFromTo)
         */
        default Builder portRange(Consumer<PortRangeFromTo.Builder> portRange) {
            return portRange(PortRangeFromTo.builder().applyMutation(portRange).build());
        }

        /**
         * <p>
         * The protocol that the rule applies to. To deny or allow access to all protocols, use the value
         * <code>-1</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol that the rule applies to. To deny or allow access to all protocols, use the value
         *        <code>-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Whether the rule is used to allow access or deny access.
         * </p>
         * 
         * @param ruleAction
         *        Whether the rule is used to allow access or deny access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * The rule number. The rules are processed in order by their number.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number. The rules are processed in order by their number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);
    }

    static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private Boolean egress;

        private IcmpTypeCode icmpTypeCode;

        private String ipv6CidrBlock;

        private PortRangeFromTo portRange;

        private String protocol;

        private String ruleAction;

        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkAclEntry model) {
            cidrBlock(model.cidrBlock);
            egress(model.egress);
            icmpTypeCode(model.icmpTypeCode);
            ipv6CidrBlock(model.ipv6CidrBlock);
            portRange(model.portRange);
            protocol(model.protocol);
            ruleAction(model.ruleAction);
            ruleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final Boolean getEgress() {
            return egress;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return icmpTypeCode != null ? icmpTypeCode.toBuilder() : null;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final PortRangeFromTo.Builder getPortRange() {
            return portRange != null ? portRange.toBuilder() : null;
        }

        public final void setPortRange(PortRangeFromTo.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        @Override
        public final Builder portRange(PortRangeFromTo portRange) {
            this.portRange = portRange;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        @Override
        public AwsEc2NetworkAclEntry build() {
            return new AwsEc2NetworkAclEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
