/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the market (purchasing) options for Spot Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder, AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails> {
    private static final SdkField<Integer> BLOCK_DURATION_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockDurationMinutes")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails::blockDurationMinutes))
            .setter(setter(Builder::blockDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDurationMinutes").build())
            .build();

    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceInterruptionBehavior")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails::instanceInterruptionBehavior))
            .setter(setter(Builder::instanceInterruptionBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior")
                    .build()).build();

    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxPrice").getter(getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails::maxPrice))
            .setter(setter(Builder::maxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()).build();

    private static final SdkField<String> SPOT_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpotInstanceType")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails::spotInstanceType))
            .setter(setter(Builder::spotInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceType").build()).build();

    private static final SdkField<String> VALID_UNTIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidUntil").getter(getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails::validUntil))
            .setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DURATION_MINUTES_FIELD,
            INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, MAX_PRICE_FIELD, SPOT_INSTANCE_TYPE_FIELD, VALID_UNTIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer blockDurationMinutes;

    private final String instanceInterruptionBehavior;

    private final String maxPrice;

    private final String spotInstanceType;

    private final String validUntil;

    private AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails(BuilderImpl builder) {
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.maxPrice = builder.maxPrice;
        this.spotInstanceType = builder.spotInstanceType;
        this.validUntil = builder.validUntil;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public final Integer blockDurationMinutes() {
        return blockDurationMinutes;
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted.
     */
    public final String instanceInterruptionBehavior() {
        return instanceInterruptionBehavior;
    }

    /**
     * <p>
     * The maximum hourly price you're willing to pay for the Spot Instances.
     * </p>
     * 
     * @return The maximum hourly price you're willing to pay for the Spot Instances.
     */
    public final String maxPrice() {
        return maxPrice;
    }

    /**
     * <p>
     * The Spot Instance request type.
     * </p>
     * 
     * @return The Spot Instance request type.
     */
    public final String spotInstanceType() {
        return spotInstanceType;
    }

    /**
     * <p>
     * The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ), for persistent requests.
     * </p>
     * 
     * @return The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ), for persistent requests.
     */
    public final String validUntil() {
        return validUntil;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInterruptionBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails other = (AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) obj;
        return Objects.equals(blockDurationMinutes(), other.blockDurationMinutes())
                && Objects.equals(instanceInterruptionBehavior(), other.instanceInterruptionBehavior())
                && Objects.equals(maxPrice(), other.maxPrice()) && Objects.equals(spotInstanceType(), other.spotInstanceType())
                && Objects.equals(validUntil(), other.validUntil());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails")
                .add("BlockDurationMinutes", blockDurationMinutes())
                .add("InstanceInterruptionBehavior", instanceInterruptionBehavior()).add("MaxPrice", maxPrice())
                .add("SpotInstanceType", spotInstanceType()).add("ValidUntil", validUntil()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDurationMinutes":
            return Optional.ofNullable(clazz.cast(blockDurationMinutes()));
        case "InstanceInterruptionBehavior":
            return Optional.ofNullable(clazz.cast(instanceInterruptionBehavior()));
        case "MaxPrice":
            return Optional.ofNullable(clazz.cast(maxPrice()));
        case "SpotInstanceType":
            return Optional.ofNullable(clazz.cast(spotInstanceType()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlockDurationMinutes", BLOCK_DURATION_MINUTES_FIELD);
        map.put("InstanceInterruptionBehavior", INSTANCE_INTERRUPTION_BEHAVIOR_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("SpotInstanceType", SPOT_INSTANCE_TYPE_FIELD);
        map.put("ValidUntil", VALID_UNTIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails> {
        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param blockDurationMinutes
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDurationMinutes(Integer blockDurationMinutes);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInterruptionBehavior(String instanceInterruptionBehavior);

        /**
         * <p>
         * The maximum hourly price you're willing to pay for the Spot Instances.
         * </p>
         * 
         * @param maxPrice
         *        The maximum hourly price you're willing to pay for the Spot Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPrice(String maxPrice);

        /**
         * <p>
         * The Spot Instance request type.
         * </p>
         * 
         * @param spotInstanceType
         *        The Spot Instance request type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceType(String spotInstanceType);

        /**
         * <p>
         * The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ), for persistent requests.
         * </p>
         * 
         * @param validUntil
         *        The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ), for persistent requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(String validUntil);
    }

    static final class BuilderImpl implements Builder {
        private Integer blockDurationMinutes;

        private String instanceInterruptionBehavior;

        private String maxPrice;

        private String spotInstanceType;

        private String validUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails model) {
            blockDurationMinutes(model.blockDurationMinutes);
            instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            maxPrice(model.maxPrice);
            spotInstanceType(model.spotInstanceType);
            validUntil(model.validUntil);
        }

        public final Integer getBlockDurationMinutes() {
            return blockDurationMinutes;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final String getInstanceInterruptionBehavior() {
            return instanceInterruptionBehavior;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        public final String getMaxPrice() {
            return maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getSpotInstanceType() {
            return spotInstanceType;
        }

        public final void setSpotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
        }

        @Override
        public final Builder spotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
            return this;
        }

        public final String getValidUntil() {
            return validUntil;
        }

        public final void setValidUntil(String validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public final Builder validUntil(String validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails build() {
            return new AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
