/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the market (purchasing) option for an Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.Builder, AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails> {
    private static final SdkField<String> MARKET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarketType").getter(getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails::marketType))
            .setter(setter(Builder::marketType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketType").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails> SPOT_OPTIONS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("SpotOptions").getter(getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails::spotOptions))
            .setter(setter(Builder::spotOptions))
            .constructor(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKET_TYPE_FIELD,
            SPOT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String marketType;

    private final AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions;

    private AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails(BuilderImpl builder) {
        this.marketType = builder.marketType;
        this.spotOptions = builder.spotOptions;
    }

    /**
     * <p>
     * The market type.
     * </p>
     * 
     * @return The market type.
     */
    public final String marketType() {
        return marketType;
    }

    /**
     * <p>
     * The options for Spot Instances.
     * </p>
     * 
     * @return The options for Spot Instances.
     */
    public final AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions() {
        return spotOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marketType());
        hashCode = 31 * hashCode + Objects.hashCode(spotOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails other = (AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails) obj;
        return Objects.equals(marketType(), other.marketType()) && Objects.equals(spotOptions(), other.spotOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails").add("MarketType", marketType())
                .add("SpotOptions", spotOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MarketType":
            return Optional.ofNullable(clazz.cast(marketType()));
        case "SpotOptions":
            return Optional.ofNullable(clazz.cast(spotOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MarketType", MARKET_TYPE_FIELD);
        map.put("SpotOptions", SPOT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails> {
        /**
         * <p>
         * The market type.
         * </p>
         * 
         * @param marketType
         *        The market type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketType(String marketType);

        /**
         * <p>
         * The options for Spot Instances.
         * </p>
         * 
         * @param spotOptions
         *        The options for Spot Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions);

        /**
         * <p>
         * The options for Spot Instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder} avoiding the need to create
         * one manually via {@link AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #spotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails)}.
         * 
         * @param spotOptions
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails)
         */
        default Builder spotOptions(Consumer<AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder> spotOptions) {
            return spotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.builder()
                    .applyMutation(spotOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String marketType;

        private AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails model) {
            marketType(model.marketType);
            spotOptions(model.spotOptions);
        }

        public final String getMarketType() {
            return marketType;
        }

        public final void setMarketType(String marketType) {
            this.marketType = marketType;
        }

        @Override
        public final Builder marketType(String marketType) {
            this.marketType = marketType;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder getSpotOptions() {
            return spotOptions != null ? spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails build() {
            return new AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
