/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the CPU options for an Amazon EC2 instance. For more information, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the
 * <i>Amazon Elastic Compute Cloud User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataCpuOptionsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataCpuOptionsDetails.Builder, AwsEc2LaunchTemplateDataCpuOptionsDetails> {
    private static final SdkField<Integer> CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoreCount").getter(getter(AwsEc2LaunchTemplateDataCpuOptionsDetails::coreCount))
            .setter(setter(Builder::coreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreCount").build()).build();

    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThreadsPerCore").getter(getter(AwsEc2LaunchTemplateDataCpuOptionsDetails::threadsPerCore))
            .setter(setter(Builder::threadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_COUNT_FIELD,
            THREADS_PER_CORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer coreCount;

    private final Integer threadsPerCore;

    private AwsEc2LaunchTemplateDataCpuOptionsDetails(BuilderImpl builder) {
        this.coreCount = builder.coreCount;
        this.threadsPerCore = builder.threadsPerCore;
    }

    /**
     * <p>
     * The number of CPU cores for the instance.
     * </p>
     * 
     * @return The number of CPU cores for the instance.
     */
    public final Integer coreCount() {
        return coreCount;
    }

    /**
     * <p>
     * The number of threads per CPU core. A value of <code>1</code> disables multithreading for the instance, The
     * default value is <code>2</code>.
     * </p>
     * 
     * @return The number of threads per CPU core. A value of <code>1</code> disables multithreading for the instance,
     *         The default value is <code>2</code>.
     */
    public final Integer threadsPerCore() {
        return threadsPerCore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreCount());
        hashCode = 31 * hashCode + Objects.hashCode(threadsPerCore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataCpuOptionsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataCpuOptionsDetails other = (AwsEc2LaunchTemplateDataCpuOptionsDetails) obj;
        return Objects.equals(coreCount(), other.coreCount()) && Objects.equals(threadsPerCore(), other.threadsPerCore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataCpuOptionsDetails").add("CoreCount", coreCount())
                .add("ThreadsPerCore", threadsPerCore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreCount":
            return Optional.ofNullable(clazz.cast(coreCount()));
        case "ThreadsPerCore":
            return Optional.ofNullable(clazz.cast(threadsPerCore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreCount", CORE_COUNT_FIELD);
        map.put("ThreadsPerCore", THREADS_PER_CORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataCpuOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataCpuOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataCpuOptionsDetails> {
        /**
         * <p>
         * The number of CPU cores for the instance.
         * </p>
         * 
         * @param coreCount
         *        The number of CPU cores for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreCount(Integer coreCount);

        /**
         * <p>
         * The number of threads per CPU core. A value of <code>1</code> disables multithreading for the instance, The
         * default value is <code>2</code>.
         * </p>
         * 
         * @param threadsPerCore
         *        The number of threads per CPU core. A value of <code>1</code> disables multithreading for the
         *        instance, The default value is <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadsPerCore(Integer threadsPerCore);
    }

    static final class BuilderImpl implements Builder {
        private Integer coreCount;

        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataCpuOptionsDetails model) {
            coreCount(model.coreCount);
            threadsPerCore(model.threadsPerCore);
        }

        public final Integer getCoreCount() {
            return coreCount;
        }

        public final void setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
        }

        @Override
        public final Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataCpuOptionsDetails build() {
            return new AwsEc2LaunchTemplateDataCpuOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
