/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Capacity Reservation targeting option of an Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.Builder, AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails> {
    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationPreference")
            .getter(getter(AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails::capacityReservationPreference))
            .setter(setter(Builder::capacityReservationPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference")
                    .build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails> CAPACITY_RESERVATION_TARGET_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails> builder(
                    MarshallingType.SDK_POJO).memberName("CapacityReservationTarget")
            .getter(getter(AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails::capacityReservationTarget))
            .setter(setter(Builder::capacityReservationTarget))
            .constructor(AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationTarget").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_RESERVATION_PREFERENCE_FIELD, CAPACITY_RESERVATION_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationPreference;

    private final AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails capacityReservationTarget;

    private AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails(BuilderImpl builder) {
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.capacityReservationTarget = builder.capacityReservationTarget;
    }

    /**
     * <p>
     * Indicates the instance's Capacity Reservation preferences. If equal to <code>open</code>, the instance can run in
     * any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). If equal
     * to <code>none</code>, the instance avoids running in a Capacity Reservation even if one is available. The
     * instance runs in On-Demand capacity.
     * </p>
     * 
     * @return Indicates the instance's Capacity Reservation preferences. If equal to <code>open</code>, the instance
     *         can run in any open Capacity Reservation that has matching attributes (instance type, platform,
     *         Availability Zone). If equal to <code>none</code>, the instance avoids running in a Capacity Reservation
     *         even if one is available. The instance runs in On-Demand capacity.
     */
    public final String capacityReservationPreference() {
        return capacityReservationPreference;
    }

    /**
     * <p>
     * Specifies a target Capacity Reservation.
     * </p>
     * 
     * @return Specifies a target Capacity Reservation.
     */
    public final AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails capacityReservationTarget() {
        return capacityReservationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationPreference());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails other = (AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails) obj;
        return Objects.equals(capacityReservationPreference(), other.capacityReservationPreference())
                && Objects.equals(capacityReservationTarget(), other.capacityReservationTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails")
                .add("CapacityReservationPreference", capacityReservationPreference())
                .add("CapacityReservationTarget", capacityReservationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationPreference":
            return Optional.ofNullable(clazz.cast(capacityReservationPreference()));
        case "CapacityReservationTarget":
            return Optional.ofNullable(clazz.cast(capacityReservationTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationPreference", CAPACITY_RESERVATION_PREFERENCE_FIELD);
        map.put("CapacityReservationTarget", CAPACITY_RESERVATION_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails> {
        /**
         * <p>
         * Indicates the instance's Capacity Reservation preferences. If equal to <code>open</code>, the instance can
         * run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability
         * Zone). If equal to <code>none</code>, the instance avoids running in a Capacity Reservation even if one is
         * available. The instance runs in On-Demand capacity.
         * </p>
         * 
         * @param capacityReservationPreference
         *        Indicates the instance's Capacity Reservation preferences. If equal to <code>open</code>, the instance
         *        can run in any open Capacity Reservation that has matching attributes (instance type, platform,
         *        Availability Zone). If equal to <code>none</code>, the instance avoids running in a Capacity
         *        Reservation even if one is available. The instance runs in On-Demand capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationPreference(String capacityReservationPreference);

        /**
         * <p>
         * Specifies a target Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationTarget
         *        Specifies a target Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationTarget(
                AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails capacityReservationTarget);

        /**
         * <p>
         * Specifies a target Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.Builder}
         * avoiding the need to create one manually via
         * {@link AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #capacityReservationTarget(AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails)}.
         * 
         * @param capacityReservationTarget
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationTarget(AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails)
         */
        default Builder capacityReservationTarget(
                Consumer<AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.Builder> capacityReservationTarget) {
            return capacityReservationTarget(AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
                    .builder().applyMutation(capacityReservationTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationPreference;

        private AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails capacityReservationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails model) {
            capacityReservationPreference(model.capacityReservationPreference);
            capacityReservationTarget(model.capacityReservationTarget);
        }

        public final String getCapacityReservationPreference() {
            return capacityReservationPreference;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        public final AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.Builder getCapacityReservationTarget() {
            return capacityReservationTarget != null ? capacityReservationTarget.toBuilder() : null;
        }

        public final void setCapacityReservationTarget(
                AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.BuilderImpl capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget != null ? capacityReservationTarget.build() : null;
        }

        @Override
        public final Builder capacityReservationTarget(
                AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails build() {
            return new AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
