/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters for a block device for an Amazon Elastic Block Store (Amazon EBS) volume in an Amazon EC2 launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.Builder, AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails> {
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::volumeType))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_ON_TERMINATION_FIELD,
            ENCRYPTED_FIELD, IOPS_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ID_FIELD, THROUGHPUT_FIELD, VOLUME_SIZE_FIELD,
            VOLUME_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean deleteOnTermination;

    private final Boolean encrypted;

    private final Integer iops;

    private final String kmsKeyId;

    private final String snapshotId;

    private final Integer throughput;

    private final Integer volumeSize;

    private final String volumeType;

    private AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails(BuilderImpl builder) {
        this.deleteOnTermination = builder.deleteOnTermination;
        this.encrypted = builder.encrypted;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotId = builder.snapshotId;
        this.throughput = builder.throughput;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
    }

    /**
     * <p>
     * Indicates whether the EBS volume is deleted on instance termination.
     * </p>
     * 
     * @return Indicates whether the EBS volume is deleted on instance termination.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support
     * Amazon EBS encryption. If you're creating a volume from a snapshot, you can't specify an encryption value.
     * </p>
     * 
     * @return Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that
     *         support Amazon EBS encryption. If you're creating a volume from a snapshot, you can't specify an
     *         encryption value.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS).
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS).
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS) customer managed key used for
     * encryption.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS) customer managed key used
     *         for encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ID of the EBS snapshot.
     * </p>
     * 
     * @return The ID of the EBS snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
     * </p>
     * 
     * @return The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <p>
     * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size.
     * </p>
     * 
     * @return The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * 
     * @return The volume type.
     */
    public final String volumeType() {
        return volumeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails other = (AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) obj;
        return Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(iops(), other.iops())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(throughput(), other.throughput()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeType(), other.volumeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails")
                .add("DeleteOnTermination", deleteOnTermination()).add("Encrypted", encrypted()).add("Iops", iops())
                .add("KmsKeyId", kmsKeyId()).add("SnapshotId", snapshotId()).add("Throughput", throughput())
                .add("VolumeSize", volumeSize()).add("VolumeType", volumeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails> {
        /**
         * <p>
         * Indicates whether the EBS volume is deleted on instance termination.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the EBS volume is deleted on instance termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that
         * support Amazon EBS encryption. If you're creating a volume from a snapshot, you can't specify an encryption
         * value.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances
         *        that support Amazon EBS encryption. If you're creating a volume from a snapshot, you can't specify an
         *        encryption value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The number of I/O operations per second (IOPS).
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS) customer managed key used for
         * encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS) customer managed key used
         *        for encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ID of the EBS snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the EBS snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
         * </p>
         * 
         * @param throughput
         *        The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <p>
         * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The volume type.
         * </p>
         * 
         * @param volumeType
         *        The volume type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean deleteOnTermination;

        private Boolean encrypted;

        private Integer iops;

        private String kmsKeyId;

        private String snapshotId;

        private Integer throughput;

        private Integer volumeSize;

        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails model) {
            deleteOnTermination(model.deleteOnTermination);
            encrypted(model.encrypted);
            iops(model.iops);
            kmsKeyId(model.kmsKeyId);
            snapshotId(model.snapshotId);
            throughput(model.throughput);
            volumeSize(model.volumeSize);
            volumeType(model.volumeType);
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails build() {
            return new AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
