/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Elastic IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2EipDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2EipDetails.Builder, AwsEc2EipDetails> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AwsEc2EipDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicIp").getter(getter(AwsEc2EipDetails::publicIp)).setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").build()).build();

    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllocationId").getter(getter(AwsEc2EipDetails::allocationId)).setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(AwsEc2EipDetails::associationId)).setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(AwsEc2EipDetails::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicIpv4Pool").getter(getter(AwsEc2EipDetails::publicIpv4Pool))
            .setter(setter(Builder::publicIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool").build()).build();

    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkBorderGroup").getter(getter(AwsEc2EipDetails::networkBorderGroup))
            .setter(setter(Builder::networkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").build())
            .build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(AwsEc2EipDetails::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<String> NETWORK_INTERFACE_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceOwnerId").getter(getter(AwsEc2EipDetails::networkInterfaceOwnerId))
            .setter(setter(Builder::networkInterfaceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceOwnerId").build())
            .build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress").getter(getter(AwsEc2EipDetails::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            PUBLIC_IP_FIELD, ALLOCATION_ID_FIELD, ASSOCIATION_ID_FIELD, DOMAIN_FIELD, PUBLIC_IPV4_POOL_FIELD,
            NETWORK_BORDER_GROUP_FIELD, NETWORK_INTERFACE_ID_FIELD, NETWORK_INTERFACE_OWNER_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String publicIp;

    private final String allocationId;

    private final String associationId;

    private final String domain;

    private final String publicIpv4Pool;

    private final String networkBorderGroup;

    private final String networkInterfaceId;

    private final String networkInterfaceOwnerId;

    private final String privateIpAddress;

    private AwsEc2EipDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.domain = builder.domain;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfaceOwnerId = builder.networkInterfaceOwnerId;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * The identifier of the EC2 instance.
     * </p>
     * 
     * @return The identifier of the EC2 instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A public IP address that is associated with the EC2 instance.
     * </p>
     * 
     * @return A public IP address that is associated with the EC2 instance.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The identifier that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use
     * with Amazon VPC.
     * </p>
     * 
     * @return The identifier that Amazon Web Services assigns to represent the allocation of the Elastic IP address for
     *         use with Amazon VPC.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The identifier that represents the association of the Elastic IP address with an EC2 instance.
     * </p>
     * 
     * @return The identifier that represents the association of the Elastic IP address with an EC2 instance.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The domain in which to allocate the address.
     * </p>
     * <p>
     * If the address is for use with EC2 instances in a VPC, then <code>Domain</code> is <code>vpc</code>. Otherwise,
     * <code>Domain</code> is <code>standard</code>.
     * </p>
     * 
     * @return The domain in which to allocate the address.</p>
     *         <p>
     *         If the address is for use with EC2 instances in a VPC, then <code>Domain</code> is <code>vpc</code>.
     *         Otherwise, <code>Domain</code> is <code>standard</code>.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The identifier of an IP address pool. This parameter allows Amazon EC2 to select an IP address from the address
     * pool.
     * </p>
     * 
     * @return The identifier of an IP address pool. This parameter allows Amazon EC2 to select an IP address from the
     *         address pool.
     */
    public final String publicIpv4Pool() {
        return publicIpv4Pool;
    }

    /**
     * <p>
     * The name of the location from which the Elastic IP address is advertised.
     * </p>
     * 
     * @return The name of the location from which the Elastic IP address is advertised.
     */
    public final String networkBorderGroup() {
        return networkBorderGroup;
    }

    /**
     * <p>
     * The identifier of the network interface.
     * </p>
     * 
     * @return The identifier of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the network interface.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the network interface.
     */
    public final String networkInterfaceOwnerId() {
        return networkInterfaceOwnerId;
    }

    /**
     * <p>
     * The private IP address that is associated with the Elastic IP address.
     * </p>
     * 
     * @return The private IP address that is associated with the Elastic IP address.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2EipDetails)) {
            return false;
        }
        AwsEc2EipDetails other = (AwsEc2EipDetails) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(publicIp(), other.publicIp())
                && Objects.equals(allocationId(), other.allocationId()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(domain(), other.domain()) && Objects.equals(publicIpv4Pool(), other.publicIpv4Pool())
                && Objects.equals(networkBorderGroup(), other.networkBorderGroup())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(networkInterfaceOwnerId(), other.networkInterfaceOwnerId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2EipDetails").add("InstanceId", instanceId()).add("PublicIp", publicIp())
                .add("AllocationId", allocationId()).add("AssociationId", associationId()).add("Domain", domain())
                .add("PublicIpv4Pool", publicIpv4Pool()).add("NetworkBorderGroup", networkBorderGroup())
                .add("NetworkInterfaceId", networkInterfaceId()).add("NetworkInterfaceOwnerId", networkInterfaceOwnerId())
                .add("PrivateIpAddress", privateIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "PublicIpv4Pool":
            return Optional.ofNullable(clazz.cast(publicIpv4Pool()));
        case "NetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(networkBorderGroup()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "NetworkInterfaceOwnerId":
            return Optional.ofNullable(clazz.cast(networkInterfaceOwnerId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("PublicIp", PUBLIC_IP_FIELD);
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("PublicIpv4Pool", PUBLIC_IPV4_POOL_FIELD);
        map.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("NetworkInterfaceOwnerId", NETWORK_INTERFACE_OWNER_ID_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2EipDetails, T> g) {
        return obj -> g.apply((AwsEc2EipDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2EipDetails> {
        /**
         * <p>
         * The identifier of the EC2 instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A public IP address that is associated with the EC2 instance.
         * </p>
         * 
         * @param publicIp
         *        A public IP address that is associated with the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The identifier that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use
         * with Amazon VPC.
         * </p>
         * 
         * @param allocationId
         *        The identifier that Amazon Web Services assigns to represent the allocation of the Elastic IP address
         *        for use with Amazon VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The identifier that represents the association of the Elastic IP address with an EC2 instance.
         * </p>
         * 
         * @param associationId
         *        The identifier that represents the association of the Elastic IP address with an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The domain in which to allocate the address.
         * </p>
         * <p>
         * If the address is for use with EC2 instances in a VPC, then <code>Domain</code> is <code>vpc</code>.
         * Otherwise, <code>Domain</code> is <code>standard</code>.
         * </p>
         * 
         * @param domain
         *        The domain in which to allocate the address.</p>
         *        <p>
         *        If the address is for use with EC2 instances in a VPC, then <code>Domain</code> is <code>vpc</code>.
         *        Otherwise, <code>Domain</code> is <code>standard</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The identifier of an IP address pool. This parameter allows Amazon EC2 to select an IP address from the
         * address pool.
         * </p>
         * 
         * @param publicIpv4Pool
         *        The identifier of an IP address pool. This parameter allows Amazon EC2 to select an IP address from
         *        the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4Pool(String publicIpv4Pool);

        /**
         * <p>
         * The name of the location from which the Elastic IP address is advertised.
         * </p>
         * 
         * @param networkBorderGroup
         *        The name of the location from which the Elastic IP address is advertised.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBorderGroup(String networkBorderGroup);

        /**
         * <p>
         * The identifier of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The identifier of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the network interface.
         * </p>
         * 
         * @param networkInterfaceOwnerId
         *        The Amazon Web Services account ID of the owner of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceOwnerId(String networkInterfaceOwnerId);

        /**
         * <p>
         * The private IP address that is associated with the Elastic IP address.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address that is associated with the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String publicIp;

        private String allocationId;

        private String associationId;

        private String domain;

        private String publicIpv4Pool;

        private String networkBorderGroup;

        private String networkInterfaceId;

        private String networkInterfaceOwnerId;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2EipDetails model) {
            instanceId(model.instanceId);
            publicIp(model.publicIp);
            allocationId(model.allocationId);
            associationId(model.associationId);
            domain(model.domain);
            publicIpv4Pool(model.publicIpv4Pool);
            networkBorderGroup(model.networkBorderGroup);
            networkInterfaceId(model.networkInterfaceId);
            networkInterfaceOwnerId(model.networkInterfaceOwnerId);
            privateIpAddress(model.privateIpAddress);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getPublicIpv4Pool() {
            return publicIpv4Pool;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getNetworkInterfaceOwnerId() {
            return networkInterfaceOwnerId;
        }

        public final void setNetworkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
        }

        @Override
        public final Builder networkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        @Override
        public AwsEc2EipDetails build() {
            return new AwsEc2EipDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
