/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the client certificate used for authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.Builder, AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails> {
    private static final SdkField<String> CLIENT_ROOT_CERTIFICATE_CHAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRootCertificateChain")
            .getter(getter(AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails::clientRootCertificateChain))
            .setter(setter(Builder::clientRootCertificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRootCertificateChain").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLIENT_ROOT_CERTIFICATE_CHAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientRootCertificateChain;

    private AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails(BuilderImpl builder) {
        this.clientRootCertificateChain = builder.clientRootCertificateChain;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the client certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the client certificate.
     */
    public final String clientRootCertificateChain() {
        return clientRootCertificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientRootCertificateChain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails)) {
            return false;
        }
        AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails other = (AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails) obj;
        return Objects.equals(clientRootCertificateChain(), other.clientRootCertificateChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails")
                .add("ClientRootCertificateChain", clientRootCertificateChain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRootCertificateChain":
            return Optional.ofNullable(clazz.cast(clientRootCertificateChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRootCertificateChain", CLIENT_ROOT_CERTIFICATE_CHAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails, T> g) {
        return obj -> g.apply((AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the client certificate.
         * </p>
         * 
         * @param clientRootCertificateChain
         *        The Amazon Resource Name (ARN) of the client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRootCertificateChain(String clientRootCertificateChain);
    }

    static final class BuilderImpl implements Builder {
        private String clientRootCertificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails model) {
            clientRootCertificateChain(model.clientRootCertificateChain);
        }

        public final String getClientRootCertificateChain() {
            return clientRootCertificateChain;
        }

        public final void setClientRootCertificateChain(String clientRootCertificateChain) {
            this.clientRootCertificateChain = clientRootCertificateChain;
        }

        @Override
        public final Builder clientRootCertificateChain(String clientRootCertificateChain) {
            this.clientRootCertificateChain = clientRootCertificateChain;
            return this;
        }

        @Override
        public AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails build() {
            return new AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
