/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current DynamoDB Streams configuration for the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableStreamSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableStreamSpecification.Builder, AwsDynamoDbTableStreamSpecification> {
    private static final SdkField<Boolean> STREAM_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StreamEnabled").getter(getter(AwsDynamoDbTableStreamSpecification::streamEnabled))
            .setter(setter(Builder::streamEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamEnabled").build()).build();

    private static final SdkField<String> STREAM_VIEW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamViewType").getter(getter(AwsDynamoDbTableStreamSpecification::streamViewType))
            .setter(setter(Builder::streamViewType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamViewType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ENABLED_FIELD,
            STREAM_VIEW_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean streamEnabled;

    private final String streamViewType;

    private AwsDynamoDbTableStreamSpecification(BuilderImpl builder) {
        this.streamEnabled = builder.streamEnabled;
        this.streamViewType = builder.streamViewType;
    }

    /**
     * <p>
     * Indicates whether DynamoDB Streams is enabled on the table.
     * </p>
     * 
     * @return Indicates whether DynamoDB Streams is enabled on the table.
     */
    public final Boolean streamEnabled() {
        return streamEnabled;
    }

    /**
     * <p>
     * Determines the information that is written to the table.
     * </p>
     * 
     * @return Determines the information that is written to the table.
     */
    public final String streamViewType() {
        return streamViewType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(streamViewType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableStreamSpecification)) {
            return false;
        }
        AwsDynamoDbTableStreamSpecification other = (AwsDynamoDbTableStreamSpecification) obj;
        return Objects.equals(streamEnabled(), other.streamEnabled()) && Objects.equals(streamViewType(), other.streamViewType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableStreamSpecification").add("StreamEnabled", streamEnabled())
                .add("StreamViewType", streamViewType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamEnabled":
            return Optional.ofNullable(clazz.cast(streamEnabled()));
        case "StreamViewType":
            return Optional.ofNullable(clazz.cast(streamViewType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamEnabled", STREAM_ENABLED_FIELD);
        map.put("StreamViewType", STREAM_VIEW_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableStreamSpecification, T> g) {
        return obj -> g.apply((AwsDynamoDbTableStreamSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableStreamSpecification> {
        /**
         * <p>
         * Indicates whether DynamoDB Streams is enabled on the table.
         * </p>
         * 
         * @param streamEnabled
         *        Indicates whether DynamoDB Streams is enabled on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamEnabled(Boolean streamEnabled);

        /**
         * <p>
         * Determines the information that is written to the table.
         * </p>
         * 
         * @param streamViewType
         *        Determines the information that is written to the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamViewType(String streamViewType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean streamEnabled;

        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableStreamSpecification model) {
            streamEnabled(model.streamEnabled);
            streamViewType(model.streamViewType);
        }

        public final Boolean getStreamEnabled() {
            return streamEnabled;
        }

        public final void setStreamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
        }

        @Override
        public final Builder streamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
            return this;
        }

        public final String getStreamViewType() {
            return streamViewType;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public AwsDynamoDbTableStreamSpecification build() {
            return new AwsDynamoDbTableStreamSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
