/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the TLS/SSL configuration that the CloudFront distribution uses to communicate with
 * viewers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionViewerCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionViewerCertificate.Builder, AwsCloudFrontDistributionViewerCertificate> {
    private static final SdkField<String> ACM_CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcmCertificateArn").getter(getter(AwsCloudFrontDistributionViewerCertificate::acmCertificateArn))
            .setter(setter(Builder::acmCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcmCertificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Certificate").getter(getter(AwsCloudFrontDistributionViewerCertificate::certificate))
            .setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> CERTIFICATE_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateSource").getter(getter(AwsCloudFrontDistributionViewerCertificate::certificateSource))
            .setter(setter(Builder::certificateSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSource").build()).build();

    private static final SdkField<Boolean> CLOUD_FRONT_DEFAULT_CERTIFICATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CloudFrontDefaultCertificate")
            .getter(getter(AwsCloudFrontDistributionViewerCertificate::cloudFrontDefaultCertificate))
            .setter(setter(Builder::cloudFrontDefaultCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDefaultCertificate")
                    .build()).build();

    private static final SdkField<String> IAM_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamCertificateId").getter(getter(AwsCloudFrontDistributionViewerCertificate::iamCertificateId))
            .setter(setter(Builder::iamCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamCertificateId").build()).build();

    private static final SdkField<String> MINIMUM_PROTOCOL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinimumProtocolVersion")
            .getter(getter(AwsCloudFrontDistributionViewerCertificate::minimumProtocolVersion))
            .setter(setter(Builder::minimumProtocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumProtocolVersion").build())
            .build();

    private static final SdkField<String> SSL_SUPPORT_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslSupportMethod").getter(getter(AwsCloudFrontDistributionViewerCertificate::sslSupportMethod))
            .setter(setter(Builder::sslSupportMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslSupportMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_CERTIFICATE_ARN_FIELD,
            CERTIFICATE_FIELD, CERTIFICATE_SOURCE_FIELD, CLOUD_FRONT_DEFAULT_CERTIFICATE_FIELD, IAM_CERTIFICATE_ID_FIELD,
            MINIMUM_PROTOCOL_VERSION_FIELD, SSL_SUPPORT_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String acmCertificateArn;

    private final String certificate;

    private final String certificateSource;

    private final Boolean cloudFrontDefaultCertificate;

    private final String iamCertificateId;

    private final String minimumProtocolVersion;

    private final String sslSupportMethod;

    private AwsCloudFrontDistributionViewerCertificate(BuilderImpl builder) {
        this.acmCertificateArn = builder.acmCertificateArn;
        this.certificate = builder.certificate;
        this.certificateSource = builder.certificateSource;
        this.cloudFrontDefaultCertificate = builder.cloudFrontDefaultCertificate;
        this.iamCertificateId = builder.iamCertificateId;
        this.minimumProtocolVersion = builder.minimumProtocolVersion;
        this.sslSupportMethod = builder.sslSupportMethod;
    }

    /**
     * <p>
     * The ARN of the ACM certificate. Used if the certificate is stored in ACM. If you provide an ACM certificate ARN,
     * you must also provide <code>MinimumCertificateVersion</code> and <code>SslSupportMethod</code>.
     * </p>
     * 
     * @return The ARN of the ACM certificate. Used if the certificate is stored in ACM. If you provide an ACM
     *         certificate ARN, you must also provide <code>MinimumCertificateVersion</code> and
     *         <code>SslSupportMethod</code>.
     */
    public final String acmCertificateArn() {
        return acmCertificateArn;
    }

    /**
     * <p>
     * The identifier of the certificate. Note that in CloudFront, this attribute is deprecated.
     * </p>
     * 
     * @return The identifier of the certificate. Note that in CloudFront, this attribute is deprecated.
     */
    public final String certificate() {
        return certificate;
    }

    /**
     * <p>
     * The source of the certificate identified by <code>Certificate</code>. Note that in CloudFront, this attribute is
     * deprecated.
     * </p>
     * 
     * @return The source of the certificate identified by <code>Certificate</code>. Note that in CloudFront, this
     *         attribute is deprecated.
     */
    public final String certificateSource() {
        return certificateSource;
    }

    /**
     * <p>
     * Whether the distribution uses the CloudFront domain name. If set to <code>false</code>, then you provide either
     * <code>AcmCertificateArn</code> or <code>IamCertificateId</code>.
     * </p>
     * 
     * @return Whether the distribution uses the CloudFront domain name. If set to <code>false</code>, then you provide
     *         either <code>AcmCertificateArn</code> or <code>IamCertificateId</code>.
     */
    public final Boolean cloudFrontDefaultCertificate() {
        return cloudFrontDefaultCertificate;
    }

    /**
     * <p>
     * The identifier of the IAM certificate. Used if the certificate is stored in IAM. If you provide
     * <code>IamCertificateId</code>, then you also must provide <code>MinimumProtocolVersion</code> and
     * <code>SslSupportMethod</code>.
     * </p>
     * 
     * @return The identifier of the IAM certificate. Used if the certificate is stored in IAM. If you provide
     *         <code>IamCertificateId</code>, then you also must provide <code>MinimumProtocolVersion</code> and
     *         <code>SslSupportMethod</code>.
     */
    public final String iamCertificateId() {
        return iamCertificateId;
    }

    /**
     * <p>
     * The security policy that CloudFront uses for HTTPS connections with viewers. If <code>SslSupportMethod</code> is
     * <code>sni-only</code>, then <code>MinimumProtocolVersion</code> must be <code>TLSv1</code> or higher.
     * </p>
     * 
     * @return The security policy that CloudFront uses for HTTPS connections with viewers. If
     *         <code>SslSupportMethod</code> is <code>sni-only</code>, then <code>MinimumProtocolVersion</code> must be
     *         <code>TLSv1</code> or higher.
     */
    public final String minimumProtocolVersion() {
        return minimumProtocolVersion;
    }

    /**
     * <p>
     * The viewers that the distribution accepts HTTPS connections from.
     * </p>
     * 
     * @return The viewers that the distribution accepts HTTPS connections from.
     */
    public final String sslSupportMethod() {
        return sslSupportMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acmCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(certificateSource());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontDefaultCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(iamCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(minimumProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sslSupportMethod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionViewerCertificate)) {
            return false;
        }
        AwsCloudFrontDistributionViewerCertificate other = (AwsCloudFrontDistributionViewerCertificate) obj;
        return Objects.equals(acmCertificateArn(), other.acmCertificateArn())
                && Objects.equals(certificate(), other.certificate())
                && Objects.equals(certificateSource(), other.certificateSource())
                && Objects.equals(cloudFrontDefaultCertificate(), other.cloudFrontDefaultCertificate())
                && Objects.equals(iamCertificateId(), other.iamCertificateId())
                && Objects.equals(minimumProtocolVersion(), other.minimumProtocolVersion())
                && Objects.equals(sslSupportMethod(), other.sslSupportMethod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionViewerCertificate").add("AcmCertificateArn", acmCertificateArn())
                .add("Certificate", certificate()).add("CertificateSource", certificateSource())
                .add("CloudFrontDefaultCertificate", cloudFrontDefaultCertificate()).add("IamCertificateId", iamCertificateId())
                .add("MinimumProtocolVersion", minimumProtocolVersion()).add("SslSupportMethod", sslSupportMethod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcmCertificateArn":
            return Optional.ofNullable(clazz.cast(acmCertificateArn()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "CertificateSource":
            return Optional.ofNullable(clazz.cast(certificateSource()));
        case "CloudFrontDefaultCertificate":
            return Optional.ofNullable(clazz.cast(cloudFrontDefaultCertificate()));
        case "IamCertificateId":
            return Optional.ofNullable(clazz.cast(iamCertificateId()));
        case "MinimumProtocolVersion":
            return Optional.ofNullable(clazz.cast(minimumProtocolVersion()));
        case "SslSupportMethod":
            return Optional.ofNullable(clazz.cast(sslSupportMethod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcmCertificateArn", ACM_CERTIFICATE_ARN_FIELD);
        map.put("Certificate", CERTIFICATE_FIELD);
        map.put("CertificateSource", CERTIFICATE_SOURCE_FIELD);
        map.put("CloudFrontDefaultCertificate", CLOUD_FRONT_DEFAULT_CERTIFICATE_FIELD);
        map.put("IamCertificateId", IAM_CERTIFICATE_ID_FIELD);
        map.put("MinimumProtocolVersion", MINIMUM_PROTOCOL_VERSION_FIELD);
        map.put("SslSupportMethod", SSL_SUPPORT_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionViewerCertificate, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionViewerCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionViewerCertificate> {
        /**
         * <p>
         * The ARN of the ACM certificate. Used if the certificate is stored in ACM. If you provide an ACM certificate
         * ARN, you must also provide <code>MinimumCertificateVersion</code> and <code>SslSupportMethod</code>.
         * </p>
         * 
         * @param acmCertificateArn
         *        The ARN of the ACM certificate. Used if the certificate is stored in ACM. If you provide an ACM
         *        certificate ARN, you must also provide <code>MinimumCertificateVersion</code> and
         *        <code>SslSupportMethod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acmCertificateArn(String acmCertificateArn);

        /**
         * <p>
         * The identifier of the certificate. Note that in CloudFront, this attribute is deprecated.
         * </p>
         * 
         * @param certificate
         *        The identifier of the certificate. Note that in CloudFront, this attribute is deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * The source of the certificate identified by <code>Certificate</code>. Note that in CloudFront, this attribute
         * is deprecated.
         * </p>
         * 
         * @param certificateSource
         *        The source of the certificate identified by <code>Certificate</code>. Note that in CloudFront, this
         *        attribute is deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateSource(String certificateSource);

        /**
         * <p>
         * Whether the distribution uses the CloudFront domain name. If set to <code>false</code>, then you provide
         * either <code>AcmCertificateArn</code> or <code>IamCertificateId</code>.
         * </p>
         * 
         * @param cloudFrontDefaultCertificate
         *        Whether the distribution uses the CloudFront domain name. If set to <code>false</code>, then you
         *        provide either <code>AcmCertificateArn</code> or <code>IamCertificateId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate);

        /**
         * <p>
         * The identifier of the IAM certificate. Used if the certificate is stored in IAM. If you provide
         * <code>IamCertificateId</code>, then you also must provide <code>MinimumProtocolVersion</code> and
         * <code>SslSupportMethod</code>.
         * </p>
         * 
         * @param iamCertificateId
         *        The identifier of the IAM certificate. Used if the certificate is stored in IAM. If you provide
         *        <code>IamCertificateId</code>, then you also must provide <code>MinimumProtocolVersion</code> and
         *        <code>SslSupportMethod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamCertificateId(String iamCertificateId);

        /**
         * <p>
         * The security policy that CloudFront uses for HTTPS connections with viewers. If <code>SslSupportMethod</code>
         * is <code>sni-only</code>, then <code>MinimumProtocolVersion</code> must be <code>TLSv1</code> or higher.
         * </p>
         * 
         * @param minimumProtocolVersion
         *        The security policy that CloudFront uses for HTTPS connections with viewers. If
         *        <code>SslSupportMethod</code> is <code>sni-only</code>, then <code>MinimumProtocolVersion</code> must
         *        be <code>TLSv1</code> or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumProtocolVersion(String minimumProtocolVersion);

        /**
         * <p>
         * The viewers that the distribution accepts HTTPS connections from.
         * </p>
         * 
         * @param sslSupportMethod
         *        The viewers that the distribution accepts HTTPS connections from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslSupportMethod(String sslSupportMethod);
    }

    static final class BuilderImpl implements Builder {
        private String acmCertificateArn;

        private String certificate;

        private String certificateSource;

        private Boolean cloudFrontDefaultCertificate;

        private String iamCertificateId;

        private String minimumProtocolVersion;

        private String sslSupportMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionViewerCertificate model) {
            acmCertificateArn(model.acmCertificateArn);
            certificate(model.certificate);
            certificateSource(model.certificateSource);
            cloudFrontDefaultCertificate(model.cloudFrontDefaultCertificate);
            iamCertificateId(model.iamCertificateId);
            minimumProtocolVersion(model.minimumProtocolVersion);
            sslSupportMethod(model.sslSupportMethod);
        }

        public final String getAcmCertificateArn() {
            return acmCertificateArn;
        }

        public final void setAcmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
        }

        @Override
        public final Builder acmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
            return this;
        }

        public final String getCertificate() {
            return certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateSource() {
            return certificateSource;
        }

        public final void setCertificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
        }

        @Override
        public final Builder certificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
            return this;
        }

        public final Boolean getCloudFrontDefaultCertificate() {
            return cloudFrontDefaultCertificate;
        }

        public final void setCloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
        }

        @Override
        public final Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
            return this;
        }

        public final String getIamCertificateId() {
            return iamCertificateId;
        }

        public final void setIamCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
        }

        @Override
        public final Builder iamCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
            return this;
        }

        public final String getMinimumProtocolVersion() {
            return minimumProtocolVersion;
        }

        public final void setMinimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
        }

        @Override
        public final Builder minimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
            return this;
        }

        public final String getSslSupportMethod() {
            return sslSupportMethod;
        }

        public final void setSslSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
        }

        @Override
        public final Builder sslSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionViewerCertificate build() {
            return new AwsCloudFrontDistributionViewerCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
