/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about origins and origin groups for this CloudFront distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOrigins implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOrigins.Builder, AwsCloudFrontDistributionOrigins> {
    private static final SdkField<List<AwsCloudFrontDistributionOriginItem>> ITEMS_FIELD = SdkField
            .<List<AwsCloudFrontDistributionOriginItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(AwsCloudFrontDistributionOrigins::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCloudFrontDistributionOriginItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCloudFrontDistributionOriginItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AwsCloudFrontDistributionOriginItem> items;

    private AwsCloudFrontDistributionOrigins(BuilderImpl builder) {
        this.items = builder.items;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains origins or origin groups for this distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return A complex type that contains origins or origin groups for this distribution.
     */
    public final List<AwsCloudFrontDistributionOriginItem> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOrigins)) {
            return false;
        }
        AwsCloudFrontDistributionOrigins other = (AwsCloudFrontDistributionOrigins) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionOrigins").add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Items", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOrigins, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOrigins) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOrigins> {
        /**
         * <p>
         * A complex type that contains origins or origin groups for this distribution.
         * </p>
         * 
         * @param items
         *        A complex type that contains origins or origin groups for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<AwsCloudFrontDistributionOriginItem> items);

        /**
         * <p>
         * A complex type that contains origins or origin groups for this distribution.
         * </p>
         * 
         * @param items
         *        A complex type that contains origins or origin groups for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(AwsCloudFrontDistributionOriginItem... items);

        /**
         * <p>
         * A complex type that contains origins or origin groups for this distribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem.Builder#build()}
         * is called immediately and its result is passed to {@link #items(List<AwsCloudFrontDistributionOriginItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<AwsCloudFrontDistributionOriginItem>)
         */
        Builder items(Consumer<AwsCloudFrontDistributionOriginItem.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsCloudFrontDistributionOriginItem> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOrigins model) {
            items(model.items);
        }

        public final List<AwsCloudFrontDistributionOriginItem.Builder> getItems() {
            List<AwsCloudFrontDistributionOriginItem.Builder> result = AwsCloudFrontDistributionOriginItemListCopier
                    .copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AwsCloudFrontDistributionOriginItem.BuilderImpl> items) {
            this.items = AwsCloudFrontDistributionOriginItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AwsCloudFrontDistributionOriginItem> items) {
            this.items = AwsCloudFrontDistributionOriginItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AwsCloudFrontDistributionOriginItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AwsCloudFrontDistributionOriginItem.Builder>... items) {
            items(Stream.of(items).map(c -> AwsCloudFrontDistributionOriginItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsCloudFrontDistributionOrigins build() {
            return new AwsCloudFrontDistributionOrigins(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
