/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that controls whether access logs are written for the CloudFront distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionLogging implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionLogging.Builder, AwsCloudFrontDistributionLogging> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(AwsCloudFrontDistributionLogging::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AwsCloudFrontDistributionLogging::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Boolean> INCLUDE_COOKIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeCookies").getter(getter(AwsCloudFrontDistributionLogging::includeCookies))
            .setter(setter(Builder::includeCookies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCookies").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(AwsCloudFrontDistributionLogging::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, ENABLED_FIELD,
            INCLUDE_COOKIES_FIELD, PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final Boolean enabled;

    private final Boolean includeCookies;

    private final String prefix;

    private AwsCloudFrontDistributionLogging(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.enabled = builder.enabled;
        this.includeCookies = builder.includeCookies;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * The S3 bucket to store the access logs in.
     * </p>
     * 
     * @return The S3 bucket to store the access logs in.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * With this field, you can enable or disable the selected distribution.
     * </p>
     * 
     * @return With this field, you can enable or disable the selected distribution.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies whether you want CloudFront to include cookies in access logs.
     * </p>
     * 
     * @return Specifies whether you want CloudFront to include cookies in access logs.
     */
    public final Boolean includeCookies() {
        return includeCookies;
    }

    /**
     * <p>
     * An optional string that you want CloudFront to use as a prefix to the access log filenames for this distribution.
     * </p>
     * 
     * @return An optional string that you want CloudFront to use as a prefix to the access log filenames for this
     *         distribution.
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(includeCookies());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionLogging)) {
            return false;
        }
        AwsCloudFrontDistributionLogging other = (AwsCloudFrontDistributionLogging) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(includeCookies(), other.includeCookies()) && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionLogging").add("Bucket", bucket()).add("Enabled", enabled())
                .add("IncludeCookies", includeCookies()).add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "IncludeCookies":
            return Optional.ofNullable(clazz.cast(includeCookies()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("IncludeCookies", INCLUDE_COOKIES_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionLogging, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionLogging) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionLogging> {
        /**
         * <p>
         * The S3 bucket to store the access logs in.
         * </p>
         * 
         * @param bucket
         *        The S3 bucket to store the access logs in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * With this field, you can enable or disable the selected distribution.
         * </p>
         * 
         * @param enabled
         *        With this field, you can enable or disable the selected distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies whether you want CloudFront to include cookies in access logs.
         * </p>
         * 
         * @param includeCookies
         *        Specifies whether you want CloudFront to include cookies in access logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCookies(Boolean includeCookies);

        /**
         * <p>
         * An optional string that you want CloudFront to use as a prefix to the access log filenames for this
         * distribution.
         * </p>
         * 
         * @param prefix
         *        An optional string that you want CloudFront to use as a prefix to the access log filenames for this
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private Boolean enabled;

        private Boolean includeCookies;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionLogging model) {
            bucket(model.bucket);
            enabled(model.enabled);
            includeCookies(model.includeCookies);
            prefix(model.prefix);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getIncludeCookies() {
            return includeCookies;
        }

        public final void setIncludeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
        }

        @Override
        public final Builder includeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionLogging build() {
            return new AwsCloudFrontDistributionLogging(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
