/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the stack's conformity to its expected template configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFormationStackDriftInformationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFormationStackDriftInformationDetails.Builder, AwsCloudFormationStackDriftInformationDetails> {
    private static final SdkField<String> STACK_DRIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackDriftStatus").getter(getter(AwsCloudFormationStackDriftInformationDetails::stackDriftStatus))
            .setter(setter(Builder::stackDriftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDriftStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_DRIFT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stackDriftStatus;

    private AwsCloudFormationStackDriftInformationDetails(BuilderImpl builder) {
        this.stackDriftStatus = builder.stackDriftStatus;
    }

    /**
     * <p>
     * Status of the stack's actual configuration compared to its expected template configuration.
     * </p>
     * 
     * @return Status of the stack's actual configuration compared to its expected template configuration.
     */
    public final String stackDriftStatus() {
        return stackDriftStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackDriftStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFormationStackDriftInformationDetails)) {
            return false;
        }
        AwsCloudFormationStackDriftInformationDetails other = (AwsCloudFormationStackDriftInformationDetails) obj;
        return Objects.equals(stackDriftStatus(), other.stackDriftStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFormationStackDriftInformationDetails").add("StackDriftStatus", stackDriftStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackDriftStatus":
            return Optional.ofNullable(clazz.cast(stackDriftStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackDriftStatus", STACK_DRIFT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFormationStackDriftInformationDetails, T> g) {
        return obj -> g.apply((AwsCloudFormationStackDriftInformationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFormationStackDriftInformationDetails> {
        /**
         * <p>
         * Status of the stack's actual configuration compared to its expected template configuration.
         * </p>
         * 
         * @param stackDriftStatus
         *        Status of the stack's actual configuration compared to its expected template configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackDriftStatus(String stackDriftStatus);
    }

    static final class BuilderImpl implements Builder {
        private String stackDriftStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFormationStackDriftInformationDetails model) {
            stackDriftStatus(model.stackDriftStatus);
        }

        public final String getStackDriftStatus() {
            return stackDriftStatus;
        }

        public final void setStackDriftStatus(String stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
        }

        @Override
        public final Builder stackDriftStatus(String stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
            return this;
        }

        @Override
        public AwsCloudFormationStackDriftInformationDetails build() {
            return new AwsCloudFormationStackDriftInformationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
