/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The initial validation of each domain name that occurs as a result of the <code>RequestCertificate</code> request
 * </p>
 * </li>
 * <li>
 * <p>
 * The validation of each domain name in the certificate, as it pertains to Certificate Manager managed renewal
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCertificateManagerCertificateDomainValidationOption
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsCertificateManagerCertificateDomainValidationOption.Builder, AwsCertificateManagerCertificateDomainValidationOption> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AwsCertificateManagerCertificateDomainValidationOption::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<AwsCertificateManagerCertificateResourceRecord> RESOURCE_RECORD_FIELD = SdkField
            .<AwsCertificateManagerCertificateResourceRecord> builder(MarshallingType.SDK_POJO).memberName("ResourceRecord")
            .getter(getter(AwsCertificateManagerCertificateDomainValidationOption::resourceRecord))
            .setter(setter(Builder::resourceRecord)).constructor(AwsCertificateManagerCertificateResourceRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecord").build()).build();

    private static final SdkField<String> VALIDATION_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationDomain")
            .getter(getter(AwsCertificateManagerCertificateDomainValidationOption::validationDomain))
            .setter(setter(Builder::validationDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationDomain").build()).build();

    private static final SdkField<List<String>> VALIDATION_EMAILS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ValidationEmails")
            .getter(getter(AwsCertificateManagerCertificateDomainValidationOption::validationEmails))
            .setter(setter(Builder::validationEmails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationEmails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VALIDATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationMethod")
            .getter(getter(AwsCertificateManagerCertificateDomainValidationOption::validationMethod))
            .setter(setter(Builder::validationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationMethod").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStatus")
            .getter(getter(AwsCertificateManagerCertificateDomainValidationOption::validationStatus))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            RESOURCE_RECORD_FIELD, VALIDATION_DOMAIN_FIELD, VALIDATION_EMAILS_FIELD, VALIDATION_METHOD_FIELD,
            VALIDATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final AwsCertificateManagerCertificateResourceRecord resourceRecord;

    private final String validationDomain;

    private final List<String> validationEmails;

    private final String validationMethod;

    private final String validationStatus;

    private AwsCertificateManagerCertificateDomainValidationOption(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.resourceRecord = builder.resourceRecord;
        this.validationDomain = builder.validationDomain;
        this.validationEmails = builder.validationEmails;
        this.validationMethod = builder.validationMethod;
        this.validationStatus = builder.validationStatus;
    }

    /**
     * <p>
     * A fully qualified domain name (FQDN) in the certificate.
     * </p>
     * 
     * @return A fully qualified domain name (FQDN) in the certificate.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The CNAME record that is added to the DNS database for domain validation.
     * </p>
     * 
     * @return The CNAME record that is added to the DNS database for domain validation.
     */
    public final AwsCertificateManagerCertificateResourceRecord resourceRecord() {
        return resourceRecord;
    }

    /**
     * <p>
     * The domain name that Certificate Manager uses to send domain validation emails.
     * </p>
     * 
     * @return The domain name that Certificate Manager uses to send domain validation emails.
     */
    public final String validationDomain() {
        return validationDomain;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationEmails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidationEmails() {
        return validationEmails != null && !(validationEmails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of email addresses that Certificate Manager uses to send domain validation emails.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationEmails} method.
     * </p>
     * 
     * @return A list of email addresses that Certificate Manager uses to send domain validation emails.
     */
    public final List<String> validationEmails() {
        return validationEmails;
    }

    /**
     * <p>
     * The method used to validate the domain name.
     * </p>
     * 
     * @return The method used to validate the domain name.
     */
    public final String validationMethod() {
        return validationMethod;
    }

    /**
     * <p>
     * The validation status of the domain name.
     * </p>
     * 
     * @return The validation status of the domain name.
     */
    public final String validationStatus() {
        return validationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecord());
        hashCode = 31 * hashCode + Objects.hashCode(validationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationEmails() ? validationEmails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(validationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCertificateManagerCertificateDomainValidationOption)) {
            return false;
        }
        AwsCertificateManagerCertificateDomainValidationOption other = (AwsCertificateManagerCertificateDomainValidationOption) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(resourceRecord(), other.resourceRecord())
                && Objects.equals(validationDomain(), other.validationDomain())
                && hasValidationEmails() == other.hasValidationEmails()
                && Objects.equals(validationEmails(), other.validationEmails())
                && Objects.equals(validationMethod(), other.validationMethod())
                && Objects.equals(validationStatus(), other.validationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCertificateManagerCertificateDomainValidationOption").add("DomainName", domainName())
                .add("ResourceRecord", resourceRecord()).add("ValidationDomain", validationDomain())
                .add("ValidationEmails", hasValidationEmails() ? validationEmails() : null)
                .add("ValidationMethod", validationMethod()).add("ValidationStatus", validationStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ResourceRecord":
            return Optional.ofNullable(clazz.cast(resourceRecord()));
        case "ValidationDomain":
            return Optional.ofNullable(clazz.cast(validationDomain()));
        case "ValidationEmails":
            return Optional.ofNullable(clazz.cast(validationEmails()));
        case "ValidationMethod":
            return Optional.ofNullable(clazz.cast(validationMethod()));
        case "ValidationStatus":
            return Optional.ofNullable(clazz.cast(validationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ResourceRecord", RESOURCE_RECORD_FIELD);
        map.put("ValidationDomain", VALIDATION_DOMAIN_FIELD);
        map.put("ValidationEmails", VALIDATION_EMAILS_FIELD);
        map.put("ValidationMethod", VALIDATION_METHOD_FIELD);
        map.put("ValidationStatus", VALIDATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCertificateManagerCertificateDomainValidationOption, T> g) {
        return obj -> g.apply((AwsCertificateManagerCertificateDomainValidationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCertificateManagerCertificateDomainValidationOption> {
        /**
         * <p>
         * A fully qualified domain name (FQDN) in the certificate.
         * </p>
         * 
         * @param domainName
         *        A fully qualified domain name (FQDN) in the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The CNAME record that is added to the DNS database for domain validation.
         * </p>
         * 
         * @param resourceRecord
         *        The CNAME record that is added to the DNS database for domain validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecord(AwsCertificateManagerCertificateResourceRecord resourceRecord);

        /**
         * <p>
         * The CNAME record that is added to the DNS database for domain validation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCertificateManagerCertificateResourceRecord.Builder} avoiding the need to create one manually via
         * {@link AwsCertificateManagerCertificateResourceRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCertificateManagerCertificateResourceRecord.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #resourceRecord(AwsCertificateManagerCertificateResourceRecord)}.
         * 
         * @param resourceRecord
         *        a consumer that will call methods on {@link AwsCertificateManagerCertificateResourceRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRecord(AwsCertificateManagerCertificateResourceRecord)
         */
        default Builder resourceRecord(Consumer<AwsCertificateManagerCertificateResourceRecord.Builder> resourceRecord) {
            return resourceRecord(AwsCertificateManagerCertificateResourceRecord.builder().applyMutation(resourceRecord).build());
        }

        /**
         * <p>
         * The domain name that Certificate Manager uses to send domain validation emails.
         * </p>
         * 
         * @param validationDomain
         *        The domain name that Certificate Manager uses to send domain validation emails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationDomain(String validationDomain);

        /**
         * <p>
         * A list of email addresses that Certificate Manager uses to send domain validation emails.
         * </p>
         * 
         * @param validationEmails
         *        A list of email addresses that Certificate Manager uses to send domain validation emails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationEmails(Collection<String> validationEmails);

        /**
         * <p>
         * A list of email addresses that Certificate Manager uses to send domain validation emails.
         * </p>
         * 
         * @param validationEmails
         *        A list of email addresses that Certificate Manager uses to send domain validation emails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationEmails(String... validationEmails);

        /**
         * <p>
         * The method used to validate the domain name.
         * </p>
         * 
         * @param validationMethod
         *        The method used to validate the domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMethod(String validationMethod);

        /**
         * <p>
         * The validation status of the domain name.
         * </p>
         * 
         * @param validationStatus
         *        The validation status of the domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStatus(String validationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private AwsCertificateManagerCertificateResourceRecord resourceRecord;

        private String validationDomain;

        private List<String> validationEmails = DefaultSdkAutoConstructList.getInstance();

        private String validationMethod;

        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCertificateManagerCertificateDomainValidationOption model) {
            domainName(model.domainName);
            resourceRecord(model.resourceRecord);
            validationDomain(model.validationDomain);
            validationEmails(model.validationEmails);
            validationMethod(model.validationMethod);
            validationStatus(model.validationStatus);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final AwsCertificateManagerCertificateResourceRecord.Builder getResourceRecord() {
            return resourceRecord != null ? resourceRecord.toBuilder() : null;
        }

        public final void setResourceRecord(AwsCertificateManagerCertificateResourceRecord.BuilderImpl resourceRecord) {
            this.resourceRecord = resourceRecord != null ? resourceRecord.build() : null;
        }

        @Override
        public final Builder resourceRecord(AwsCertificateManagerCertificateResourceRecord resourceRecord) {
            this.resourceRecord = resourceRecord;
            return this;
        }

        public final String getValidationDomain() {
            return validationDomain;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final Collection<String> getValidationEmails() {
            if (validationEmails instanceof SdkAutoConstructList) {
                return null;
            }
            return validationEmails;
        }

        public final void setValidationEmails(Collection<String> validationEmails) {
            this.validationEmails = StringListCopier.copy(validationEmails);
        }

        @Override
        public final Builder validationEmails(Collection<String> validationEmails) {
            this.validationEmails = StringListCopier.copy(validationEmails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationEmails(String... validationEmails) {
            validationEmails(Arrays.asList(validationEmails));
            return this;
        }

        public final String getValidationMethod() {
            return validationMethod;
        }

        public final void setValidationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
        }

        @Override
        public final Builder validationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public AwsCertificateManagerCertificateDomainValidationOption build() {
            return new AwsCertificateManagerCertificateDomainValidationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
