/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how long in days before a recovery point transitions to cold storage or is deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupRecoveryPointCalculatedLifecycleDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsBackupRecoveryPointCalculatedLifecycleDetails.Builder, AwsBackupRecoveryPointCalculatedLifecycleDetails> {
    private static final SdkField<String> DELETE_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeleteAt").getter(getter(AwsBackupRecoveryPointCalculatedLifecycleDetails::deleteAt))
            .setter(setter(Builder::deleteAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAt").build()).build();

    private static final SdkField<String> MOVE_TO_COLD_STORAGE_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MoveToColdStorageAt")
            .getter(getter(AwsBackupRecoveryPointCalculatedLifecycleDetails::moveToColdStorageAt))
            .setter(setter(Builder::moveToColdStorageAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoveToColdStorageAt").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_AT_FIELD,
            MOVE_TO_COLD_STORAGE_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deleteAt;

    private final String moveToColdStorageAt;

    private AwsBackupRecoveryPointCalculatedLifecycleDetails(BuilderImpl builder) {
        this.deleteAt = builder.deleteAt;
        this.moveToColdStorageAt = builder.moveToColdStorageAt;
    }

    /**
     * <p>
     * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus
     * <code>MoveToColdStorageAfterDays</code>.
     * </p>
     * 
     * @return Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90
     *         days plus <code>MoveToColdStorageAfterDays</code>.
     */
    public final String deleteAt() {
        return deleteAt;
    }

    /**
     * <p>
     * Specifies the number of days after creation that a recovery point is moved to cold storage.
     * </p>
     * 
     * @return Specifies the number of days after creation that a recovery point is moved to cold storage.
     */
    public final String moveToColdStorageAt() {
        return moveToColdStorageAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleteAt());
        hashCode = 31 * hashCode + Objects.hashCode(moveToColdStorageAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupRecoveryPointCalculatedLifecycleDetails)) {
            return false;
        }
        AwsBackupRecoveryPointCalculatedLifecycleDetails other = (AwsBackupRecoveryPointCalculatedLifecycleDetails) obj;
        return Objects.equals(deleteAt(), other.deleteAt()) && Objects.equals(moveToColdStorageAt(), other.moveToColdStorageAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupRecoveryPointCalculatedLifecycleDetails").add("DeleteAt", deleteAt())
                .add("MoveToColdStorageAt", moveToColdStorageAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteAt":
            return Optional.ofNullable(clazz.cast(deleteAt()));
        case "MoveToColdStorageAt":
            return Optional.ofNullable(clazz.cast(moveToColdStorageAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeleteAt", DELETE_AT_FIELD);
        map.put("MoveToColdStorageAt", MOVE_TO_COLD_STORAGE_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupRecoveryPointCalculatedLifecycleDetails, T> g) {
        return obj -> g.apply((AwsBackupRecoveryPointCalculatedLifecycleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupRecoveryPointCalculatedLifecycleDetails> {
        /**
         * <p>
         * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days
         * plus <code>MoveToColdStorageAfterDays</code>.
         * </p>
         * 
         * @param deleteAt
         *        Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90
         *        days plus <code>MoveToColdStorageAfterDays</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAt(String deleteAt);

        /**
         * <p>
         * Specifies the number of days after creation that a recovery point is moved to cold storage.
         * </p>
         * 
         * @param moveToColdStorageAt
         *        Specifies the number of days after creation that a recovery point is moved to cold storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moveToColdStorageAt(String moveToColdStorageAt);
    }

    static final class BuilderImpl implements Builder {
        private String deleteAt;

        private String moveToColdStorageAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupRecoveryPointCalculatedLifecycleDetails model) {
            deleteAt(model.deleteAt);
            moveToColdStorageAt(model.moveToColdStorageAt);
        }

        public final String getDeleteAt() {
            return deleteAt;
        }

        public final void setDeleteAt(String deleteAt) {
            this.deleteAt = deleteAt;
        }

        @Override
        public final Builder deleteAt(String deleteAt) {
            this.deleteAt = deleteAt;
            return this;
        }

        public final String getMoveToColdStorageAt() {
            return moveToColdStorageAt;
        }

        public final void setMoveToColdStorageAt(String moveToColdStorageAt) {
            this.moveToColdStorageAt = moveToColdStorageAt;
        }

        @Override
        public final Builder moveToColdStorageAt(String moveToColdStorageAt) {
            this.moveToColdStorageAt = moveToColdStorageAt;
            return this;
        }

        @Override
        public AwsBackupRecoveryPointCalculatedLifecycleDetails build() {
            return new AwsBackupRecoveryPointCalculatedLifecycleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
