/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata options for the instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingLaunchConfigurationMetadataOptions
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAutoScalingLaunchConfigurationMetadataOptions.Builder, AwsAutoScalingLaunchConfigurationMetadataOptions> {
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpEndpoint").getter(getter(AwsAutoScalingLaunchConfigurationMetadataOptions::httpEndpoint))
            .setter(setter(Builder::httpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").build()).build();

    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("HttpPutResponseHopLimit")
            .getter(getter(AwsAutoScalingLaunchConfigurationMetadataOptions::httpPutResponseHopLimit))
            .setter(setter(Builder::httpPutResponseHopLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").build())
            .build();

    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpTokens").getter(getter(AwsAutoScalingLaunchConfigurationMetadataOptions::httpTokens))
            .setter(setter(Builder::httpTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ENDPOINT_FIELD,
            HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_TOKENS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String httpEndpoint;

    private final Integer httpPutResponseHopLimit;

    private final String httpTokens;

    private AwsAutoScalingLaunchConfigurationMetadataOptions(BuilderImpl builder) {
        this.httpEndpoint = builder.httpEndpoint;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpTokens = builder.httpTokens;
    }

    /**
     * <p>
     * Enables or disables the HTTP metadata endpoint on your instances. By default, the metadata endpoint is enabled.
     * </p>
     * 
     * @return Enables or disables the HTTP metadata endpoint on your instances. By default, the metadata endpoint is
     *         enabled.
     */
    public final String httpEndpoint() {
        return httpEndpoint;
    }

    /**
     * <p>
     * The HTTP <code>PUT</code> response hop limit for instance metadata requests. The larger the number, the further
     * instance metadata requests can travel.
     * </p>
     * 
     * @return The HTTP <code>PUT</code> response hop limit for instance metadata requests. The larger the number, the
     *         further instance metadata requests can travel.
     */
    public final Integer httpPutResponseHopLimit() {
        return httpPutResponseHopLimit;
    }

    /**
     * <p>
     * Indicates whether token usage is <code>required</code> or <code>optional</code> for metadata requests. By
     * default, token usage is <code>optional</code>.
     * </p>
     * 
     * @return Indicates whether token usage is <code>required</code> or <code>optional</code> for metadata requests. By
     *         default, token usage is <code>optional</code>.
     */
    public final String httpTokens() {
        return httpTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(httpTokens());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingLaunchConfigurationMetadataOptions)) {
            return false;
        }
        AwsAutoScalingLaunchConfigurationMetadataOptions other = (AwsAutoScalingLaunchConfigurationMetadataOptions) obj;
        return Objects.equals(httpEndpoint(), other.httpEndpoint())
                && Objects.equals(httpPutResponseHopLimit(), other.httpPutResponseHopLimit())
                && Objects.equals(httpTokens(), other.httpTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingLaunchConfigurationMetadataOptions").add("HttpEndpoint", httpEndpoint())
                .add("HttpPutResponseHopLimit", httpPutResponseHopLimit()).add("HttpTokens", httpTokens()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpEndpoint":
            return Optional.ofNullable(clazz.cast(httpEndpoint()));
        case "HttpPutResponseHopLimit":
            return Optional.ofNullable(clazz.cast(httpPutResponseHopLimit()));
        case "HttpTokens":
            return Optional.ofNullable(clazz.cast(httpTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HttpEndpoint", HTTP_ENDPOINT_FIELD);
        map.put("HttpPutResponseHopLimit", HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD);
        map.put("HttpTokens", HTTP_TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingLaunchConfigurationMetadataOptions, T> g) {
        return obj -> g.apply((AwsAutoScalingLaunchConfigurationMetadataOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAutoScalingLaunchConfigurationMetadataOptions> {
        /**
         * <p>
         * Enables or disables the HTTP metadata endpoint on your instances. By default, the metadata endpoint is
         * enabled.
         * </p>
         * 
         * @param httpEndpoint
         *        Enables or disables the HTTP metadata endpoint on your instances. By default, the metadata endpoint is
         *        enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpEndpoint(String httpEndpoint);

        /**
         * <p>
         * The HTTP <code>PUT</code> response hop limit for instance metadata requests. The larger the number, the
         * further instance metadata requests can travel.
         * </p>
         * 
         * @param httpPutResponseHopLimit
         *        The HTTP <code>PUT</code> response hop limit for instance metadata requests. The larger the number,
         *        the further instance metadata requests can travel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit);

        /**
         * <p>
         * Indicates whether token usage is <code>required</code> or <code>optional</code> for metadata requests. By
         * default, token usage is <code>optional</code>.
         * </p>
         * 
         * @param httpTokens
         *        Indicates whether token usage is <code>required</code> or <code>optional</code> for metadata requests.
         *        By default, token usage is <code>optional</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpTokens(String httpTokens);
    }

    static final class BuilderImpl implements Builder {
        private String httpEndpoint;

        private Integer httpPutResponseHopLimit;

        private String httpTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingLaunchConfigurationMetadataOptions model) {
            httpEndpoint(model.httpEndpoint);
            httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            httpTokens(model.httpTokens);
        }

        public final String getHttpEndpoint() {
            return httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpTokens() {
            return httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public AwsAutoScalingLaunchConfigurationMetadataOptions build() {
            return new AwsAutoScalingLaunchConfigurationMetadataOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
