/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A block device for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder, AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails> EBS_FIELD = SdkField
            .<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails> builder(MarshallingType.SDK_POJO).memberName("Ebs")
            .getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails::ebs)).setter(setter(Builder::ebs))
            .constructor(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").build()).build();

    private static final SdkField<Boolean> NO_DEVICE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoDevice").getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails::noDevice))
            .setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice").build()).build();

    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VirtualName").getter(getter(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails::virtualName))
            .setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD,
            NO_DEVICE_FIELD, VIRTUAL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails ebs;

    private final Boolean noDevice;

    private final String virtualName;

    private AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    /**
     * <p>
     * The device name that is exposed to the EC2 instance. For example, <code>/dev/sdh</code> or <code>xvdh</code>.
     * </p>
     * 
     * @return The device name that is exposed to the EC2 instance. For example, <code>/dev/sdh</code> or
     *         <code>xvdh</code>.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.
     * </p>
     * 
     * @return Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.
     */
    public final AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails ebs() {
        return ebs;
    }

    /**
     * <p>
     * Whether to suppress the device that is included in the block device mapping of the Amazon Machine Image (AMI).
     * </p>
     * <p>
     * If <code>NoDevice</code> is <code>true</code>, then you cannot specify <code>Ebs</code>.&gt;
     * </p>
     * 
     * @return Whether to suppress the device that is included in the block device mapping of the Amazon Machine Image
     *         (AMI).</p>
     *         <p>
     *         If <code>NoDevice</code> is <code>true</code>, then you cannot specify <code>Ebs</code>.&gt;
     */
    public final Boolean noDevice() {
        return noDevice;
    }

    /**
     * <p>
     * The name of the virtual device (for example, <code>ephemeral0</code>).
     * </p>
     * <p>
     * You can provide either <code>VirtualName</code> or <code>Ebs</code>, but not both.
     * </p>
     * 
     * @return The name of the virtual device (for example, <code>ephemeral0</code>).</p>
     *         <p>
     *         You can provide either <code>VirtualName</code> or <code>Ebs</code>, but not both.
     */
    public final String virtualName() {
        return virtualName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails)) {
            return false;
        }
        AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails other = (AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ebs(), other.ebs())
                && Objects.equals(noDevice(), other.noDevice()) && Objects.equals(virtualName(), other.virtualName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails").add("DeviceName", deviceName())
                .add("Ebs", ebs()).add("NoDevice", noDevice()).add("VirtualName", virtualName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        case "VirtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("Ebs", EBS_FIELD);
        map.put("NoDevice", NO_DEVICE_FIELD);
        map.put("VirtualName", VIRTUAL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> {
        /**
         * <p>
         * The device name that is exposed to the EC2 instance. For example, <code>/dev/sdh</code> or <code>xvdh</code>.
         * </p>
         * 
         * @param deviceName
         *        The device name that is exposed to the EC2 instance. For example, <code>/dev/sdh</code> or
         *        <code>xvdh</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails ebs);

        /**
         * <p>
         * Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.Builder} avoiding the need to create
         * one manually via {@link AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #ebs(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails)}.
         * 
         * @param ebs
         *        a consumer that will call methods on
         *        {@link AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails)
         */
        default Builder ebs(Consumer<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.Builder> ebs) {
            return ebs(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.builder().applyMutation(ebs).build());
        }

        /**
         * <p>
         * Whether to suppress the device that is included in the block device mapping of the Amazon Machine Image
         * (AMI).
         * </p>
         * <p>
         * If <code>NoDevice</code> is <code>true</code>, then you cannot specify <code>Ebs</code>.&gt;
         * </p>
         * 
         * @param noDevice
         *        Whether to suppress the device that is included in the block device mapping of the Amazon Machine
         *        Image (AMI).</p>
         *        <p>
         *        If <code>NoDevice</code> is <code>true</code>, then you cannot specify <code>Ebs</code>.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(Boolean noDevice);

        /**
         * <p>
         * The name of the virtual device (for example, <code>ephemeral0</code>).
         * </p>
         * <p>
         * You can provide either <code>VirtualName</code> or <code>Ebs</code>, but not both.
         * </p>
         * 
         * @param virtualName
         *        The name of the virtual device (for example, <code>ephemeral0</code>).</p>
         *        <p>
         *        You can provide either <code>VirtualName</code> or <code>Ebs</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails ebs;

        private Boolean noDevice;

        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
            noDevice(model.noDevice);
            virtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        public final void setEbs(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public final Builder ebs(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails ebs) {
            this.ebs = ebs;
            return this;
        }

        public final Boolean getNoDevice() {
            return noDevice;
        }

        public final void setNoDevice(Boolean noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public final Builder noDevice(Boolean noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        @Override
        public AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails build() {
            return new AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
