/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The mixed instances policy for the automatic scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder, AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails> {
    private static final SdkField<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails> INSTANCES_DISTRIBUTION_FIELD = SdkField
            .<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails> builder(MarshallingType.SDK_POJO)
            .memberName("InstancesDistribution")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails::instancesDistribution))
            .setter(setter(Builder::instancesDistribution))
            .constructor(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesDistribution").build())
            .build();

    private static final SdkField<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails> LAUNCH_TEMPLATE_FIELD = SdkField
            .<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplate")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails::launchTemplate))
            .setter(setter(Builder::launchTemplate))
            .constructor(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_DISTRIBUTION_FIELD,
            LAUNCH_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails instancesDistribution;

    private final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails launchTemplate;

    private AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails(BuilderImpl builder) {
        this.instancesDistribution = builder.instancesDistribution;
        this.launchTemplate = builder.launchTemplate;
    }

    /**
     * <p>
     * The instances distribution. The instances distribution specifies the distribution of On-Demand Instances and Spot
     * Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates instance types
     * to fulfill On-Demand and Spot capacity.
     * </p>
     * 
     * @return The instances distribution. The instances distribution specifies the distribution of On-Demand Instances
     *         and Spot Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates
     *         instance types to fulfill On-Demand and Spot capacity.
     */
    public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails instancesDistribution() {
        return instancesDistribution;
    }

    /**
     * <p>
     * The launch template to use and the instance types (overrides) to use to provision EC2 instances to fulfill
     * On-Demand and Spot capacities.
     * </p>
     * 
     * @return The launch template to use and the instance types (overrides) to use to provision EC2 instances to
     *         fulfill On-Demand and Spot capacities.
     */
    public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails launchTemplate() {
        return launchTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instancesDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails)) {
            return false;
        }
        AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails other = (AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) obj;
        return Objects.equals(instancesDistribution(), other.instancesDistribution())
                && Objects.equals(launchTemplate(), other.launchTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails")
                .add("InstancesDistribution", instancesDistribution()).add("LaunchTemplate", launchTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstancesDistribution":
            return Optional.ofNullable(clazz.cast(instancesDistribution()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstancesDistribution", INSTANCES_DISTRIBUTION_FIELD);
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails> {
        /**
         * <p>
         * The instances distribution. The instances distribution specifies the distribution of On-Demand Instances and
         * Spot Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates
         * instance types to fulfill On-Demand and Spot capacity.
         * </p>
         * 
         * @param instancesDistribution
         *        The instances distribution. The instances distribution specifies the distribution of On-Demand
         *        Instances and Spot Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling
         *        group allocates instance types to fulfill On-Demand and Spot capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesDistribution(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails instancesDistribution);

        /**
         * <p>
         * The instances distribution. The instances distribution specifies the distribution of On-Demand Instances and
         * Spot Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates
         * instance types to fulfill On-Demand and Spot capacity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.Builder} avoiding the
         * need to create one manually via
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #instancesDistribution(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails)}.
         * 
         * @param instancesDistribution
         *        a consumer that will call methods on
         *        {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instancesDistribution(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails)
         */
        default Builder instancesDistribution(
                Consumer<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.Builder> instancesDistribution) {
            return instancesDistribution(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.builder()
                    .applyMutation(instancesDistribution).build());
        }

        /**
         * <p>
         * The launch template to use and the instance types (overrides) to use to provision EC2 instances to fulfill
         * On-Demand and Spot capacities.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template to use and the instance types (overrides) to use to provision EC2 instances to
         *        fulfill On-Demand and Spot capacities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails launchTemplate);

        /**
         * <p>
         * The launch template to use and the instance types (overrides) to use to provision EC2 instances to fulfill
         * On-Demand and Spot capacities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.Builder} avoiding the need to
         * create one manually via
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #launchTemplate(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on
         *        {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails)
         */
        default Builder launchTemplate(
                Consumer<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.Builder> launchTemplate) {
            return launchTemplate(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.builder()
                    .applyMutation(launchTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails instancesDistribution;

        private AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails launchTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails model) {
            instancesDistribution(model.instancesDistribution);
            launchTemplate(model.launchTemplate);
        }

        public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.Builder getInstancesDistribution() {
            return instancesDistribution != null ? instancesDistribution.toBuilder() : null;
        }

        public final void setInstancesDistribution(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.BuilderImpl instancesDistribution) {
            this.instancesDistribution = instancesDistribution != null ? instancesDistribution.build() : null;
        }

        @Override
        public final Builder instancesDistribution(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails instancesDistribution) {
            this.instancesDistribution = instancesDistribution;
            return this;
        }

        public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        @Override
        public AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails build() {
            return new AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
