/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the authorization configuration for using an OpenID Connect compliant service with your AppSync GraphQL API
 * endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAppSyncGraphQlApiOpenIdConnectConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder, AwsAppSyncGraphQlApiOpenIdConnectConfigDetails> {
    private static final SdkField<Long> AUTH_TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("AuthTtL")
            .getter(getter(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails::authTtL)).setter(setter(Builder::authTtL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTtL").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails::clientId))
            .setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<Long> IAT_TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("IatTtL")
            .getter(getter(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails::iatTtL)).setter(setter(Builder::iatTtL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IatTtL").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issuer")
            .getter(getter(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TTL_FIELD,
            CLIENT_ID_FIELD, IAT_TTL_FIELD, ISSUER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long authTtL;

    private final String clientId;

    private final Long iatTtL;

    private final String issuer;

    private AwsAppSyncGraphQlApiOpenIdConnectConfigDetails(BuilderImpl builder) {
        this.authTtL = builder.authTtL;
        this.clientId = builder.clientId;
        this.iatTtL = builder.iatTtL;
        this.issuer = builder.issuer;
    }

    /**
     * <p>
     * The number of milliseconds that a token is valid after being authenticated.
     * </p>
     * 
     * @return The number of milliseconds that a token is valid after being authenticated.
     */
    public final Long authTtL() {
        return authTtL;
    }

    /**
     * <p>
     * The client identifier of the relying party at the OpenID identity provider. This identifier is typically obtained
     * when the relying party is registered with the OpenID identity provider. You can specify a regular expression so
     * that AppSync can validate against multiple client identifiers at a time.
     * </p>
     * 
     * @return The client identifier of the relying party at the OpenID identity provider. This identifier is typically
     *         obtained when the relying party is registered with the OpenID identity provider. You can specify a
     *         regular expression so that AppSync can validate against multiple client identifiers at a time.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The number of milliseconds that a token is valid after it's issued to a user.
     * </p>
     * 
     * @return The number of milliseconds that a token is valid after it's issued to a user.
     */
    public final Long iatTtL() {
        return iatTtL;
    }

    /**
     * <p>
     * The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of
     * <code>iss</code> in the ID token.
     * </p>
     * 
     * @return The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of
     *         <code>iss</code> in the ID token.
     */
    public final String issuer() {
        return issuer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authTtL());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(iatTtL());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAppSyncGraphQlApiOpenIdConnectConfigDetails)) {
            return false;
        }
        AwsAppSyncGraphQlApiOpenIdConnectConfigDetails other = (AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) obj;
        return Objects.equals(authTtL(), other.authTtL()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(iatTtL(), other.iatTtL()) && Objects.equals(issuer(), other.issuer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAppSyncGraphQlApiOpenIdConnectConfigDetails").add("AuthTtL", authTtL())
                .add("ClientId", clientId()).add("IatTtL", iatTtL()).add("Issuer", issuer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthTtL":
            return Optional.ofNullable(clazz.cast(authTtL()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "IatTtL":
            return Optional.ofNullable(clazz.cast(iatTtL()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthTtL", AUTH_TTL_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("IatTtL", IAT_TTL_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAppSyncGraphQlApiOpenIdConnectConfigDetails, T> g) {
        return obj -> g.apply((AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAppSyncGraphQlApiOpenIdConnectConfigDetails> {
        /**
         * <p>
         * The number of milliseconds that a token is valid after being authenticated.
         * </p>
         * 
         * @param authTtL
         *        The number of milliseconds that a token is valid after being authenticated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTtL(Long authTtL);

        /**
         * <p>
         * The client identifier of the relying party at the OpenID identity provider. This identifier is typically
         * obtained when the relying party is registered with the OpenID identity provider. You can specify a regular
         * expression so that AppSync can validate against multiple client identifiers at a time.
         * </p>
         * 
         * @param clientId
         *        The client identifier of the relying party at the OpenID identity provider. This identifier is
         *        typically obtained when the relying party is registered with the OpenID identity provider. You can
         *        specify a regular expression so that AppSync can validate against multiple client identifiers at a
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The number of milliseconds that a token is valid after it's issued to a user.
         * </p>
         * 
         * @param iatTtL
         *        The number of milliseconds that a token is valid after it's issued to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iatTtL(Long iatTtL);

        /**
         * <p>
         * The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of
         * <code>iss</code> in the ID token.
         * </p>
         * 
         * @param issuer
         *        The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value
         *        of <code>iss</code> in the ID token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);
    }

    static final class BuilderImpl implements Builder {
        private Long authTtL;

        private String clientId;

        private Long iatTtL;

        private String issuer;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails model) {
            authTtL(model.authTtL);
            clientId(model.clientId);
            iatTtL(model.iatTtL);
            issuer(model.issuer);
        }

        public final Long getAuthTtL() {
            return authTtL;
        }

        public final void setAuthTtL(Long authTtL) {
            this.authTtL = authTtL;
        }

        @Override
        public final Builder authTtL(Long authTtL) {
            this.authTtL = authTtL;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Long getIatTtL() {
            return iatTtL;
        }

        public final void setIatTtL(Long iatTtL) {
            this.iatTtL = iatTtL;
        }

        @Override
        public final Builder iatTtL(Long iatTtL) {
            this.iatTtL = iatTtL;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        @Override
        public AwsAppSyncGraphQlApiOpenIdConnectConfigDetails build() {
            return new AwsAppSyncGraphQlApiOpenIdConnectConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
