/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the authorization configuration for using an Lambda function with your AppSync GraphQL API endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder, AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails> {
    private static final SdkField<Integer> AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AuthorizerResultTtlInSeconds")
            .getter(getter(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails::authorizerResultTtlInSeconds))
            .setter(setter(Builder::authorizerResultTtlInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizerResultTtlInSeconds")
                    .build()).build();

    private static final SdkField<String> AUTHORIZER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizerUri").getter(getter(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails::authorizerUri))
            .setter(setter(Builder::authorizerUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizerUri").build()).build();

    private static final SdkField<String> IDENTITY_VALIDATION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityValidationExpression")
            .getter(getter(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails::identityValidationExpression))
            .setter(setter(Builder::identityValidationExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityValidationExpression")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD, AUTHORIZER_URI_FIELD, IDENTITY_VALIDATION_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer authorizerResultTtlInSeconds;

    private final String authorizerUri;

    private final String identityValidationExpression;

    private AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails(BuilderImpl builder) {
        this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
        this.authorizerUri = builder.authorizerUri;
        this.identityValidationExpression = builder.identityValidationExpression;
    }

    /**
     * <p>
     * The number of seconds a response should be cached for. The default is 5 minutes (300 seconds).
     * </p>
     * 
     * @return The number of seconds a response should be cached for. The default is 5 minutes (300 seconds).
     */
    public final Integer authorizerResultTtlInSeconds() {
        return authorizerResultTtlInSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a standard
     * Lambda ARN, a version ARN (.../v3), or an alias ARN.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a
     *         standard Lambda ARN, a version ARN (.../v3), or an alias ARN.
     */
    public final String authorizerUri() {
        return authorizerUri;
    }

    /**
     * <p>
     * A regular expression for validation of tokens before the Lambda function is called.
     * </p>
     * 
     * @return A regular expression for validation of tokens before the Lambda function is called.
     */
    public final String identityValidationExpression() {
        return identityValidationExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizerResultTtlInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerUri());
        hashCode = 31 * hashCode + Objects.hashCode(identityValidationExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails)) {
            return false;
        }
        AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails other = (AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) obj;
        return Objects.equals(authorizerResultTtlInSeconds(), other.authorizerResultTtlInSeconds())
                && Objects.equals(authorizerUri(), other.authorizerUri())
                && Objects.equals(identityValidationExpression(), other.identityValidationExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails")
                .add("AuthorizerResultTtlInSeconds", authorizerResultTtlInSeconds()).add("AuthorizerUri", authorizerUri())
                .add("IdentityValidationExpression", identityValidationExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizerResultTtlInSeconds":
            return Optional.ofNullable(clazz.cast(authorizerResultTtlInSeconds()));
        case "AuthorizerUri":
            return Optional.ofNullable(clazz.cast(authorizerUri()));
        case "IdentityValidationExpression":
            return Optional.ofNullable(clazz.cast(identityValidationExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizerResultTtlInSeconds", AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD);
        map.put("AuthorizerUri", AUTHORIZER_URI_FIELD);
        map.put("IdentityValidationExpression", IDENTITY_VALIDATION_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails, T> g) {
        return obj -> g.apply((AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails> {
        /**
         * <p>
         * The number of seconds a response should be cached for. The default is 5 minutes (300 seconds).
         * </p>
         * 
         * @param authorizerResultTtlInSeconds
         *        The number of seconds a response should be cached for. The default is 5 minutes (300 seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a standard
         * Lambda ARN, a version ARN (.../v3), or an alias ARN.
         * </p>
         * 
         * @param authorizerUri
         *        The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a
         *        standard Lambda ARN, a version ARN (.../v3), or an alias ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerUri(String authorizerUri);

        /**
         * <p>
         * A regular expression for validation of tokens before the Lambda function is called.
         * </p>
         * 
         * @param identityValidationExpression
         *        A regular expression for validation of tokens before the Lambda function is called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityValidationExpression(String identityValidationExpression);
    }

    static final class BuilderImpl implements Builder {
        private Integer authorizerResultTtlInSeconds;

        private String authorizerUri;

        private String identityValidationExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails model) {
            authorizerResultTtlInSeconds(model.authorizerResultTtlInSeconds);
            authorizerUri(model.authorizerUri);
            identityValidationExpression(model.identityValidationExpression);
        }

        public final Integer getAuthorizerResultTtlInSeconds() {
            return authorizerResultTtlInSeconds;
        }

        public final void setAuthorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
        }

        @Override
        public final Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        public final String getAuthorizerUri() {
            return authorizerUri;
        }

        public final void setAuthorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
        }

        @Override
        public final Builder authorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        public final String getIdentityValidationExpression() {
            return identityValidationExpression;
        }

        public final void setIdentityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
        }

        @Override
        public final Builder identityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        @Override
        public AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails build() {
            return new AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
