/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provided if <code>ActionType</code> is <code>AWS_API_CALL</code>. It provides details about the API call that was
 * detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsApiCallAction implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsApiCallAction.Builder, AwsApiCallAction> {
    private static final SdkField<String> API_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Api")
            .getter(getter(AwsApiCallAction::api)).setter(setter(Builder::api))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Api").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(AwsApiCallAction::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> CALLER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallerType").getter(getter(AwsApiCallAction::callerType)).setter(setter(Builder::callerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerType").build()).build();

    private static final SdkField<ActionRemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField
            .<ActionRemoteIpDetails> builder(MarshallingType.SDK_POJO).memberName("RemoteIpDetails")
            .getter(getter(AwsApiCallAction::remoteIpDetails)).setter(setter(Builder::remoteIpDetails))
            .constructor(ActionRemoteIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpDetails").build()).build();

    private static final SdkField<AwsApiCallActionDomainDetails> DOMAIN_DETAILS_FIELD = SdkField
            .<AwsApiCallActionDomainDetails> builder(MarshallingType.SDK_POJO).memberName("DomainDetails")
            .getter(getter(AwsApiCallAction::domainDetails)).setter(setter(Builder::domainDetails))
            .constructor(AwsApiCallActionDomainDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDetails").build()).build();

    private static final SdkField<Map<String, String>> AFFECTED_RESOURCES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AffectedResources")
            .getter(getter(AwsApiCallAction::affectedResources))
            .setter(setter(Builder::affectedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedResources").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FIRST_SEEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstSeen").getter(getter(AwsApiCallAction::firstSeen)).setter(setter(Builder::firstSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSeen").build()).build();

    private static final SdkField<String> LAST_SEEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastSeen").getter(getter(AwsApiCallAction::lastSeen)).setter(setter(Builder::lastSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSeen").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_FIELD, SERVICE_NAME_FIELD,
            CALLER_TYPE_FIELD, REMOTE_IP_DETAILS_FIELD, DOMAIN_DETAILS_FIELD, AFFECTED_RESOURCES_FIELD, FIRST_SEEN_FIELD,
            LAST_SEEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String api;

    private final String serviceName;

    private final String callerType;

    private final ActionRemoteIpDetails remoteIpDetails;

    private final AwsApiCallActionDomainDetails domainDetails;

    private final Map<String, String> affectedResources;

    private final String firstSeen;

    private final String lastSeen;

    private AwsApiCallAction(BuilderImpl builder) {
        this.api = builder.api;
        this.serviceName = builder.serviceName;
        this.callerType = builder.callerType;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.domainDetails = builder.domainDetails;
        this.affectedResources = builder.affectedResources;
        this.firstSeen = builder.firstSeen;
        this.lastSeen = builder.lastSeen;
    }

    /**
     * <p>
     * The name of the API method that was issued.
     * </p>
     * <p>
     * Length Constraints: 128.
     * </p>
     * 
     * @return The name of the API method that was issued.</p>
     *         <p>
     *         Length Constraints: 128.
     */
    public final String api() {
        return api;
    }

    /**
     * <p>
     * The name of the Amazon Web Services service that the API method belongs to.
     * </p>
     * <p>
     * Length Constraints: 128.
     * </p>
     * 
     * @return The name of the Amazon Web Services service that the API method belongs to.</p>
     *         <p>
     *         Length Constraints: 128.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * Indicates whether the API call originated from a remote IP address (<code>remoteip</code>) or from a DNS domain (
     * <code>domain</code>).
     * </p>
     * 
     * @return Indicates whether the API call originated from a remote IP address (<code>remoteip</code>) or from a DNS
     *         domain (<code>domain</code>).
     */
    public final String callerType() {
        return callerType;
    }

    /**
     * <p>
     * Provided if <code>CallerType</code> is <code>remoteip</code>. Provides information about the remote IP address
     * that the API call originated from.
     * </p>
     * 
     * @return Provided if <code>CallerType</code> is <code>remoteip</code>. Provides information about the remote IP
     *         address that the API call originated from.
     */
    public final ActionRemoteIpDetails remoteIpDetails() {
        return remoteIpDetails;
    }

    /**
     * <p>
     * Provided if <code>CallerType</code> is <code>domain</code>. Provides information about the DNS domain that the
     * API call originated from.
     * </p>
     * 
     * @return Provided if <code>CallerType</code> is <code>domain</code>. Provides information about the DNS domain
     *         that the API call originated from.
     */
    public final AwsApiCallActionDomainDetails domainDetails() {
        return domainDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the AffectedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAffectedResources() {
        return affectedResources != null && !(affectedResources instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Identifies the resources that were affected by the API call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAffectedResources} method.
     * </p>
     * 
     * @return Identifies the resources that were affected by the API call.
     */
    public final Map<String, String> affectedResources() {
        return affectedResources;
    }

    /**
     * <p>
     * A timestamp that indicates when the API call was first observed.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return A timestamp that indicates when the API call was first observed.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String firstSeen() {
        return firstSeen;
    }

    /**
     * <p>
     * A timestamp that indicates when the API call was most recently observed.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return A timestamp that indicates when the API call was most recently observed.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String lastSeen() {
        return lastSeen;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(api());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(callerType());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(domainDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasAffectedResources() ? affectedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeen());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiCallAction)) {
            return false;
        }
        AwsApiCallAction other = (AwsApiCallAction) obj;
        return Objects.equals(api(), other.api()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(callerType(), other.callerType()) && Objects.equals(remoteIpDetails(), other.remoteIpDetails())
                && Objects.equals(domainDetails(), other.domainDetails())
                && hasAffectedResources() == other.hasAffectedResources()
                && Objects.equals(affectedResources(), other.affectedResources())
                && Objects.equals(firstSeen(), other.firstSeen()) && Objects.equals(lastSeen(), other.lastSeen());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsApiCallAction").add("Api", api()).add("ServiceName", serviceName())
                .add("CallerType", callerType()).add("RemoteIpDetails", remoteIpDetails()).add("DomainDetails", domainDetails())
                .add("AffectedResources", hasAffectedResources() ? affectedResources() : null).add("FirstSeen", firstSeen())
                .add("LastSeen", lastSeen()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Api":
            return Optional.ofNullable(clazz.cast(api()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "CallerType":
            return Optional.ofNullable(clazz.cast(callerType()));
        case "RemoteIpDetails":
            return Optional.ofNullable(clazz.cast(remoteIpDetails()));
        case "DomainDetails":
            return Optional.ofNullable(clazz.cast(domainDetails()));
        case "AffectedResources":
            return Optional.ofNullable(clazz.cast(affectedResources()));
        case "FirstSeen":
            return Optional.ofNullable(clazz.cast(firstSeen()));
        case "LastSeen":
            return Optional.ofNullable(clazz.cast(lastSeen()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Api", API_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("CallerType", CALLER_TYPE_FIELD);
        map.put("RemoteIpDetails", REMOTE_IP_DETAILS_FIELD);
        map.put("DomainDetails", DOMAIN_DETAILS_FIELD);
        map.put("AffectedResources", AFFECTED_RESOURCES_FIELD);
        map.put("FirstSeen", FIRST_SEEN_FIELD);
        map.put("LastSeen", LAST_SEEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsApiCallAction, T> g) {
        return obj -> g.apply((AwsApiCallAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsApiCallAction> {
        /**
         * <p>
         * The name of the API method that was issued.
         * </p>
         * <p>
         * Length Constraints: 128.
         * </p>
         * 
         * @param api
         *        The name of the API method that was issued.</p>
         *        <p>
         *        Length Constraints: 128.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder api(String api);

        /**
         * <p>
         * The name of the Amazon Web Services service that the API method belongs to.
         * </p>
         * <p>
         * Length Constraints: 128.
         * </p>
         * 
         * @param serviceName
         *        The name of the Amazon Web Services service that the API method belongs to.</p>
         *        <p>
         *        Length Constraints: 128.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * Indicates whether the API call originated from a remote IP address (<code>remoteip</code>) or from a DNS
         * domain (<code>domain</code>).
         * </p>
         * 
         * @param callerType
         *        Indicates whether the API call originated from a remote IP address (<code>remoteip</code>) or from a
         *        DNS domain (<code>domain</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerType(String callerType);

        /**
         * <p>
         * Provided if <code>CallerType</code> is <code>remoteip</code>. Provides information about the remote IP
         * address that the API call originated from.
         * </p>
         * 
         * @param remoteIpDetails
         *        Provided if <code>CallerType</code> is <code>remoteip</code>. Provides information about the remote IP
         *        address that the API call originated from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpDetails(ActionRemoteIpDetails remoteIpDetails);

        /**
         * <p>
         * Provided if <code>CallerType</code> is <code>remoteip</code>. Provides information about the remote IP
         * address that the API call originated from.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionRemoteIpDetails.Builder} avoiding
         * the need to create one manually via {@link ActionRemoteIpDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionRemoteIpDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #remoteIpDetails(ActionRemoteIpDetails)}.
         * 
         * @param remoteIpDetails
         *        a consumer that will call methods on {@link ActionRemoteIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteIpDetails(ActionRemoteIpDetails)
         */
        default Builder remoteIpDetails(Consumer<ActionRemoteIpDetails.Builder> remoteIpDetails) {
            return remoteIpDetails(ActionRemoteIpDetails.builder().applyMutation(remoteIpDetails).build());
        }

        /**
         * <p>
         * Provided if <code>CallerType</code> is <code>domain</code>. Provides information about the DNS domain that
         * the API call originated from.
         * </p>
         * 
         * @param domainDetails
         *        Provided if <code>CallerType</code> is <code>domain</code>. Provides information about the DNS domain
         *        that the API call originated from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDetails(AwsApiCallActionDomainDetails domainDetails);

        /**
         * <p>
         * Provided if <code>CallerType</code> is <code>domain</code>. Provides information about the DNS domain that
         * the API call originated from.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiCallActionDomainDetails.Builder}
         * avoiding the need to create one manually via {@link AwsApiCallActionDomainDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiCallActionDomainDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #domainDetails(AwsApiCallActionDomainDetails)}.
         * 
         * @param domainDetails
         *        a consumer that will call methods on {@link AwsApiCallActionDomainDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainDetails(AwsApiCallActionDomainDetails)
         */
        default Builder domainDetails(Consumer<AwsApiCallActionDomainDetails.Builder> domainDetails) {
            return domainDetails(AwsApiCallActionDomainDetails.builder().applyMutation(domainDetails).build());
        }

        /**
         * <p>
         * Identifies the resources that were affected by the API call.
         * </p>
         * 
         * @param affectedResources
         *        Identifies the resources that were affected by the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedResources(Map<String, String> affectedResources);

        /**
         * <p>
         * A timestamp that indicates when the API call was first observed.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param firstSeen
         *        A timestamp that indicates when the API call was first observed.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSeen(String firstSeen);

        /**
         * <p>
         * A timestamp that indicates when the API call was most recently observed.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param lastSeen
         *        A timestamp that indicates when the API call was most recently observed.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeen(String lastSeen);
    }

    static final class BuilderImpl implements Builder {
        private String api;

        private String serviceName;

        private String callerType;

        private ActionRemoteIpDetails remoteIpDetails;

        private AwsApiCallActionDomainDetails domainDetails;

        private Map<String, String> affectedResources = DefaultSdkAutoConstructMap.getInstance();

        private String firstSeen;

        private String lastSeen;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiCallAction model) {
            api(model.api);
            serviceName(model.serviceName);
            callerType(model.callerType);
            remoteIpDetails(model.remoteIpDetails);
            domainDetails(model.domainDetails);
            affectedResources(model.affectedResources);
            firstSeen(model.firstSeen);
            lastSeen(model.lastSeen);
        }

        public final String getApi() {
            return api;
        }

        public final void setApi(String api) {
            this.api = api;
        }

        @Override
        public final Builder api(String api) {
            this.api = api;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getCallerType() {
            return callerType;
        }

        public final void setCallerType(String callerType) {
            this.callerType = callerType;
        }

        @Override
        public final Builder callerType(String callerType) {
            this.callerType = callerType;
            return this;
        }

        public final ActionRemoteIpDetails.Builder getRemoteIpDetails() {
            return remoteIpDetails != null ? remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(ActionRemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(ActionRemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final AwsApiCallActionDomainDetails.Builder getDomainDetails() {
            return domainDetails != null ? domainDetails.toBuilder() : null;
        }

        public final void setDomainDetails(AwsApiCallActionDomainDetails.BuilderImpl domainDetails) {
            this.domainDetails = domainDetails != null ? domainDetails.build() : null;
        }

        @Override
        public final Builder domainDetails(AwsApiCallActionDomainDetails domainDetails) {
            this.domainDetails = domainDetails;
            return this;
        }

        public final Map<String, String> getAffectedResources() {
            if (affectedResources instanceof SdkAutoConstructMap) {
                return null;
            }
            return affectedResources;
        }

        public final void setAffectedResources(Map<String, String> affectedResources) {
            this.affectedResources = FieldMapCopier.copy(affectedResources);
        }

        @Override
        public final Builder affectedResources(Map<String, String> affectedResources) {
            this.affectedResources = FieldMapCopier.copy(affectedResources);
            return this;
        }

        public final String getFirstSeen() {
            return firstSeen;
        }

        public final void setFirstSeen(String firstSeen) {
            this.firstSeen = firstSeen;
        }

        @Override
        public final Builder firstSeen(String firstSeen) {
            this.firstSeen = firstSeen;
            return this;
        }

        public final String getLastSeen() {
            return lastSeen;
        }

        public final void setLastSeen(String lastSeen) {
            this.lastSeen = lastSeen;
        }

        @Override
        public final Builder lastSeen(String lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        @Override
        public AwsApiCallAction build() {
            return new AwsApiCallAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
