/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scheduled time period (UTC) during which Amazon MQ begins to apply pending updates or patches to the broker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.Builder, AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails> {
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DayOfWeek").getter(getter(AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails::dayOfWeek))
            .setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final SdkField<String> TIME_OF_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeOfDay").getter(getter(AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails::timeOfDay))
            .setter(setter(Builder::timeOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeOfDay").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails::timeZone))
            .setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_WEEK_FIELD,
            TIME_OF_DAY_FIELD, TIME_ZONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dayOfWeek;

    private final String timeOfDay;

    private final String timeZone;

    private AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails(BuilderImpl builder) {
        this.dayOfWeek = builder.dayOfWeek;
        this.timeOfDay = builder.timeOfDay;
        this.timeZone = builder.timeZone;
    }

    /**
     * <p>
     * The day of the week on which the maintenance window falls.
     * </p>
     * 
     * @return The day of the week on which the maintenance window falls.
     */
    public final String dayOfWeek() {
        return dayOfWeek;
    }

    /**
     * <p>
     * The time, in 24-hour format, on which the maintenance window falls.
     * </p>
     * 
     * @return The time, in 24-hour format, on which the maintenance window falls.
     */
    public final String timeOfDay() {
        return timeOfDay;
    }

    /**
     * <p>
     * The time zone in either the Country/City format or the UTC offset format. UTC is the default format.
     * </p>
     * 
     * @return The time zone in either the Country/City format or the UTC offset format. UTC is the default format.
     */
    public final String timeZone() {
        return timeZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeek());
        hashCode = 31 * hashCode + Objects.hashCode(timeOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails)) {
            return false;
        }
        AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails other = (AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails) obj;
        return Objects.equals(dayOfWeek(), other.dayOfWeek()) && Objects.equals(timeOfDay(), other.timeOfDay())
                && Objects.equals(timeZone(), other.timeZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails").add("DayOfWeek", dayOfWeek())
                .add("TimeOfDay", timeOfDay()).add("TimeZone", timeZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeek()));
        case "TimeOfDay":
            return Optional.ofNullable(clazz.cast(timeOfDay()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("TimeOfDay", TIME_OF_DAY_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails, T> g) {
        return obj -> g.apply((AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails> {
        /**
         * <p>
         * The day of the week on which the maintenance window falls.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week on which the maintenance window falls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * <p>
         * The time, in 24-hour format, on which the maintenance window falls.
         * </p>
         * 
         * @param timeOfDay
         *        The time, in 24-hour format, on which the maintenance window falls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOfDay(String timeOfDay);

        /**
         * <p>
         * The time zone in either the Country/City format or the UTC offset format. UTC is the default format.
         * </p>
         * 
         * @param timeZone
         *        The time zone in either the Country/City format or the UTC offset format. UTC is the default format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);
    }

    static final class BuilderImpl implements Builder {
        private String dayOfWeek;

        private String timeOfDay;

        private String timeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails model) {
            dayOfWeek(model.dayOfWeek);
            timeOfDay(model.timeOfDay);
            timeZone(model.timeZone);
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public final String getTimeOfDay() {
            return timeOfDay;
        }

        public final void setTimeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
        }

        @Override
        public final Builder timeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails build() {
            return new AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
