/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about logs to be activated for the specified broker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAmazonMqBrokerLogsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAmazonMqBrokerLogsDetails.Builder, AwsAmazonMqBrokerLogsDetails> {
    private static final SdkField<Boolean> AUDIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Audit")
            .getter(getter(AwsAmazonMqBrokerLogsDetails::audit)).setter(setter(Builder::audit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audit").build()).build();

    private static final SdkField<Boolean> GENERAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("General").getter(getter(AwsAmazonMqBrokerLogsDetails::general)).setter(setter(Builder::general))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("General").build()).build();

    private static final SdkField<String> AUDIT_LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditLogGroup").getter(getter(AwsAmazonMqBrokerLogsDetails::auditLogGroup))
            .setter(setter(Builder::auditLogGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogGroup").build()).build();

    private static final SdkField<String> GENERAL_LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneralLogGroup").getter(getter(AwsAmazonMqBrokerLogsDetails::generalLogGroup))
            .setter(setter(Builder::generalLogGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneralLogGroup").build()).build();

    private static final SdkField<AwsAmazonMqBrokerLogsPendingDetails> PENDING_FIELD = SdkField
            .<AwsAmazonMqBrokerLogsPendingDetails> builder(MarshallingType.SDK_POJO).memberName("Pending")
            .getter(getter(AwsAmazonMqBrokerLogsDetails::pending)).setter(setter(Builder::pending))
            .constructor(AwsAmazonMqBrokerLogsPendingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pending").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_FIELD, GENERAL_FIELD,
            AUDIT_LOG_GROUP_FIELD, GENERAL_LOG_GROUP_FIELD, PENDING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean audit;

    private final Boolean general;

    private final String auditLogGroup;

    private final String generalLogGroup;

    private final AwsAmazonMqBrokerLogsPendingDetails pending;

    private AwsAmazonMqBrokerLogsDetails(BuilderImpl builder) {
        this.audit = builder.audit;
        this.general = builder.general;
        this.auditLogGroup = builder.auditLogGroup;
        this.generalLogGroup = builder.generalLogGroup;
        this.pending = builder.pending;
    }

    /**
     * <p>
     * Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     * Doesn't apply to RabbitMQ brokers.
     * </p>
     * 
     * @return Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
     *         logged. Doesn't apply to RabbitMQ brokers.
     */
    public final Boolean audit() {
        return audit;
    }

    /**
     * <p>
     * Activates general logging.
     * </p>
     * 
     * @return Activates general logging.
     */
    public final Boolean general() {
        return general;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where audit logs are sent.
     * </p>
     * 
     * @return The location of the CloudWatch Logs log group where audit logs are sent.
     */
    public final String auditLogGroup() {
        return auditLogGroup;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where general logs are sent.
     * </p>
     * 
     * @return The location of the CloudWatch Logs log group where general logs are sent.
     */
    public final String generalLogGroup() {
        return generalLogGroup;
    }

    /**
     * <p>
     * The list of information about logs that are to be turned on for the specified broker.
     * </p>
     * 
     * @return The list of information about logs that are to be turned on for the specified broker.
     */
    public final AwsAmazonMqBrokerLogsPendingDetails pending() {
        return pending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audit());
        hashCode = 31 * hashCode + Objects.hashCode(general());
        hashCode = 31 * hashCode + Objects.hashCode(auditLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(generalLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAmazonMqBrokerLogsDetails)) {
            return false;
        }
        AwsAmazonMqBrokerLogsDetails other = (AwsAmazonMqBrokerLogsDetails) obj;
        return Objects.equals(audit(), other.audit()) && Objects.equals(general(), other.general())
                && Objects.equals(auditLogGroup(), other.auditLogGroup())
                && Objects.equals(generalLogGroup(), other.generalLogGroup()) && Objects.equals(pending(), other.pending());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAmazonMqBrokerLogsDetails").add("Audit", audit()).add("General", general())
                .add("AuditLogGroup", auditLogGroup()).add("GeneralLogGroup", generalLogGroup()).add("Pending", pending())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audit":
            return Optional.ofNullable(clazz.cast(audit()));
        case "General":
            return Optional.ofNullable(clazz.cast(general()));
        case "AuditLogGroup":
            return Optional.ofNullable(clazz.cast(auditLogGroup()));
        case "GeneralLogGroup":
            return Optional.ofNullable(clazz.cast(generalLogGroup()));
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Audit", AUDIT_FIELD);
        map.put("General", GENERAL_FIELD);
        map.put("AuditLogGroup", AUDIT_LOG_GROUP_FIELD);
        map.put("GeneralLogGroup", GENERAL_LOG_GROUP_FIELD);
        map.put("Pending", PENDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAmazonMqBrokerLogsDetails, T> g) {
        return obj -> g.apply((AwsAmazonMqBrokerLogsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAmazonMqBrokerLogsDetails> {
        /**
         * <p>
         * Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
         * Doesn't apply to RabbitMQ brokers.
         * </p>
         * 
         * @param audit
         *        Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
         *        logged. Doesn't apply to RabbitMQ brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audit(Boolean audit);

        /**
         * <p>
         * Activates general logging.
         * </p>
         * 
         * @param general
         *        Activates general logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder general(Boolean general);

        /**
         * <p>
         * The location of the CloudWatch Logs log group where audit logs are sent.
         * </p>
         * 
         * @param auditLogGroup
         *        The location of the CloudWatch Logs log group where audit logs are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogGroup(String auditLogGroup);

        /**
         * <p>
         * The location of the CloudWatch Logs log group where general logs are sent.
         * </p>
         * 
         * @param generalLogGroup
         *        The location of the CloudWatch Logs log group where general logs are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generalLogGroup(String generalLogGroup);

        /**
         * <p>
         * The list of information about logs that are to be turned on for the specified broker.
         * </p>
         * 
         * @param pending
         *        The list of information about logs that are to be turned on for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(AwsAmazonMqBrokerLogsPendingDetails pending);

        /**
         * <p>
         * The list of information about logs that are to be turned on for the specified broker.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAmazonMqBrokerLogsPendingDetails.Builder} avoiding the need to create one manually via
         * {@link AwsAmazonMqBrokerLogsPendingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAmazonMqBrokerLogsPendingDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #pending(AwsAmazonMqBrokerLogsPendingDetails)}.
         * 
         * @param pending
         *        a consumer that will call methods on {@link AwsAmazonMqBrokerLogsPendingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pending(AwsAmazonMqBrokerLogsPendingDetails)
         */
        default Builder pending(Consumer<AwsAmazonMqBrokerLogsPendingDetails.Builder> pending) {
            return pending(AwsAmazonMqBrokerLogsPendingDetails.builder().applyMutation(pending).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean audit;

        private Boolean general;

        private String auditLogGroup;

        private String generalLogGroup;

        private AwsAmazonMqBrokerLogsPendingDetails pending;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAmazonMqBrokerLogsDetails model) {
            audit(model.audit);
            general(model.general);
            auditLogGroup(model.auditLogGroup);
            generalLogGroup(model.generalLogGroup);
            pending(model.pending);
        }

        public final Boolean getAudit() {
            return audit;
        }

        public final void setAudit(Boolean audit) {
            this.audit = audit;
        }

        @Override
        public final Builder audit(Boolean audit) {
            this.audit = audit;
            return this;
        }

        public final Boolean getGeneral() {
            return general;
        }

        public final void setGeneral(Boolean general) {
            this.general = general;
        }

        @Override
        public final Builder general(Boolean general) {
            this.general = general;
            return this;
        }

        public final String getAuditLogGroup() {
            return auditLogGroup;
        }

        public final void setAuditLogGroup(String auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
        }

        @Override
        public final Builder auditLogGroup(String auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
            return this;
        }

        public final String getGeneralLogGroup() {
            return generalLogGroup;
        }

        public final void setGeneralLogGroup(String generalLogGroup) {
            this.generalLogGroup = generalLogGroup;
        }

        @Override
        public final Builder generalLogGroup(String generalLogGroup) {
            this.generalLogGroup = generalLogGroup;
            return this;
        }

        public final AwsAmazonMqBrokerLogsPendingDetails.Builder getPending() {
            return pending != null ? pending.toBuilder() : null;
        }

        public final void setPending(AwsAmazonMqBrokerLogsPendingDetails.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        @Override
        public final Builder pending(AwsAmazonMqBrokerLogsPendingDetails pending) {
            this.pending = pending;
            return this;
        }

        @Override
        public AwsAmazonMqBrokerLogsDetails build() {
            return new AwsAmazonMqBrokerLogsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
