/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of the Lightweight Directory Access Protocol (LDAP) server used to authenticate and authorize
 * connections to the broker. This is an optional failover server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAmazonMqBrokerLdapServerMetadataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAmazonMqBrokerLdapServerMetadataDetails.Builder, AwsAmazonMqBrokerLdapServerMetadataDetails> {
    private static final SdkField<List<String>> HOSTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Hosts")
            .getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::hosts))
            .setter(setter(Builder::hosts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hosts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleBase").getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::roleBase))
            .setter(setter(Builder::roleBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleBase").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::roleName))
            .setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<String> ROLE_SEARCH_MATCHING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleSearchMatching").getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::roleSearchMatching))
            .setter(setter(Builder::roleSearchMatching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleSearchMatching").build())
            .build();

    private static final SdkField<Boolean> ROLE_SEARCH_SUBTREE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RoleSearchSubtree").getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::roleSearchSubtree))
            .setter(setter(Builder::roleSearchSubtree))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleSearchSubtree").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccountUsername")
            .getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::serviceAccountUsername))
            .setter(setter(Builder::serviceAccountUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccountUsername").build())
            .build();

    private static final SdkField<String> USER_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserBase").getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::userBase))
            .setter(setter(Builder::userBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBase").build()).build();

    private static final SdkField<String> USER_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRoleName").getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::userRoleName))
            .setter(setter(Builder::userRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRoleName").build()).build();

    private static final SdkField<String> USER_SEARCH_MATCHING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserSearchMatching").getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::userSearchMatching))
            .setter(setter(Builder::userSearchMatching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSearchMatching").build())
            .build();

    private static final SdkField<Boolean> USER_SEARCH_SUBTREE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UserSearchSubtree").getter(getter(AwsAmazonMqBrokerLdapServerMetadataDetails::userSearchSubtree))
            .setter(setter(Builder::userSearchSubtree))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSearchSubtree").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTS_FIELD, ROLE_BASE_FIELD,
            ROLE_NAME_FIELD, ROLE_SEARCH_MATCHING_FIELD, ROLE_SEARCH_SUBTREE_FIELD, SERVICE_ACCOUNT_USERNAME_FIELD,
            USER_BASE_FIELD, USER_ROLE_NAME_FIELD, USER_SEARCH_MATCHING_FIELD, USER_SEARCH_SUBTREE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> hosts;

    private final String roleBase;

    private final String roleName;

    private final String roleSearchMatching;

    private final Boolean roleSearchSubtree;

    private final String serviceAccountUsername;

    private final String userBase;

    private final String userRoleName;

    private final String userSearchMatching;

    private final Boolean userSearchSubtree;

    private AwsAmazonMqBrokerLdapServerMetadataDetails(BuilderImpl builder) {
        this.hosts = builder.hosts;
        this.roleBase = builder.roleBase;
        this.roleName = builder.roleName;
        this.roleSearchMatching = builder.roleSearchMatching;
        this.roleSearchSubtree = builder.roleSearchSubtree;
        this.serviceAccountUsername = builder.serviceAccountUsername;
        this.userBase = builder.userBase;
        this.userRoleName = builder.userRoleName;
        this.userSearchMatching = builder.userSearchMatching;
        this.userSearchSubtree = builder.userSearchSubtree;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hosts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasHosts() {
        return hosts != null && !(hosts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft Active
     * Directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHosts} method.
     * </p>
     * 
     * @return Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft
     *         Active Directory.
     */
    public final List<String> hosts() {
        return hosts;
    }

    /**
     * <p>
     * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups.
     * </p>
     * 
     * @return The distinguished name of the node in the directory information tree (DIT) to search for roles or groups.
     */
    public final String roleBase() {
        return roleBase;
    }

    /**
     * <p>
     * The group name attribute in a role entry whose value is the name of that role.
     * </p>
     * 
     * @return The group name attribute in a role entry whose value is the name of that role.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The LDAP search filter used to find roles within the <code>roleBase</code>.
     * </p>
     * 
     * @return The LDAP search filter used to find roles within the <code>roleBase</code>.
     */
    public final String roleSearchMatching() {
        return roleSearchMatching;
    }

    /**
     * <p>
     * The directory search scope for the role. If set to <code>true</code>, the scope is to search the entire subtree.
     * </p>
     * 
     * @return The directory search scope for the role. If set to <code>true</code>, the scope is to search the entire
     *         subtree.
     */
    public final Boolean roleSearchSubtree() {
        return roleSearchSubtree;
    }

    /**
     * <p>
     * A username for the service account, which is an account in your LDAP server that has access to initiate a
     * connection.
     * </p>
     * 
     * @return A username for the service account, which is an account in your LDAP server that has access to initiate a
     *         connection.
     */
    public final String serviceAccountUsername() {
        return serviceAccountUsername;
    }

    /**
     * <p>
     * Selects a particular subtree of the directory information tree (DIT) to search for user entries.
     * </p>
     * 
     * @return Selects a particular subtree of the directory information tree (DIT) to search for user entries.
     */
    public final String userBase() {
        return userBase;
    }

    /**
     * <p>
     * The name of the LDAP attribute in the user's directory entry for the user's group membership.
     * </p>
     * 
     * @return The name of the LDAP attribute in the user's directory entry for the user's group membership.
     */
    public final String userRoleName() {
        return userRoleName;
    }

    /**
     * <p>
     * The LDAP search filter used to find users within the <code>userBase</code>.
     * </p>
     * 
     * @return The LDAP search filter used to find users within the <code>userBase</code>.
     */
    public final String userSearchMatching() {
        return userSearchMatching;
    }

    /**
     * <p>
     * The directory search scope for the user. If set to true, the scope is to search the entire subtree.
     * </p>
     * 
     * @return The directory search scope for the user. If set to true, the scope is to search the entire subtree.
     */
    public final Boolean userSearchSubtree() {
        return userSearchSubtree;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHosts() ? hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleBase());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(roleSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(roleSearchSubtree());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountUsername());
        hashCode = 31 * hashCode + Objects.hashCode(userBase());
        hashCode = 31 * hashCode + Objects.hashCode(userRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(userSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(userSearchSubtree());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAmazonMqBrokerLdapServerMetadataDetails)) {
            return false;
        }
        AwsAmazonMqBrokerLdapServerMetadataDetails other = (AwsAmazonMqBrokerLdapServerMetadataDetails) obj;
        return hasHosts() == other.hasHosts() && Objects.equals(hosts(), other.hosts())
                && Objects.equals(roleBase(), other.roleBase()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(roleSearchMatching(), other.roleSearchMatching())
                && Objects.equals(roleSearchSubtree(), other.roleSearchSubtree())
                && Objects.equals(serviceAccountUsername(), other.serviceAccountUsername())
                && Objects.equals(userBase(), other.userBase()) && Objects.equals(userRoleName(), other.userRoleName())
                && Objects.equals(userSearchMatching(), other.userSearchMatching())
                && Objects.equals(userSearchSubtree(), other.userSearchSubtree());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAmazonMqBrokerLdapServerMetadataDetails").add("Hosts", hasHosts() ? hosts() : null)
                .add("RoleBase", roleBase()).add("RoleName", roleName()).add("RoleSearchMatching", roleSearchMatching())
                .add("RoleSearchSubtree", roleSearchSubtree()).add("ServiceAccountUsername", serviceAccountUsername())
                .add("UserBase", userBase()).add("UserRoleName", userRoleName()).add("UserSearchMatching", userSearchMatching())
                .add("UserSearchSubtree", userSearchSubtree()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hosts":
            return Optional.ofNullable(clazz.cast(hosts()));
        case "RoleBase":
            return Optional.ofNullable(clazz.cast(roleBase()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "RoleSearchMatching":
            return Optional.ofNullable(clazz.cast(roleSearchMatching()));
        case "RoleSearchSubtree":
            return Optional.ofNullable(clazz.cast(roleSearchSubtree()));
        case "ServiceAccountUsername":
            return Optional.ofNullable(clazz.cast(serviceAccountUsername()));
        case "UserBase":
            return Optional.ofNullable(clazz.cast(userBase()));
        case "UserRoleName":
            return Optional.ofNullable(clazz.cast(userRoleName()));
        case "UserSearchMatching":
            return Optional.ofNullable(clazz.cast(userSearchMatching()));
        case "UserSearchSubtree":
            return Optional.ofNullable(clazz.cast(userSearchSubtree()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Hosts", HOSTS_FIELD);
        map.put("RoleBase", ROLE_BASE_FIELD);
        map.put("RoleName", ROLE_NAME_FIELD);
        map.put("RoleSearchMatching", ROLE_SEARCH_MATCHING_FIELD);
        map.put("RoleSearchSubtree", ROLE_SEARCH_SUBTREE_FIELD);
        map.put("ServiceAccountUsername", SERVICE_ACCOUNT_USERNAME_FIELD);
        map.put("UserBase", USER_BASE_FIELD);
        map.put("UserRoleName", USER_ROLE_NAME_FIELD);
        map.put("UserSearchMatching", USER_SEARCH_MATCHING_FIELD);
        map.put("UserSearchSubtree", USER_SEARCH_SUBTREE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAmazonMqBrokerLdapServerMetadataDetails, T> g) {
        return obj -> g.apply((AwsAmazonMqBrokerLdapServerMetadataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAmazonMqBrokerLdapServerMetadataDetails> {
        /**
         * <p>
         * Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft Active
         * Directory.
         * </p>
         * 
         * @param hosts
         *        Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft
         *        Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(Collection<String> hosts);

        /**
         * <p>
         * Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft Active
         * Directory.
         * </p>
         * 
         * @param hosts
         *        Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft
         *        Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(String... hosts);

        /**
         * <p>
         * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups.
         * </p>
         * 
         * @param roleBase
         *        The distinguished name of the node in the directory information tree (DIT) to search for roles or
         *        groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleBase(String roleBase);

        /**
         * <p>
         * The group name attribute in a role entry whose value is the name of that role.
         * </p>
         * 
         * @param roleName
         *        The group name attribute in a role entry whose value is the name of that role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The LDAP search filter used to find roles within the <code>roleBase</code>.
         * </p>
         * 
         * @param roleSearchMatching
         *        The LDAP search filter used to find roles within the <code>roleBase</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleSearchMatching(String roleSearchMatching);

        /**
         * <p>
         * The directory search scope for the role. If set to <code>true</code>, the scope is to search the entire
         * subtree.
         * </p>
         * 
         * @param roleSearchSubtree
         *        The directory search scope for the role. If set to <code>true</code>, the scope is to search the
         *        entire subtree.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleSearchSubtree(Boolean roleSearchSubtree);

        /**
         * <p>
         * A username for the service account, which is an account in your LDAP server that has access to initiate a
         * connection.
         * </p>
         * 
         * @param serviceAccountUsername
         *        A username for the service account, which is an account in your LDAP server that has access to
         *        initiate a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountUsername(String serviceAccountUsername);

        /**
         * <p>
         * Selects a particular subtree of the directory information tree (DIT) to search for user entries.
         * </p>
         * 
         * @param userBase
         *        Selects a particular subtree of the directory information tree (DIT) to search for user entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBase(String userBase);

        /**
         * <p>
         * The name of the LDAP attribute in the user's directory entry for the user's group membership.
         * </p>
         * 
         * @param userRoleName
         *        The name of the LDAP attribute in the user's directory entry for the user's group membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRoleName(String userRoleName);

        /**
         * <p>
         * The LDAP search filter used to find users within the <code>userBase</code>.
         * </p>
         * 
         * @param userSearchMatching
         *        The LDAP search filter used to find users within the <code>userBase</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSearchMatching(String userSearchMatching);

        /**
         * <p>
         * The directory search scope for the user. If set to true, the scope is to search the entire subtree.
         * </p>
         * 
         * @param userSearchSubtree
         *        The directory search scope for the user. If set to true, the scope is to search the entire subtree.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSearchSubtree(Boolean userSearchSubtree);
    }

    static final class BuilderImpl implements Builder {
        private List<String> hosts = DefaultSdkAutoConstructList.getInstance();

        private String roleBase;

        private String roleName;

        private String roleSearchMatching;

        private Boolean roleSearchSubtree;

        private String serviceAccountUsername;

        private String userBase;

        private String userRoleName;

        private String userSearchMatching;

        private Boolean userSearchSubtree;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAmazonMqBrokerLdapServerMetadataDetails model) {
            hosts(model.hosts);
            roleBase(model.roleBase);
            roleName(model.roleName);
            roleSearchMatching(model.roleSearchMatching);
            roleSearchSubtree(model.roleSearchSubtree);
            serviceAccountUsername(model.serviceAccountUsername);
            userBase(model.userBase);
            userRoleName(model.userRoleName);
            userSearchMatching(model.userSearchMatching);
            userSearchSubtree(model.userSearchSubtree);
        }

        public final Collection<String> getHosts() {
            if (hosts instanceof SdkAutoConstructList) {
                return null;
            }
            return hosts;
        }

        public final void setHosts(Collection<String> hosts) {
            this.hosts = StringListCopier.copy(hosts);
        }

        @Override
        public final Builder hosts(Collection<String> hosts) {
            this.hosts = StringListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(String... hosts) {
            hosts(Arrays.asList(hosts));
            return this;
        }

        public final String getRoleBase() {
            return roleBase;
        }

        public final void setRoleBase(String roleBase) {
            this.roleBase = roleBase;
        }

        @Override
        public final Builder roleBase(String roleBase) {
            this.roleBase = roleBase;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getRoleSearchMatching() {
            return roleSearchMatching;
        }

        public final void setRoleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
        }

        @Override
        public final Builder roleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
            return this;
        }

        public final Boolean getRoleSearchSubtree() {
            return roleSearchSubtree;
        }

        public final void setRoleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
        }

        @Override
        public final Builder roleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
            return this;
        }

        public final String getServiceAccountUsername() {
            return serviceAccountUsername;
        }

        public final void setServiceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
        }

        @Override
        public final Builder serviceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
            return this;
        }

        public final String getUserBase() {
            return userBase;
        }

        public final void setUserBase(String userBase) {
            this.userBase = userBase;
        }

        @Override
        public final Builder userBase(String userBase) {
            this.userBase = userBase;
            return this;
        }

        public final String getUserRoleName() {
            return userRoleName;
        }

        public final void setUserRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
        }

        @Override
        public final Builder userRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
            return this;
        }

        public final String getUserSearchMatching() {
            return userSearchMatching;
        }

        public final void setUserSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
        }

        @Override
        public final Builder userSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
            return this;
        }

        public final Boolean getUserSearchSubtree() {
            return userSearchSubtree;
        }

        public final void setUserSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
        }

        @Override
        public final Builder userSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
            return this;
        }

        @Override
        public AwsAmazonMqBrokerLdapServerMetadataDetails build() {
            return new AwsAmazonMqBrokerLdapServerMetadataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
