/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to configure automated responses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationRulesActionV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationRulesActionV2.Builder, AutomationRulesActionV2> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AutomationRulesActionV2::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<AutomationRulesFindingFieldsUpdateV2> FINDING_FIELDS_UPDATE_FIELD = SdkField
            .<AutomationRulesFindingFieldsUpdateV2> builder(MarshallingType.SDK_POJO).memberName("FindingFieldsUpdate")
            .getter(getter(AutomationRulesActionV2::findingFieldsUpdate)).setter(setter(Builder::findingFieldsUpdate))
            .constructor(AutomationRulesFindingFieldsUpdateV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingFieldsUpdate").build())
            .build();

    private static final SdkField<ExternalIntegrationConfiguration> EXTERNAL_INTEGRATION_CONFIGURATION_FIELD = SdkField
            .<ExternalIntegrationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExternalIntegrationConfiguration")
            .getter(getter(AutomationRulesActionV2::externalIntegrationConfiguration))
            .setter(setter(Builder::externalIntegrationConfiguration))
            .constructor(ExternalIntegrationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalIntegrationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            FINDING_FIELDS_UPDATE_FIELD, EXTERNAL_INTEGRATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate;

    private final ExternalIntegrationConfiguration externalIntegrationConfiguration;

    private AutomationRulesActionV2(BuilderImpl builder) {
        this.type = builder.type;
        this.findingFieldsUpdate = builder.findingFieldsUpdate;
        this.externalIntegrationConfiguration = builder.externalIntegrationConfiguration;
    }

    /**
     * <p>
     * The category of action to be executed by the automation rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AutomationRulesActionTypeV2#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The category of action to be executed by the automation rule.
     * @see AutomationRulesActionTypeV2
     */
    public final AutomationRulesActionTypeV2 type() {
        return AutomationRulesActionTypeV2.fromValue(type);
    }

    /**
     * <p>
     * The category of action to be executed by the automation rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AutomationRulesActionTypeV2#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The category of action to be executed by the automation rule.
     * @see AutomationRulesActionTypeV2
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The changes to be applied to fields in a security finding when an automation rule is triggered.
     * </p>
     * 
     * @return The changes to be applied to fields in a security finding when an automation rule is triggered.
     */
    public final AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate() {
        return findingFieldsUpdate;
    }

    /**
     * <p>
     * The settings for integrating automation rule actions with external systems or service.
     * </p>
     * 
     * @return The settings for integrating automation rule actions with external systems or service.
     */
    public final ExternalIntegrationConfiguration externalIntegrationConfiguration() {
        return externalIntegrationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(findingFieldsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(externalIntegrationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesActionV2)) {
            return false;
        }
        AutomationRulesActionV2 other = (AutomationRulesActionV2) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(findingFieldsUpdate(), other.findingFieldsUpdate())
                && Objects.equals(externalIntegrationConfiguration(), other.externalIntegrationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationRulesActionV2").add("Type", typeAsString())
                .add("FindingFieldsUpdate", findingFieldsUpdate())
                .add("ExternalIntegrationConfiguration", externalIntegrationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "FindingFieldsUpdate":
            return Optional.ofNullable(clazz.cast(findingFieldsUpdate()));
        case "ExternalIntegrationConfiguration":
            return Optional.ofNullable(clazz.cast(externalIntegrationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("FindingFieldsUpdate", FINDING_FIELDS_UPDATE_FIELD);
        map.put("ExternalIntegrationConfiguration", EXTERNAL_INTEGRATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesActionV2, T> g) {
        return obj -> g.apply((AutomationRulesActionV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationRulesActionV2> {
        /**
         * <p>
         * The category of action to be executed by the automation rule.
         * </p>
         * 
         * @param type
         *        The category of action to be executed by the automation rule.
         * @see AutomationRulesActionTypeV2
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationRulesActionTypeV2
         */
        Builder type(String type);

        /**
         * <p>
         * The category of action to be executed by the automation rule.
         * </p>
         * 
         * @param type
         *        The category of action to be executed by the automation rule.
         * @see AutomationRulesActionTypeV2
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationRulesActionTypeV2
         */
        Builder type(AutomationRulesActionTypeV2 type);

        /**
         * <p>
         * The changes to be applied to fields in a security finding when an automation rule is triggered.
         * </p>
         * 
         * @param findingFieldsUpdate
         *        The changes to be applied to fields in a security finding when an automation rule is triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate);

        /**
         * <p>
         * The changes to be applied to fields in a security finding when an automation rule is triggered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomationRulesFindingFieldsUpdateV2.Builder} avoiding the need to create one manually via
         * {@link AutomationRulesFindingFieldsUpdateV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomationRulesFindingFieldsUpdateV2.Builder#build()} is called
         * immediately and its result is passed to {@link #findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2)}.
         * 
         * @param findingFieldsUpdate
         *        a consumer that will call methods on {@link AutomationRulesFindingFieldsUpdateV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2)
         */
        default Builder findingFieldsUpdate(Consumer<AutomationRulesFindingFieldsUpdateV2.Builder> findingFieldsUpdate) {
            return findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2.builder().applyMutation(findingFieldsUpdate).build());
        }

        /**
         * <p>
         * The settings for integrating automation rule actions with external systems or service.
         * </p>
         * 
         * @param externalIntegrationConfiguration
         *        The settings for integrating automation rule actions with external systems or service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalIntegrationConfiguration(ExternalIntegrationConfiguration externalIntegrationConfiguration);

        /**
         * <p>
         * The settings for integrating automation rule actions with external systems or service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalIntegrationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalIntegrationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalIntegrationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #externalIntegrationConfiguration(ExternalIntegrationConfiguration)}.
         * 
         * @param externalIntegrationConfiguration
         *        a consumer that will call methods on {@link ExternalIntegrationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalIntegrationConfiguration(ExternalIntegrationConfiguration)
         */
        default Builder externalIntegrationConfiguration(
                Consumer<ExternalIntegrationConfiguration.Builder> externalIntegrationConfiguration) {
            return externalIntegrationConfiguration(ExternalIntegrationConfiguration.builder()
                    .applyMutation(externalIntegrationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate;

        private ExternalIntegrationConfiguration externalIntegrationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesActionV2 model) {
            type(model.type);
            findingFieldsUpdate(model.findingFieldsUpdate);
            externalIntegrationConfiguration(model.externalIntegrationConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AutomationRulesActionTypeV2 type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AutomationRulesFindingFieldsUpdateV2.Builder getFindingFieldsUpdate() {
            return findingFieldsUpdate != null ? findingFieldsUpdate.toBuilder() : null;
        }

        public final void setFindingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2.BuilderImpl findingFieldsUpdate) {
            this.findingFieldsUpdate = findingFieldsUpdate != null ? findingFieldsUpdate.build() : null;
        }

        @Override
        public final Builder findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2 findingFieldsUpdate) {
            this.findingFieldsUpdate = findingFieldsUpdate;
            return this;
        }

        public final ExternalIntegrationConfiguration.Builder getExternalIntegrationConfiguration() {
            return externalIntegrationConfiguration != null ? externalIntegrationConfiguration.toBuilder() : null;
        }

        public final void setExternalIntegrationConfiguration(
                ExternalIntegrationConfiguration.BuilderImpl externalIntegrationConfiguration) {
            this.externalIntegrationConfiguration = externalIntegrationConfiguration != null ? externalIntegrationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder externalIntegrationConfiguration(ExternalIntegrationConfiguration externalIntegrationConfiguration) {
            this.externalIntegrationConfiguration = externalIntegrationConfiguration;
            return this;
        }

        @Override
        public AutomationRulesActionV2 build() {
            return new AutomationRulesActionV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
