/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the threat actor identified in an Amazon GuardDuty Extended Threat Detection attack sequence.
 * GuardDuty generates an attack sequence finding when multiple events align to a potentially suspicious activity. To
 * receive GuardDuty attack sequence findings in Security Hub, you must have GuardDuty enabled. For more information,
 * see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-extended-threat-detection.html">GuardDuty
 * Extended Threat Detection </a> in the <i>Amazon GuardDuty User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Actor implements SdkPojo, Serializable, ToCopyableBuilder<Actor.Builder, Actor> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Actor::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<ActorUser> USER_FIELD = SdkField.<ActorUser> builder(MarshallingType.SDK_POJO)
            .memberName("User").getter(getter(Actor::user)).setter(setter(Builder::user)).constructor(ActorUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<ActorSession> SESSION_FIELD = SdkField.<ActorSession> builder(MarshallingType.SDK_POJO)
            .memberName("Session").getter(getter(Actor::session)).setter(setter(Builder::session))
            .constructor(ActorSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, USER_FIELD,
            SESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final ActorUser user;

    private final ActorSession session;

    private Actor(BuilderImpl builder) {
        this.id = builder.id;
        this.user = builder.user;
        this.session = builder.session;
    }

    /**
     * <p>
     * The ID of the threat actor.
     * </p>
     * 
     * @return The ID of the threat actor.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Contains information about the user credentials used by the threat actor.
     * </p>
     * 
     * @return Contains information about the user credentials used by the threat actor.
     */
    public final ActorUser user() {
        return user;
    }

    /**
     * <p>
     * Contains information about the user session where the activity initiated.
     * </p>
     * 
     * @return Contains information about the user session where the activity initiated.
     */
    public final ActorSession session() {
        return session;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Actor)) {
            return false;
        }
        Actor other = (Actor) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(user(), other.user())
                && Objects.equals(session(), other.session());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Actor").add("Id", id()).add("User", user()).add("Session", session()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("User", USER_FIELD);
        map.put("Session", SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Actor, T> g) {
        return obj -> g.apply((Actor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Actor> {
        /**
         * <p>
         * The ID of the threat actor.
         * </p>
         * 
         * @param id
         *        The ID of the threat actor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Contains information about the user credentials used by the threat actor.
         * </p>
         * 
         * @param user
         *        Contains information about the user credentials used by the threat actor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(ActorUser user);

        /**
         * <p>
         * Contains information about the user credentials used by the threat actor.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActorUser.Builder} avoiding the need to
         * create one manually via {@link ActorUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActorUser.Builder#build()} is called immediately and its result
         * is passed to {@link #user(ActorUser)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link ActorUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(ActorUser)
         */
        default Builder user(Consumer<ActorUser.Builder> user) {
            return user(ActorUser.builder().applyMutation(user).build());
        }

        /**
         * <p>
         * Contains information about the user session where the activity initiated.
         * </p>
         * 
         * @param session
         *        Contains information about the user session where the activity initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(ActorSession session);

        /**
         * <p>
         * Contains information about the user session where the activity initiated.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActorSession.Builder} avoiding the need
         * to create one manually via {@link ActorSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActorSession.Builder#build()} is called immediately and its
         * result is passed to {@link #session(ActorSession)}.
         * 
         * @param session
         *        a consumer that will call methods on {@link ActorSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #session(ActorSession)
         */
        default Builder session(Consumer<ActorSession.Builder> session) {
            return session(ActorSession.builder().applyMutation(session).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private ActorUser user;

        private ActorSession session;

        private BuilderImpl() {
        }

        private BuilderImpl(Actor model) {
            id(model.id);
            user(model.user);
            session(model.session);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ActorUser.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(ActorUser.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(ActorUser user) {
            this.user = user;
            return this;
        }

        public final ActorSession.Builder getSession() {
            return session != null ? session.toBuilder() : null;
        }

        public final void setSession(ActorSession.BuilderImpl session) {
            this.session = session != null ? session.build() : null;
        }

        @Override
        public final Builder session(ActorSession session) {
            this.session = session;
            return this;
        }

        @Override
        public Actor build() {
            return new Actor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
