/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptAdministratorInvitationRequest extends SecurityHubRequest implements
        ToCopyableBuilder<AcceptAdministratorInvitationRequest.Builder, AcceptAdministratorInvitationRequest> {
    private static final SdkField<String> ADMINISTRATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdministratorId").getter(getter(AcceptAdministratorInvitationRequest::administratorId))
            .setter(setter(Builder::administratorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministratorId").build()).build();

    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvitationId").getter(getter(AcceptAdministratorInvitationRequest::invitationId))
            .setter(setter(Builder::invitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMINISTRATOR_ID_FIELD,
            INVITATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String administratorId;

    private final String invitationId;

    private AcceptAdministratorInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.administratorId = builder.administratorId;
        this.invitationId = builder.invitationId;
    }

    /**
     * <p>
     * The account ID of the Security Hub administrator account that sent the invitation.
     * </p>
     * 
     * @return The account ID of the Security Hub administrator account that sent the invitation.
     */
    public final String administratorId() {
        return administratorId;
    }

    /**
     * <p>
     * The identifier of the invitation sent from the Security Hub administrator account.
     * </p>
     * 
     * @return The identifier of the invitation sent from the Security Hub administrator account.
     */
    public final String invitationId() {
        return invitationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(administratorId());
        hashCode = 31 * hashCode + Objects.hashCode(invitationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptAdministratorInvitationRequest)) {
            return false;
        }
        AcceptAdministratorInvitationRequest other = (AcceptAdministratorInvitationRequest) obj;
        return Objects.equals(administratorId(), other.administratorId()) && Objects.equals(invitationId(), other.invitationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptAdministratorInvitationRequest").add("AdministratorId", administratorId())
                .add("InvitationId", invitationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdministratorId":
            return Optional.ofNullable(clazz.cast(administratorId()));
        case "InvitationId":
            return Optional.ofNullable(clazz.cast(invitationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdministratorId", ADMINISTRATOR_ID_FIELD);
        map.put("InvitationId", INVITATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptAdministratorInvitationRequest, T> g) {
        return obj -> g.apply((AcceptAdministratorInvitationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptAdministratorInvitationRequest> {
        /**
         * <p>
         * The account ID of the Security Hub administrator account that sent the invitation.
         * </p>
         * 
         * @param administratorId
         *        The account ID of the Security Hub administrator account that sent the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administratorId(String administratorId);

        /**
         * <p>
         * The identifier of the invitation sent from the Security Hub administrator account.
         * </p>
         * 
         * @param invitationId
         *        The identifier of the invitation sent from the Security Hub administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationId(String invitationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String administratorId;

        private String invitationId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptAdministratorInvitationRequest model) {
            super(model);
            administratorId(model.administratorId);
            invitationId(model.invitationId);
        }

        public final String getAdministratorId() {
            return administratorId;
        }

        public final void setAdministratorId(String administratorId) {
            this.administratorId = administratorId;
        }

        @Override
        public final Builder administratorId(String administratorId) {
            this.administratorId = administratorId;
            return this;
        }

        public final String getInvitationId() {
            return invitationId;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptAdministratorInvitationRequest build() {
            return new AcceptAdministratorInvitationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
