/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Response;
import software.amazon.awssdk.services.securityhub.model.ResourcesTrendsMetricsResult;

public class GetResourcesTrendsV2Publisher
implements SdkPublisher<GetResourcesTrendsV2Response> {
    private final SecurityHubAsyncClient client;
    private final GetResourcesTrendsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourcesTrendsV2Publisher(SecurityHubAsyncClient client, GetResourcesTrendsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourcesTrendsV2Publisher(SecurityHubAsyncClient client, GetResourcesTrendsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourcesTrendsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourcesTrendsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourcesTrendsMetricsResult> trendsMetrics() {
        Function<GetResourcesTrendsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.trendsMetrics() != null) {
                return response.trendsMetrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourcesTrendsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetResourcesTrendsV2ResponseFetcher
    implements AsyncPageFetcher<GetResourcesTrendsV2Response> {
        private GetResourcesTrendsV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcesTrendsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourcesTrendsV2Response> nextPage(GetResourcesTrendsV2Response previousPage) {
            if (previousPage == null) {
                return GetResourcesTrendsV2Publisher.this.client.getResourcesTrendsV2(GetResourcesTrendsV2Publisher.this.firstRequest);
            }
            return GetResourcesTrendsV2Publisher.this.client.getResourcesTrendsV2((GetResourcesTrendsV2Request)((Object)GetResourcesTrendsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

