/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ResourceCategory;
import software.amazon.awssdk.services.securityhub.model.ResourceFindingsSummary;
import software.amazon.awssdk.services.securityhub.model.ResourceFindingsSummaryListCopier;
import software.amazon.awssdk.services.securityhub.model.ResourceTag;
import software.amazon.awssdk.services.securityhub.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceResult> {
    private static final SdkField<String> RESOURCE_GUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGuid").getter(ResourceResult.getter(ResourceResult::resourceGuid)).setter(ResourceResult.setter(Builder::resourceGuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGuid").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResourceResult.getter(ResourceResult::resourceId)).setter(ResourceResult.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ResourceResult.getter(ResourceResult::accountId)).setter(ResourceResult.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ResourceResult.getter(ResourceResult::region)).setter(ResourceResult.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> RESOURCE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCategory").getter(ResourceResult.getter(ResourceResult::resourceCategoryAsString)).setter(ResourceResult.setter(Builder::resourceCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCategory").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceResult.getter(ResourceResult::resourceType)).setter(ResourceResult.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(ResourceResult.getter(ResourceResult::resourceName)).setter(ResourceResult.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> RESOURCE_CREATION_TIME_DT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCreationTimeDt").getter(ResourceResult.getter(ResourceResult::resourceCreationTimeDt)).setter(ResourceResult.setter(Builder::resourceCreationTimeDt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationTimeDt").build()}).build();
    private static final SdkField<String> RESOURCE_DETAIL_CAPTURE_TIME_DT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceDetailCaptureTimeDt").getter(ResourceResult.getter(ResourceResult::resourceDetailCaptureTimeDt)).setter(ResourceResult.setter(Builder::resourceDetailCaptureTimeDt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetailCaptureTimeDt").build()}).build();
    private static final SdkField<List<ResourceFindingsSummary>> FINDINGS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FindingsSummary").getter(ResourceResult.getter(ResourceResult::findingsSummary)).setter(ResourceResult.setter(Builder::findingsSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingsSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceFindingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(ResourceResult.getter(ResourceResult::resourceTags)).setter(ResourceResult.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Document> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("ResourceConfig").getter(ResourceResult.getter(ResourceResult::resourceConfig)).setter(ResourceResult.setter(Builder::resourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GUID_FIELD, RESOURCE_ID_FIELD, ACCOUNT_ID_FIELD, REGION_FIELD, RESOURCE_CATEGORY_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_NAME_FIELD, RESOURCE_CREATION_TIME_DT_FIELD, RESOURCE_DETAIL_CAPTURE_TIME_DT_FIELD, FINDINGS_SUMMARY_FIELD, RESOURCE_TAGS_FIELD, RESOURCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceGuid;
    private final String resourceId;
    private final String accountId;
    private final String region;
    private final String resourceCategory;
    private final String resourceType;
    private final String resourceName;
    private final String resourceCreationTimeDt;
    private final String resourceDetailCaptureTimeDt;
    private final List<ResourceFindingsSummary> findingsSummary;
    private final List<ResourceTag> resourceTags;
    private final Document resourceConfig;

    private ResourceResult(BuilderImpl builder) {
        this.resourceGuid = builder.resourceGuid;
        this.resourceId = builder.resourceId;
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.resourceCategory = builder.resourceCategory;
        this.resourceType = builder.resourceType;
        this.resourceName = builder.resourceName;
        this.resourceCreationTimeDt = builder.resourceCreationTimeDt;
        this.resourceDetailCaptureTimeDt = builder.resourceDetailCaptureTimeDt;
        this.findingsSummary = builder.findingsSummary;
        this.resourceTags = builder.resourceTags;
        this.resourceConfig = builder.resourceConfig;
    }

    public final String resourceGuid() {
        return this.resourceGuid;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String region() {
        return this.region;
    }

    public final ResourceCategory resourceCategory() {
        return ResourceCategory.fromValue(this.resourceCategory);
    }

    public final String resourceCategoryAsString() {
        return this.resourceCategory;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String resourceCreationTimeDt() {
        return this.resourceCreationTimeDt;
    }

    public final String resourceDetailCaptureTimeDt() {
        return this.resourceDetailCaptureTimeDt;
    }

    public final boolean hasFindingsSummary() {
        return this.findingsSummary != null && !(this.findingsSummary instanceof SdkAutoConstructList);
    }

    public final List<ResourceFindingsSummary> findingsSummary() {
        return this.findingsSummary;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public final Document resourceConfig() {
        return this.resourceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationTimeDt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetailCaptureTimeDt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingsSummary() ? this.findingsSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceResult)) {
            return false;
        }
        ResourceResult other = (ResourceResult)obj;
        return Objects.equals(this.resourceGuid(), other.resourceGuid()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceCategoryAsString(), other.resourceCategoryAsString()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceCreationTimeDt(), other.resourceCreationTimeDt()) && Objects.equals(this.resourceDetailCaptureTimeDt(), other.resourceDetailCaptureTimeDt()) && this.hasFindingsSummary() == other.hasFindingsSummary() && Objects.equals(this.findingsSummary(), other.findingsSummary()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.resourceConfig(), other.resourceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceResult").add("ResourceGuid", (Object)this.resourceGuid()).add("ResourceId", (Object)this.resourceId()).add("AccountId", (Object)this.accountId()).add("Region", (Object)this.region()).add("ResourceCategory", (Object)this.resourceCategoryAsString()).add("ResourceType", (Object)this.resourceType()).add("ResourceName", (Object)this.resourceName()).add("ResourceCreationTimeDt", (Object)this.resourceCreationTimeDt()).add("ResourceDetailCaptureTimeDt", (Object)this.resourceDetailCaptureTimeDt()).add("FindingsSummary", this.hasFindingsSummary() ? this.findingsSummary() : null).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("ResourceConfig", (Object)this.resourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGuid": {
                return Optional.ofNullable(clazz.cast(this.resourceGuid()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ResourceCategory": {
                return Optional.ofNullable(clazz.cast(this.resourceCategoryAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "ResourceCreationTimeDt": {
                return Optional.ofNullable(clazz.cast(this.resourceCreationTimeDt()));
            }
            case "ResourceDetailCaptureTimeDt": {
                return Optional.ofNullable(clazz.cast(this.resourceDetailCaptureTimeDt()));
            }
            case "FindingsSummary": {
                return Optional.ofNullable(clazz.cast(this.findingsSummary()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceGuid", RESOURCE_GUID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("ResourceCategory", RESOURCE_CATEGORY_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("ResourceCreationTimeDt", RESOURCE_CREATION_TIME_DT_FIELD);
        map.put("ResourceDetailCaptureTimeDt", RESOURCE_DETAIL_CAPTURE_TIME_DT_FIELD);
        map.put("FindingsSummary", FINDINGS_SUMMARY_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("ResourceConfig", RESOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceResult, T> g) {
        return obj -> g.apply((ResourceResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceGuid;
        private String resourceId;
        private String accountId;
        private String region;
        private String resourceCategory;
        private String resourceType;
        private String resourceName;
        private String resourceCreationTimeDt;
        private String resourceDetailCaptureTimeDt;
        private List<ResourceFindingsSummary> findingsSummary = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private Document resourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceResult model) {
            this.resourceGuid(model.resourceGuid);
            this.resourceId(model.resourceId);
            this.accountId(model.accountId);
            this.region(model.region);
            this.resourceCategory(model.resourceCategory);
            this.resourceType(model.resourceType);
            this.resourceName(model.resourceName);
            this.resourceCreationTimeDt(model.resourceCreationTimeDt);
            this.resourceDetailCaptureTimeDt(model.resourceDetailCaptureTimeDt);
            this.findingsSummary(model.findingsSummary);
            this.resourceTags(model.resourceTags);
            this.resourceConfig(model.resourceConfig);
        }

        public final String getResourceGuid() {
            return this.resourceGuid;
        }

        public final void setResourceGuid(String resourceGuid) {
            this.resourceGuid = resourceGuid;
        }

        @Override
        public final Builder resourceGuid(String resourceGuid) {
            this.resourceGuid = resourceGuid;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceCategory() {
            return this.resourceCategory;
        }

        public final void setResourceCategory(String resourceCategory) {
            this.resourceCategory = resourceCategory;
        }

        @Override
        public final Builder resourceCategory(String resourceCategory) {
            this.resourceCategory = resourceCategory;
            return this;
        }

        @Override
        public final Builder resourceCategory(ResourceCategory resourceCategory) {
            this.resourceCategory(resourceCategory == null ? null : resourceCategory.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceCreationTimeDt() {
            return this.resourceCreationTimeDt;
        }

        public final void setResourceCreationTimeDt(String resourceCreationTimeDt) {
            this.resourceCreationTimeDt = resourceCreationTimeDt;
        }

        @Override
        public final Builder resourceCreationTimeDt(String resourceCreationTimeDt) {
            this.resourceCreationTimeDt = resourceCreationTimeDt;
            return this;
        }

        public final String getResourceDetailCaptureTimeDt() {
            return this.resourceDetailCaptureTimeDt;
        }

        public final void setResourceDetailCaptureTimeDt(String resourceDetailCaptureTimeDt) {
            this.resourceDetailCaptureTimeDt = resourceDetailCaptureTimeDt;
        }

        @Override
        public final Builder resourceDetailCaptureTimeDt(String resourceDetailCaptureTimeDt) {
            this.resourceDetailCaptureTimeDt = resourceDetailCaptureTimeDt;
            return this;
        }

        public final List<ResourceFindingsSummary.Builder> getFindingsSummary() {
            List<ResourceFindingsSummary.Builder> result = ResourceFindingsSummaryListCopier.copyToBuilder(this.findingsSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingsSummary(Collection<ResourceFindingsSummary.BuilderImpl> findingsSummary) {
            this.findingsSummary = ResourceFindingsSummaryListCopier.copyFromBuilder(findingsSummary);
        }

        @Override
        public final Builder findingsSummary(Collection<ResourceFindingsSummary> findingsSummary) {
            this.findingsSummary = ResourceFindingsSummaryListCopier.copy(findingsSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsSummary(ResourceFindingsSummary ... findingsSummary) {
            this.findingsSummary(Arrays.asList(findingsSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsSummary(Consumer<ResourceFindingsSummary.Builder> ... findingsSummary) {
            this.findingsSummary(Stream.of(findingsSummary).map(c -> (ResourceFindingsSummary)((ResourceFindingsSummary.Builder)ResourceFindingsSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Document getResourceConfig() {
            return this.resourceConfig;
        }

        public final void setResourceConfig(Document resourceConfig) {
            this.resourceConfig = resourceConfig;
        }

        @Override
        public final Builder resourceConfig(Document resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public ResourceResult build() {
            return new ResourceResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceResult> {
        public Builder resourceGuid(String var1);

        public Builder resourceId(String var1);

        public Builder accountId(String var1);

        public Builder region(String var1);

        public Builder resourceCategory(String var1);

        public Builder resourceCategory(ResourceCategory var1);

        public Builder resourceType(String var1);

        public Builder resourceName(String var1);

        public Builder resourceCreationTimeDt(String var1);

        public Builder resourceDetailCaptureTimeDt(String var1);

        public Builder findingsSummary(Collection<ResourceFindingsSummary> var1);

        public Builder findingsSummary(ResourceFindingsSummary ... var1);

        public Builder findingsSummary(Consumer<ResourceFindingsSummary.Builder> ... var1);

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder resourceConfig(Document var1);
    }
}

