/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.IntegerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegerListConfigurationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegerListConfigurationOptions> {
    private static final SdkField<List<Integer>> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultValue").getter(IntegerListConfigurationOptions.getter(IntegerListConfigurationOptions::defaultValue)).setter(IntegerListConfigurationOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Min").getter(IntegerListConfigurationOptions.getter(IntegerListConfigurationOptions::min)).setter(IntegerListConfigurationOptions.setter(Builder::min)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()}).build();
    private static final SdkField<Integer> MAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Max").getter(IntegerListConfigurationOptions.getter(IntegerListConfigurationOptions::max)).setter(IntegerListConfigurationOptions.setter(Builder::max)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(IntegerListConfigurationOptions.getter(IntegerListConfigurationOptions::maxItems)).setter(IntegerListConfigurationOptions.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, MIN_FIELD, MAX_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntegerListConfigurationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Integer> defaultValue;
    private final Integer min;
    private final Integer max;
    private final Integer maxItems;

    private IntegerListConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.min = builder.min;
        this.max = builder.max;
        this.maxItems = builder.maxItems;
    }

    public final boolean hasDefaultValue() {
        return this.defaultValue != null && !(this.defaultValue instanceof SdkAutoConstructList);
    }

    public final List<Integer> defaultValue() {
        return this.defaultValue;
    }

    public final Integer min() {
        return this.min;
    }

    public final Integer max() {
        return this.max;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultValue() ? this.defaultValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.min());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerListConfigurationOptions)) {
            return false;
        }
        IntegerListConfigurationOptions other = (IntegerListConfigurationOptions)obj;
        return this.hasDefaultValue() == other.hasDefaultValue() && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.min(), other.min()) && Objects.equals(this.max(), other.max()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"IntegerListConfigurationOptions").add("DefaultValue", this.hasDefaultValue() ? this.defaultValue() : null).add("Min", (Object)this.min()).add("Max", (Object)this.max()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Min": {
                return Optional.ofNullable(clazz.cast(this.min()));
            }
            case "Max": {
                return Optional.ofNullable(clazz.cast(this.max()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("Min", MIN_FIELD);
        map.put("Max", MAX_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegerListConfigurationOptions, T> g) {
        return obj -> g.apply((IntegerListConfigurationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> defaultValue = DefaultSdkAutoConstructList.getInstance();
        private Integer min;
        private Integer max;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerListConfigurationOptions model) {
            this.defaultValue(model.defaultValue);
            this.min(model.min);
            this.max(model.max);
            this.maxItems(model.maxItems);
        }

        public final Collection<Integer> getDefaultValue() {
            if (this.defaultValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultValue;
        }

        public final void setDefaultValue(Collection<Integer> defaultValue) {
            this.defaultValue = IntegerListCopier.copy(defaultValue);
        }

        @Override
        public final Builder defaultValue(Collection<Integer> defaultValue) {
            this.defaultValue = IntegerListCopier.copy(defaultValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValue(Integer ... defaultValue) {
            this.defaultValue(Arrays.asList(defaultValue));
            return this;
        }

        public final Integer getMin() {
            return this.min;
        }

        public final void setMin(Integer min) {
            this.min = min;
        }

        @Override
        public final Builder min(Integer min) {
            this.min = min;
            return this;
        }

        public final Integer getMax() {
            return this.max;
        }

        public final void setMax(Integer max) {
            this.max = max;
        }

        @Override
        public final Builder max(Integer max) {
            this.max = max;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public IntegerListConfigurationOptions build() {
            return new IntegerListConfigurationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegerListConfigurationOptions> {
        public Builder defaultValue(Collection<Integer> var1);

        public Builder defaultValue(Integer ... var1);

        public Builder min(Integer var1);

        public Builder max(Integer var1);

        public Builder maxItems(Integer var1);
    }
}

