/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.BooleanConfigurationOptions;
import software.amazon.awssdk.services.securityhub.model.DoubleConfigurationOptions;
import software.amazon.awssdk.services.securityhub.model.EnumConfigurationOptions;
import software.amazon.awssdk.services.securityhub.model.EnumListConfigurationOptions;
import software.amazon.awssdk.services.securityhub.model.IntegerConfigurationOptions;
import software.amazon.awssdk.services.securityhub.model.IntegerListConfigurationOptions;
import software.amazon.awssdk.services.securityhub.model.StringConfigurationOptions;
import software.amazon.awssdk.services.securityhub.model.StringListConfigurationOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationOptions> {
    private static final SdkField<IntegerConfigurationOptions> INTEGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Integer").getter(ConfigurationOptions.getter(ConfigurationOptions::integer)).setter(ConfigurationOptions.setter(Builder::integer)).constructor(IntegerConfigurationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Integer").build()}).build();
    private static final SdkField<IntegerListConfigurationOptions> INTEGER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IntegerList").getter(ConfigurationOptions.getter(ConfigurationOptions::integerList)).setter(ConfigurationOptions.setter(Builder::integerList)).constructor(IntegerListConfigurationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerList").build()}).build();
    private static final SdkField<DoubleConfigurationOptions> DOUBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Double").getter(ConfigurationOptions.getter(ConfigurationOptions::doubleValue)).setter(ConfigurationOptions.setter(Builder::doubleValue)).constructor(DoubleConfigurationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Double").build()}).build();
    private static final SdkField<StringConfigurationOptions> STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("String").getter(ConfigurationOptions.getter(ConfigurationOptions::string)).setter(ConfigurationOptions.setter(Builder::string)).constructor(StringConfigurationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("String").build()}).build();
    private static final SdkField<StringListConfigurationOptions> STRING_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringList").getter(ConfigurationOptions.getter(ConfigurationOptions::stringList)).setter(ConfigurationOptions.setter(Builder::stringList)).constructor(StringListConfigurationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringList").build()}).build();
    private static final SdkField<BooleanConfigurationOptions> BOOLEAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Boolean").getter(ConfigurationOptions.getter(ConfigurationOptions::booleanValue)).setter(ConfigurationOptions.setter(Builder::booleanValue)).constructor(BooleanConfigurationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Boolean").build()}).build();
    private static final SdkField<EnumConfigurationOptions> ENUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Enum").getter(ConfigurationOptions.getter(ConfigurationOptions::enumValue)).setter(ConfigurationOptions.setter(Builder::enumValue)).constructor(EnumConfigurationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enum").build()}).build();
    private static final SdkField<EnumListConfigurationOptions> ENUM_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnumList").getter(ConfigurationOptions.getter(ConfigurationOptions::enumList)).setter(ConfigurationOptions.setter(Builder::enumList)).constructor(EnumListConfigurationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnumList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_FIELD, INTEGER_LIST_FIELD, DOUBLE_FIELD, STRING_FIELD, STRING_LIST_FIELD, BOOLEAN_FIELD, ENUM_FIELD, ENUM_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IntegerConfigurationOptions integer;
    private final IntegerListConfigurationOptions integerList;
    private final DoubleConfigurationOptions doubleValue;
    private final StringConfigurationOptions string;
    private final StringListConfigurationOptions stringList;
    private final BooleanConfigurationOptions booleanValue;
    private final EnumConfigurationOptions enumValue;
    private final EnumListConfigurationOptions enumList;
    private final Type type;

    private ConfigurationOptions(BuilderImpl builder) {
        this.integer = builder.integer;
        this.integerList = builder.integerList;
        this.doubleValue = builder.doubleValue;
        this.string = builder.string;
        this.stringList = builder.stringList;
        this.booleanValue = builder.booleanValue;
        this.enumValue = builder.enumValue;
        this.enumList = builder.enumList;
        this.type = builder.type;
    }

    public final IntegerConfigurationOptions integer() {
        return this.integer;
    }

    public final IntegerListConfigurationOptions integerList() {
        return this.integerList;
    }

    public final DoubleConfigurationOptions doubleValue() {
        return this.doubleValue;
    }

    public final StringConfigurationOptions string() {
        return this.string;
    }

    public final StringListConfigurationOptions stringList() {
        return this.stringList;
    }

    public final BooleanConfigurationOptions booleanValue() {
        return this.booleanValue;
    }

    public final EnumConfigurationOptions enumValue() {
        return this.enumValue;
    }

    public final EnumListConfigurationOptions enumList() {
        return this.enumList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integer());
        hashCode = 31 * hashCode + Objects.hashCode(this.integerList());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.string());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringList());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.enumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.enumList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOptions)) {
            return false;
        }
        ConfigurationOptions other = (ConfigurationOptions)obj;
        return Objects.equals(this.integer(), other.integer()) && Objects.equals(this.integerList(), other.integerList()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.string(), other.string()) && Objects.equals(this.stringList(), other.stringList()) && Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.enumValue(), other.enumValue()) && Objects.equals(this.enumList(), other.enumList());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationOptions").add("Integer", (Object)this.integer()).add("IntegerList", (Object)this.integerList()).add("Double", (Object)this.doubleValue()).add("String", (Object)this.string()).add("StringList", (Object)this.stringList()).add("Boolean", (Object)this.booleanValue()).add("Enum", (Object)this.enumValue()).add("EnumList", (Object)this.enumList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Integer": {
                return Optional.ofNullable(clazz.cast(this.integer()));
            }
            case "IntegerList": {
                return Optional.ofNullable(clazz.cast(this.integerList()));
            }
            case "Double": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "String": {
                return Optional.ofNullable(clazz.cast(this.string()));
            }
            case "StringList": {
                return Optional.ofNullable(clazz.cast(this.stringList()));
            }
            case "Boolean": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "Enum": {
                return Optional.ofNullable(clazz.cast(this.enumValue()));
            }
            case "EnumList": {
                return Optional.ofNullable(clazz.cast(this.enumList()));
            }
        }
        return Optional.empty();
    }

    public static ConfigurationOptions fromInteger(IntegerConfigurationOptions integer) {
        return (ConfigurationOptions)ConfigurationOptions.builder().integer(integer).build();
    }

    public static ConfigurationOptions fromInteger(Consumer<IntegerConfigurationOptions.Builder> integer) {
        IntegerConfigurationOptions.Builder builder = IntegerConfigurationOptions.builder();
        integer.accept(builder);
        return ConfigurationOptions.fromInteger((IntegerConfigurationOptions)builder.build());
    }

    public static ConfigurationOptions fromIntegerList(IntegerListConfigurationOptions integerList) {
        return (ConfigurationOptions)ConfigurationOptions.builder().integerList(integerList).build();
    }

    public static ConfigurationOptions fromIntegerList(Consumer<IntegerListConfigurationOptions.Builder> integerList) {
        IntegerListConfigurationOptions.Builder builder = IntegerListConfigurationOptions.builder();
        integerList.accept(builder);
        return ConfigurationOptions.fromIntegerList((IntegerListConfigurationOptions)builder.build());
    }

    public static ConfigurationOptions fromDoubleValue(DoubleConfigurationOptions doubleValue) {
        return (ConfigurationOptions)ConfigurationOptions.builder().doubleValue(doubleValue).build();
    }

    public static ConfigurationOptions fromDoubleValue(Consumer<DoubleConfigurationOptions.Builder> doubleValue) {
        DoubleConfigurationOptions.Builder builder = DoubleConfigurationOptions.builder();
        doubleValue.accept(builder);
        return ConfigurationOptions.fromDoubleValue((DoubleConfigurationOptions)builder.build());
    }

    public static ConfigurationOptions fromString(StringConfigurationOptions string) {
        return (ConfigurationOptions)ConfigurationOptions.builder().string(string).build();
    }

    public static ConfigurationOptions fromString(Consumer<StringConfigurationOptions.Builder> string) {
        StringConfigurationOptions.Builder builder = StringConfigurationOptions.builder();
        string.accept(builder);
        return ConfigurationOptions.fromString((StringConfigurationOptions)builder.build());
    }

    public static ConfigurationOptions fromStringList(StringListConfigurationOptions stringList) {
        return (ConfigurationOptions)ConfigurationOptions.builder().stringList(stringList).build();
    }

    public static ConfigurationOptions fromStringList(Consumer<StringListConfigurationOptions.Builder> stringList) {
        StringListConfigurationOptions.Builder builder = StringListConfigurationOptions.builder();
        stringList.accept(builder);
        return ConfigurationOptions.fromStringList((StringListConfigurationOptions)builder.build());
    }

    public static ConfigurationOptions fromBooleanValue(BooleanConfigurationOptions booleanValue) {
        return (ConfigurationOptions)ConfigurationOptions.builder().booleanValue(booleanValue).build();
    }

    public static ConfigurationOptions fromBooleanValue(Consumer<BooleanConfigurationOptions.Builder> booleanValue) {
        BooleanConfigurationOptions.Builder builder = BooleanConfigurationOptions.builder();
        booleanValue.accept(builder);
        return ConfigurationOptions.fromBooleanValue((BooleanConfigurationOptions)builder.build());
    }

    public static ConfigurationOptions fromEnumValue(EnumConfigurationOptions enumValue) {
        return (ConfigurationOptions)ConfigurationOptions.builder().enumValue(enumValue).build();
    }

    public static ConfigurationOptions fromEnumValue(Consumer<EnumConfigurationOptions.Builder> enumValue) {
        EnumConfigurationOptions.Builder builder = EnumConfigurationOptions.builder();
        enumValue.accept(builder);
        return ConfigurationOptions.fromEnumValue((EnumConfigurationOptions)builder.build());
    }

    public static ConfigurationOptions fromEnumList(EnumListConfigurationOptions enumList) {
        return (ConfigurationOptions)ConfigurationOptions.builder().enumList(enumList).build();
    }

    public static ConfigurationOptions fromEnumList(Consumer<EnumListConfigurationOptions.Builder> enumList) {
        EnumListConfigurationOptions.Builder builder = EnumListConfigurationOptions.builder();
        enumList.accept(builder);
        return ConfigurationOptions.fromEnumList((EnumListConfigurationOptions)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Integer", INTEGER_FIELD);
        map.put("IntegerList", INTEGER_LIST_FIELD);
        map.put("Double", DOUBLE_FIELD);
        map.put("String", STRING_FIELD);
        map.put("StringList", STRING_LIST_FIELD);
        map.put("Boolean", BOOLEAN_FIELD);
        map.put("Enum", ENUM_FIELD);
        map.put("EnumList", ENUM_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationOptions, T> g) {
        return obj -> g.apply((ConfigurationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTEGER,
        INTEGER_LIST,
        DOUBLE,
        STRING,
        STRING_LIST,
        BOOLEAN,
        ENUM,
        ENUM_LIST,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IntegerConfigurationOptions integer;
        private IntegerListConfigurationOptions integerList;
        private DoubleConfigurationOptions doubleValue;
        private StringConfigurationOptions string;
        private StringListConfigurationOptions stringList;
        private BooleanConfigurationOptions booleanValue;
        private EnumConfigurationOptions enumValue;
        private EnumListConfigurationOptions enumList;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationOptions model) {
            this.integer(model.integer);
            this.integerList(model.integerList);
            this.doubleValue(model.doubleValue);
            this.string(model.string);
            this.stringList(model.stringList);
            this.booleanValue(model.booleanValue);
            this.enumValue(model.enumValue);
            this.enumList(model.enumList);
        }

        public final IntegerConfigurationOptions.Builder getInteger() {
            return this.integer != null ? this.integer.toBuilder() : null;
        }

        public final void setInteger(IntegerConfigurationOptions.BuilderImpl integer) {
            IntegerConfigurationOptions oldValue = this.integer;
            this.integer = integer != null ? integer.build() : null;
            this.handleUnionValueChange(Type.INTEGER, oldValue, this.integer);
        }

        @Override
        public final Builder integer(IntegerConfigurationOptions integer) {
            IntegerConfigurationOptions oldValue = this.integer;
            this.integer = integer;
            this.handleUnionValueChange(Type.INTEGER, oldValue, this.integer);
            return this;
        }

        public final IntegerListConfigurationOptions.Builder getIntegerList() {
            return this.integerList != null ? this.integerList.toBuilder() : null;
        }

        public final void setIntegerList(IntegerListConfigurationOptions.BuilderImpl integerList) {
            IntegerListConfigurationOptions oldValue = this.integerList;
            this.integerList = integerList != null ? integerList.build() : null;
            this.handleUnionValueChange(Type.INTEGER_LIST, oldValue, this.integerList);
        }

        @Override
        public final Builder integerList(IntegerListConfigurationOptions integerList) {
            IntegerListConfigurationOptions oldValue = this.integerList;
            this.integerList = integerList;
            this.handleUnionValueChange(Type.INTEGER_LIST, oldValue, this.integerList);
            return this;
        }

        public final DoubleConfigurationOptions.Builder getDoubleValue() {
            return this.doubleValue != null ? this.doubleValue.toBuilder() : null;
        }

        public final void setDoubleValue(DoubleConfigurationOptions.BuilderImpl doubleValue) {
            DoubleConfigurationOptions oldValue = this.doubleValue;
            this.doubleValue = doubleValue != null ? doubleValue.build() : null;
            this.handleUnionValueChange(Type.DOUBLE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(DoubleConfigurationOptions doubleValue) {
            DoubleConfigurationOptions oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE, oldValue, this.doubleValue);
            return this;
        }

        public final StringConfigurationOptions.Builder getString() {
            return this.string != null ? this.string.toBuilder() : null;
        }

        public final void setString(StringConfigurationOptions.BuilderImpl string) {
            StringConfigurationOptions oldValue = this.string;
            this.string = string != null ? string.build() : null;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(StringConfigurationOptions string) {
            StringConfigurationOptions oldValue = this.string;
            this.string = string;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final StringListConfigurationOptions.Builder getStringList() {
            return this.stringList != null ? this.stringList.toBuilder() : null;
        }

        public final void setStringList(StringListConfigurationOptions.BuilderImpl stringList) {
            StringListConfigurationOptions oldValue = this.stringList;
            this.stringList = stringList != null ? stringList.build() : null;
            this.handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
        }

        @Override
        public final Builder stringList(StringListConfigurationOptions stringList) {
            StringListConfigurationOptions oldValue = this.stringList;
            this.stringList = stringList;
            this.handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
            return this;
        }

        public final BooleanConfigurationOptions.Builder getBooleanValue() {
            return this.booleanValue != null ? this.booleanValue.toBuilder() : null;
        }

        public final void setBooleanValue(BooleanConfigurationOptions.BuilderImpl booleanValue) {
            BooleanConfigurationOptions oldValue = this.booleanValue;
            this.booleanValue = booleanValue != null ? booleanValue.build() : null;
            this.handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(BooleanConfigurationOptions booleanValue) {
            BooleanConfigurationOptions oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
            return this;
        }

        public final EnumConfigurationOptions.Builder getEnumValue() {
            return this.enumValue != null ? this.enumValue.toBuilder() : null;
        }

        public final void setEnumValue(EnumConfigurationOptions.BuilderImpl enumValue) {
            EnumConfigurationOptions oldValue = this.enumValue;
            this.enumValue = enumValue != null ? enumValue.build() : null;
            this.handleUnionValueChange(Type.ENUM, oldValue, this.enumValue);
        }

        @Override
        public final Builder enumValue(EnumConfigurationOptions enumValue) {
            EnumConfigurationOptions oldValue = this.enumValue;
            this.enumValue = enumValue;
            this.handleUnionValueChange(Type.ENUM, oldValue, this.enumValue);
            return this;
        }

        public final EnumListConfigurationOptions.Builder getEnumList() {
            return this.enumList != null ? this.enumList.toBuilder() : null;
        }

        public final void setEnumList(EnumListConfigurationOptions.BuilderImpl enumList) {
            EnumListConfigurationOptions oldValue = this.enumList;
            this.enumList = enumList != null ? enumList.build() : null;
            this.handleUnionValueChange(Type.ENUM_LIST, oldValue, this.enumList);
        }

        @Override
        public final Builder enumList(EnumListConfigurationOptions enumList) {
            EnumListConfigurationOptions oldValue = this.enumList;
            this.enumList = enumList;
            this.handleUnionValueChange(Type.ENUM_LIST, oldValue, this.enumList);
            return this;
        }

        public ConfigurationOptions build() {
            return new ConfigurationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationOptions> {
        public Builder integer(IntegerConfigurationOptions var1);

        default public Builder integer(Consumer<IntegerConfigurationOptions.Builder> integer) {
            return this.integer((IntegerConfigurationOptions)((IntegerConfigurationOptions.Builder)IntegerConfigurationOptions.builder().applyMutation(integer)).build());
        }

        public Builder integerList(IntegerListConfigurationOptions var1);

        default public Builder integerList(Consumer<IntegerListConfigurationOptions.Builder> integerList) {
            return this.integerList((IntegerListConfigurationOptions)((IntegerListConfigurationOptions.Builder)IntegerListConfigurationOptions.builder().applyMutation(integerList)).build());
        }

        public Builder doubleValue(DoubleConfigurationOptions var1);

        default public Builder doubleValue(Consumer<DoubleConfigurationOptions.Builder> doubleValue) {
            return this.doubleValue((DoubleConfigurationOptions)((DoubleConfigurationOptions.Builder)DoubleConfigurationOptions.builder().applyMutation(doubleValue)).build());
        }

        public Builder string(StringConfigurationOptions var1);

        default public Builder string(Consumer<StringConfigurationOptions.Builder> string) {
            return this.string((StringConfigurationOptions)((StringConfigurationOptions.Builder)StringConfigurationOptions.builder().applyMutation(string)).build());
        }

        public Builder stringList(StringListConfigurationOptions var1);

        default public Builder stringList(Consumer<StringListConfigurationOptions.Builder> stringList) {
            return this.stringList((StringListConfigurationOptions)((StringListConfigurationOptions.Builder)StringListConfigurationOptions.builder().applyMutation(stringList)).build());
        }

        public Builder booleanValue(BooleanConfigurationOptions var1);

        default public Builder booleanValue(Consumer<BooleanConfigurationOptions.Builder> booleanValue) {
            return this.booleanValue((BooleanConfigurationOptions)((BooleanConfigurationOptions.Builder)BooleanConfigurationOptions.builder().applyMutation(booleanValue)).build());
        }

        public Builder enumValue(EnumConfigurationOptions var1);

        default public Builder enumValue(Consumer<EnumConfigurationOptions.Builder> enumValue) {
            return this.enumValue((EnumConfigurationOptions)((EnumConfigurationOptions.Builder)EnumConfigurationOptions.builder().applyMutation(enumValue)).build());
        }

        public Builder enumList(EnumListConfigurationOptions var1);

        default public Builder enumList(Consumer<EnumListConfigurationOptions.Builder> enumList) {
            return this.enumList((EnumListConfigurationOptions)((EnumListConfigurationOptions.Builder)EnumListConfigurationOptions.builder().applyMutation(enumList)).build());
        }
    }
}

