/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHubResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, DescribeHubResponse> {
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubArn").getter(DescribeHubResponse.getter(DescribeHubResponse::hubArn)).setter(DescribeHubResponse.setter(Builder::hubArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()}).build();
    private static final SdkField<String> SUBSCRIBED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscribedAt").getter(DescribeHubResponse.getter(DescribeHubResponse::subscribedAt)).setter(DescribeHubResponse.setter(Builder::subscribedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedAt").build()}).build();
    private static final SdkField<Boolean> AUTO_ENABLE_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEnableControls").getter(DescribeHubResponse.getter(DescribeHubResponse::autoEnableControls)).setter(DescribeHubResponse.setter(Builder::autoEnableControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableControls").build()}).build();
    private static final SdkField<String> CONTROL_FINDING_GENERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlFindingGenerator").getter(DescribeHubResponse.getter(DescribeHubResponse::controlFindingGeneratorAsString)).setter(DescribeHubResponse.setter(Builder::controlFindingGenerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlFindingGenerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_ARN_FIELD, SUBSCRIBED_AT_FIELD, AUTO_ENABLE_CONTROLS_FIELD, CONTROL_FINDING_GENERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeHubResponse.memberNameToFieldInitializer();
    private final String hubArn;
    private final String subscribedAt;
    private final Boolean autoEnableControls;
    private final String controlFindingGenerator;

    private DescribeHubResponse(BuilderImpl builder) {
        super(builder);
        this.hubArn = builder.hubArn;
        this.subscribedAt = builder.subscribedAt;
        this.autoEnableControls = builder.autoEnableControls;
        this.controlFindingGenerator = builder.controlFindingGenerator;
    }

    public final String hubArn() {
        return this.hubArn;
    }

    public final String subscribedAt() {
        return this.subscribedAt;
    }

    public final Boolean autoEnableControls() {
        return this.autoEnableControls;
    }

    public final ControlFindingGenerator controlFindingGenerator() {
        return ControlFindingGenerator.fromValue(this.controlFindingGenerator);
    }

    public final String controlFindingGeneratorAsString() {
        return this.controlFindingGenerator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableControls());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlFindingGeneratorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHubResponse)) {
            return false;
        }
        DescribeHubResponse other = (DescribeHubResponse)((Object)obj);
        return Objects.equals(this.hubArn(), other.hubArn()) && Objects.equals(this.subscribedAt(), other.subscribedAt()) && Objects.equals(this.autoEnableControls(), other.autoEnableControls()) && Objects.equals(this.controlFindingGeneratorAsString(), other.controlFindingGeneratorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHubResponse").add("HubArn", (Object)this.hubArn()).add("SubscribedAt", (Object)this.subscribedAt()).add("AutoEnableControls", (Object)this.autoEnableControls()).add("ControlFindingGenerator", (Object)this.controlFindingGeneratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubArn": {
                return Optional.ofNullable(clazz.cast(this.hubArn()));
            }
            case "SubscribedAt": {
                return Optional.ofNullable(clazz.cast(this.subscribedAt()));
            }
            case "AutoEnableControls": {
                return Optional.ofNullable(clazz.cast(this.autoEnableControls()));
            }
            case "ControlFindingGenerator": {
                return Optional.ofNullable(clazz.cast(this.controlFindingGeneratorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HubArn", HUB_ARN_FIELD);
        map.put("SubscribedAt", SUBSCRIBED_AT_FIELD);
        map.put("AutoEnableControls", AUTO_ENABLE_CONTROLS_FIELD);
        map.put("ControlFindingGenerator", CONTROL_FINDING_GENERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHubResponse, T> g) {
        return obj -> g.apply((DescribeHubResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String hubArn;
        private String subscribedAt;
        private Boolean autoEnableControls;
        private String controlFindingGenerator;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHubResponse model) {
            super(model);
            this.hubArn(model.hubArn);
            this.subscribedAt(model.subscribedAt);
            this.autoEnableControls(model.autoEnableControls);
            this.controlFindingGenerator(model.controlFindingGenerator);
        }

        public final String getHubArn() {
            return this.hubArn;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final String getSubscribedAt() {
            return this.subscribedAt;
        }

        public final void setSubscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        @Override
        public final Builder subscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        public final Boolean getAutoEnableControls() {
            return this.autoEnableControls;
        }

        public final void setAutoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
        }

        @Override
        public final Builder autoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
            return this;
        }

        public final String getControlFindingGenerator() {
            return this.controlFindingGenerator;
        }

        public final void setControlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
        }

        @Override
        public final Builder controlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
            return this;
        }

        @Override
        public final Builder controlFindingGenerator(ControlFindingGenerator controlFindingGenerator) {
            this.controlFindingGenerator(controlFindingGenerator == null ? null : controlFindingGenerator.toString());
            return this;
        }

        @Override
        public DescribeHubResponse build() {
            return new DescribeHubResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHubResponse> {
        public Builder hubArn(String var1);

        public Builder subscribedAt(String var1);

        public Builder autoEnableControls(Boolean var1);

        public Builder controlFindingGenerator(String var1);

        public Builder controlFindingGenerator(ControlFindingGenerator var1);
    }
}

