/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCertificateManagerCertificateDomainValidationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCertificateManagerCertificateDomainValidationOption> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AwsCertificateManagerCertificateDomainValidationOption.getter(AwsCertificateManagerCertificateDomainValidationOption::domainName)).setter(AwsCertificateManagerCertificateDomainValidationOption.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<AwsCertificateManagerCertificateResourceRecord> RESOURCE_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceRecord").getter(AwsCertificateManagerCertificateDomainValidationOption.getter(AwsCertificateManagerCertificateDomainValidationOption::resourceRecord)).setter(AwsCertificateManagerCertificateDomainValidationOption.setter(Builder::resourceRecord)).constructor(AwsCertificateManagerCertificateResourceRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecord").build()}).build();
    private static final SdkField<String> VALIDATION_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationDomain").getter(AwsCertificateManagerCertificateDomainValidationOption.getter(AwsCertificateManagerCertificateDomainValidationOption::validationDomain)).setter(AwsCertificateManagerCertificateDomainValidationOption.setter(Builder::validationDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationDomain").build()}).build();
    private static final SdkField<List<String>> VALIDATION_EMAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationEmails").getter(AwsCertificateManagerCertificateDomainValidationOption.getter(AwsCertificateManagerCertificateDomainValidationOption::validationEmails)).setter(AwsCertificateManagerCertificateDomainValidationOption.setter(Builder::validationEmails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationEmails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VALIDATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationMethod").getter(AwsCertificateManagerCertificateDomainValidationOption.getter(AwsCertificateManagerCertificateDomainValidationOption::validationMethod)).setter(AwsCertificateManagerCertificateDomainValidationOption.setter(Builder::validationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationMethod").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatus").getter(AwsCertificateManagerCertificateDomainValidationOption.getter(AwsCertificateManagerCertificateDomainValidationOption::validationStatus)).setter(AwsCertificateManagerCertificateDomainValidationOption.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, RESOURCE_RECORD_FIELD, VALIDATION_DOMAIN_FIELD, VALIDATION_EMAILS_FIELD, VALIDATION_METHOD_FIELD, VALIDATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("ResourceRecord", RESOURCE_RECORD_FIELD);
            this.put("ValidationDomain", VALIDATION_DOMAIN_FIELD);
            this.put("ValidationEmails", VALIDATION_EMAILS_FIELD);
            this.put("ValidationMethod", VALIDATION_METHOD_FIELD);
            this.put("ValidationStatus", VALIDATION_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final AwsCertificateManagerCertificateResourceRecord resourceRecord;
    private final String validationDomain;
    private final List<String> validationEmails;
    private final String validationMethod;
    private final String validationStatus;

    private AwsCertificateManagerCertificateDomainValidationOption(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.resourceRecord = builder.resourceRecord;
        this.validationDomain = builder.validationDomain;
        this.validationEmails = builder.validationEmails;
        this.validationMethod = builder.validationMethod;
        this.validationStatus = builder.validationStatus;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final AwsCertificateManagerCertificateResourceRecord resourceRecord() {
        return this.resourceRecord;
    }

    public final String validationDomain() {
        return this.validationDomain;
    }

    public final boolean hasValidationEmails() {
        return this.validationEmails != null && !(this.validationEmails instanceof SdkAutoConstructList);
    }

    public final List<String> validationEmails() {
        return this.validationEmails;
    }

    public final String validationMethod() {
        return this.validationMethod;
    }

    public final String validationStatus() {
        return this.validationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationEmails() ? this.validationEmails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCertificateManagerCertificateDomainValidationOption)) {
            return false;
        }
        AwsCertificateManagerCertificateDomainValidationOption other = (AwsCertificateManagerCertificateDomainValidationOption)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.resourceRecord(), other.resourceRecord()) && Objects.equals(this.validationDomain(), other.validationDomain()) && this.hasValidationEmails() == other.hasValidationEmails() && Objects.equals(this.validationEmails(), other.validationEmails()) && Objects.equals(this.validationMethod(), other.validationMethod()) && Objects.equals(this.validationStatus(), other.validationStatus());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCertificateManagerCertificateDomainValidationOption").add("DomainName", (Object)this.domainName()).add("ResourceRecord", (Object)this.resourceRecord()).add("ValidationDomain", (Object)this.validationDomain()).add("ValidationEmails", this.hasValidationEmails() ? this.validationEmails() : null).add("ValidationMethod", (Object)this.validationMethod()).add("ValidationStatus", (Object)this.validationStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ResourceRecord": {
                return Optional.ofNullable(clazz.cast(this.resourceRecord()));
            }
            case "ValidationDomain": {
                return Optional.ofNullable(clazz.cast(this.validationDomain()));
            }
            case "ValidationEmails": {
                return Optional.ofNullable(clazz.cast(this.validationEmails()));
            }
            case "ValidationMethod": {
                return Optional.ofNullable(clazz.cast(this.validationMethod()));
            }
            case "ValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsCertificateManagerCertificateDomainValidationOption, T> g) {
        return obj -> g.apply((AwsCertificateManagerCertificateDomainValidationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private AwsCertificateManagerCertificateResourceRecord resourceRecord;
        private String validationDomain;
        private List<String> validationEmails = DefaultSdkAutoConstructList.getInstance();
        private String validationMethod;
        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCertificateManagerCertificateDomainValidationOption model) {
            this.domainName(model.domainName);
            this.resourceRecord(model.resourceRecord);
            this.validationDomain(model.validationDomain);
            this.validationEmails(model.validationEmails);
            this.validationMethod(model.validationMethod);
            this.validationStatus(model.validationStatus);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final AwsCertificateManagerCertificateResourceRecord.Builder getResourceRecord() {
            return this.resourceRecord != null ? this.resourceRecord.toBuilder() : null;
        }

        public final void setResourceRecord(AwsCertificateManagerCertificateResourceRecord.BuilderImpl resourceRecord) {
            this.resourceRecord = resourceRecord != null ? resourceRecord.build() : null;
        }

        @Override
        public final Builder resourceRecord(AwsCertificateManagerCertificateResourceRecord resourceRecord) {
            this.resourceRecord = resourceRecord;
            return this;
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final Collection<String> getValidationEmails() {
            if (this.validationEmails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validationEmails;
        }

        public final void setValidationEmails(Collection<String> validationEmails) {
            this.validationEmails = StringListCopier.copy(validationEmails);
        }

        @Override
        public final Builder validationEmails(Collection<String> validationEmails) {
            this.validationEmails = StringListCopier.copy(validationEmails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationEmails(String ... validationEmails) {
            this.validationEmails(Arrays.asList(validationEmails));
            return this;
        }

        public final String getValidationMethod() {
            return this.validationMethod;
        }

        public final void setValidationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
        }

        @Override
        public final Builder validationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        public AwsCertificateManagerCertificateDomainValidationOption build() {
            return new AwsCertificateManagerCertificateDomainValidationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCertificateManagerCertificateDomainValidationOption> {
        public Builder domainName(String var1);

        public Builder resourceRecord(AwsCertificateManagerCertificateResourceRecord var1);

        default public Builder resourceRecord(Consumer<AwsCertificateManagerCertificateResourceRecord.Builder> resourceRecord) {
            return this.resourceRecord((AwsCertificateManagerCertificateResourceRecord)((AwsCertificateManagerCertificateResourceRecord.Builder)AwsCertificateManagerCertificateResourceRecord.builder().applyMutation(resourceRecord)).build());
        }

        public Builder validationDomain(String var1);

        public Builder validationEmails(Collection<String> var1);

        public Builder validationEmails(String ... var1);

        public Builder validationMethod(String var1);

        public Builder validationStatus(String var1);
    }
}

