/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VerificationState {
    UNKNOWN("UNKNOWN"),
    TRUE_POSITIVE("TRUE_POSITIVE"),
    FALSE_POSITIVE("FALSE_POSITIVE"),
    BENIGN_POSITIVE("BENIGN_POSITIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VerificationState> VALUE_MAP;
    private final String value;

    private VerificationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VerificationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VerificationState> knownValues() {
        EnumSet<VerificationState> knownValues = EnumSet.allOf(VerificationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VerificationState.class, VerificationState::toString);
    }
}

