/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStandardsControlAssociationsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<ListStandardsControlAssociationsRequest.Builder, ListStandardsControlAssociationsRequest> {
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityControlId").getter(getter(ListStandardsControlAssociationsRequest::securityControlId))
            .setter(setter(Builder::securityControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SecurityControlId").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStandardsControlAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListStandardsControlAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String securityControlId;

    private final String nextToken;

    private final Integer maxResults;

    private ListStandardsControlAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.securityControlId = builder.securityControlId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of the control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
     * or a mix of both parameters) that you want to determine the enablement status of in each enabled standard.
     * </p>
     * 
     * @return The identifier of the control (identified with <code>SecurityControlId</code>,
     *         <code>SecurityControlArn</code>, or a mix of both parameters) that you want to determine the enablement
     *         status of in each enabled standard.
     */
    public final String securityControlId() {
        return securityControlId;
    }

    /**
     * <p>
     * Optional pagination parameter.
     * </p>
     * 
     * @return Optional pagination parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An optional parameter that limits the total results of the API response to the specified number. If this
     * parameter isn't provided in the request, the results include the first 25 standard and control associations. The
     * results also include a <code>NextToken</code> parameter that you can use in a subsequent API call to get the next
     * 25 associations. This repeats until all associations for the specified control are returned. The number of
     * results is limited by the number of supported Security Hub standards that you've enabled in the calling account.
     * </p>
     * 
     * @return An optional parameter that limits the total results of the API response to the specified number. If this
     *         parameter isn't provided in the request, the results include the first 25 standard and control
     *         associations. The results also include a <code>NextToken</code> parameter that you can use in a
     *         subsequent API call to get the next 25 associations. This repeats until all associations for the
     *         specified control are returned. The number of results is limited by the number of supported Security Hub
     *         standards that you've enabled in the calling account.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStandardsControlAssociationsRequest)) {
            return false;
        }
        ListStandardsControlAssociationsRequest other = (ListStandardsControlAssociationsRequest) obj;
        return Objects.equals(securityControlId(), other.securityControlId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStandardsControlAssociationsRequest").add("SecurityControlId", securityControlId())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityControlId":
            return Optional.ofNullable(clazz.cast(securityControlId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStandardsControlAssociationsRequest, T> g) {
        return obj -> g.apply((ListStandardsControlAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStandardsControlAssociationsRequest> {
        /**
         * <p>
         * The identifier of the control (identified with <code>SecurityControlId</code>,
         * <code>SecurityControlArn</code>, or a mix of both parameters) that you want to determine the enablement
         * status of in each enabled standard.
         * </p>
         * 
         * @param securityControlId
         *        The identifier of the control (identified with <code>SecurityControlId</code>,
         *        <code>SecurityControlArn</code>, or a mix of both parameters) that you want to determine the
         *        enablement status of in each enabled standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlId(String securityControlId);

        /**
         * <p>
         * Optional pagination parameter.
         * </p>
         * 
         * @param nextToken
         *        Optional pagination parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An optional parameter that limits the total results of the API response to the specified number. If this
         * parameter isn't provided in the request, the results include the first 25 standard and control associations.
         * The results also include a <code>NextToken</code> parameter that you can use in a subsequent API call to get
         * the next 25 associations. This repeats until all associations for the specified control are returned. The
         * number of results is limited by the number of supported Security Hub standards that you've enabled in the
         * calling account.
         * </p>
         * 
         * @param maxResults
         *        An optional parameter that limits the total results of the API response to the specified number. If
         *        this parameter isn't provided in the request, the results include the first 25 standard and control
         *        associations. The results also include a <code>NextToken</code> parameter that you can use in a
         *        subsequent API call to get the next 25 associations. This repeats until all associations for the
         *        specified control are returned. The number of results is limited by the number of supported Security
         *        Hub standards that you've enabled in the calling account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String securityControlId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStandardsControlAssociationsRequest model) {
            super(model);
            securityControlId(model.securityControlId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getSecurityControlId() {
            return securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStandardsControlAssociationsRequest build() {
            return new ListStandardsControlAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
