/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class FindingHistoryUpdatesListCopier {
    static List<FindingHistoryUpdate> copy(Collection<? extends FindingHistoryUpdate> findingHistoryUpdatesListParam) {
        List<FindingHistoryUpdate> list;
        if (findingHistoryUpdatesListParam == null || findingHistoryUpdatesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingHistoryUpdate> modifiableList = new ArrayList<>();
            findingHistoryUpdatesListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FindingHistoryUpdate> copyFromBuilder(
            Collection<? extends FindingHistoryUpdate.Builder> findingHistoryUpdatesListParam) {
        List<FindingHistoryUpdate> list;
        if (findingHistoryUpdatesListParam == null || findingHistoryUpdatesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingHistoryUpdate> modifiableList = new ArrayList<>();
            findingHistoryUpdatesListParam.forEach(entry -> {
                FindingHistoryUpdate member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FindingHistoryUpdate.Builder> copyToBuilder(
            Collection<? extends FindingHistoryUpdate> findingHistoryUpdatesListParam) {
        List<FindingHistoryUpdate.Builder> list;
        if (findingHistoryUpdatesListParam == null || findingHistoryUpdatesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingHistoryUpdate.Builder> modifiableList = new ArrayList<>();
            findingHistoryUpdatesListParam.forEach(entry -> {
                FindingHistoryUpdate.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
