/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a load balancer that the service uses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServiceLoadBalancersDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsServiceLoadBalancersDetails.Builder, AwsEcsServiceLoadBalancersDetails> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerName").getter(getter(AwsEcsServiceLoadBalancersDetails::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()).build();

    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ContainerPort").getter(getter(AwsEcsServiceLoadBalancersDetails::containerPort))
            .setter(setter(Builder::containerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPort").build()).build();

    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(AwsEcsServiceLoadBalancersDetails::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetGroupArn").getter(getter(AwsEcsServiceLoadBalancersDetails::targetGroupArn))
            .setter(setter(Builder::targetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            CONTAINER_PORT_FIELD, LOAD_BALANCER_NAME_FIELD, TARGET_GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerName;

    private final Integer containerPort;

    private final String loadBalancerName;

    private final String targetGroupArn;

    private AwsEcsServiceLoadBalancersDetails(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.containerPort = builder.containerPort;
        this.loadBalancerName = builder.loadBalancerName;
        this.targetGroupArn = builder.targetGroupArn;
    }

    /**
     * <p>
     * The name of the container to associate with the load balancer.
     * </p>
     * 
     * @return The name of the container to associate with the load balancer.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The port on the container to associate with the load balancer. This port must correspond to a
     * <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2
     * launch type, the container instance they are launched on must allow ingress traffic on the <code>hostPort</code>
     * of the port mapping.
     * </p>
     * 
     * @return The port on the container to associate with the load balancer. This port must correspond to a
     *         <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use
     *         the EC2 launch type, the container instance they are launched on must allow ingress traffic on the
     *         <code>hostPort</code> of the port mapping.
     */
    public final Integer containerPort() {
        return containerPort;
    }

    /**
     * <p>
     * The name of the load balancer to associate with the Amazon ECS service or task set.
     * </p>
     * <p>
     * Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load Balancer,
     * the load balancer name is omitted.
     * </p>
     * 
     * @return The name of the load balancer to associate with the Amazon ECS service or task set.</p>
     *         <p>
     *         Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load
     *         Balancer, the load balancer name is omitted.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.
     * </p>
     * <p>
     * Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load Balancer,
     * the target group ARN is omitted.
     * </p>
     * 
     * @return The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.</p>
     *         <p>
     *         Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load
     *         Balancer, the target group ARN is omitted.
     */
    public final String targetGroupArn() {
        return targetGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceLoadBalancersDetails)) {
            return false;
        }
        AwsEcsServiceLoadBalancersDetails other = (AwsEcsServiceLoadBalancersDetails) obj;
        return Objects.equals(containerName(), other.containerName()) && Objects.equals(containerPort(), other.containerPort())
                && Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(targetGroupArn(), other.targetGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServiceLoadBalancersDetails").add("ContainerName", containerName())
                .add("ContainerPort", containerPort()).add("LoadBalancerName", loadBalancerName())
                .add("TargetGroupArn", targetGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "ContainerPort":
            return Optional.ofNullable(clazz.cast(containerPort()));
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "TargetGroupArn":
            return Optional.ofNullable(clazz.cast(targetGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServiceLoadBalancersDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceLoadBalancersDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsServiceLoadBalancersDetails> {
        /**
         * <p>
         * The name of the container to associate with the load balancer.
         * </p>
         * 
         * @param containerName
         *        The name of the container to associate with the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The port on the container to associate with the load balancer. This port must correspond to a
         * <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the
         * EC2 launch type, the container instance they are launched on must allow ingress traffic on the
         * <code>hostPort</code> of the port mapping.
         * </p>
         * 
         * @param containerPort
         *        The port on the container to associate with the load balancer. This port must correspond to a
         *        <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that
         *        use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the
         *        <code>hostPort</code> of the port mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPort(Integer containerPort);

        /**
         * <p>
         * The name of the load balancer to associate with the Amazon ECS service or task set.
         * </p>
         * <p>
         * Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load
         * Balancer, the load balancer name is omitted.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer to associate with the Amazon ECS service or task set.</p>
         *        <p>
         *        Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load
         *        Balancer, the load balancer name is omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.
         * </p>
         * <p>
         * Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load
         * Balancer, the target group ARN is omitted.
         * </p>
         * 
         * @param targetGroupArn
         *        The ARN of the Elastic Load Balancing target group or groups associated with a service or task
         *        set.</p>
         *        <p>
         *        Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load
         *        Balancer, the target group ARN is omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArn(String targetGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String containerName;

        private Integer containerPort;

        private String loadBalancerName;

        private String targetGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceLoadBalancersDetails model) {
            containerName(model.containerName);
            containerPort(model.containerPort);
            loadBalancerName(model.loadBalancerName);
            targetGroupArn(model.targetGroupArn);
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Integer getContainerPort() {
            return containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final String getTargetGroupArn() {
            return targetGroupArn;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        @Override
        public AwsEcsServiceLoadBalancersDetails build() {
            return new AwsEcsServiceLoadBalancersDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
