/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.securityhub.DefaultSecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.DefaultSecurityHubBaseClientBuilder;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClientBuilder;
import software.amazon.awssdk.services.securityhub.SecurityHubServiceClientConfiguration;
import software.amazon.awssdk.services.securityhub.endpoints.SecurityHubEndpointProvider;

@SdkInternalApi
final class DefaultSecurityHubAsyncClientBuilder
extends DefaultSecurityHubBaseClientBuilder<SecurityHubAsyncClientBuilder, SecurityHubAsyncClient>
implements SecurityHubAsyncClientBuilder {
    DefaultSecurityHubAsyncClientBuilder() {
    }

    @Override
    public DefaultSecurityHubAsyncClientBuilder endpointProvider(SecurityHubEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SecurityHubAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSecurityHubAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SecurityHubServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSecurityHubAsyncClient client = new DefaultSecurityHubAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SecurityHubServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SecurityHubServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

