/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableImportFindingsForProductRequest extends SecurityHubRequest implements
        ToCopyableBuilder<EnableImportFindingsForProductRequest.Builder, EnableImportFindingsForProductRequest> {
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductArn").getter(getter(EnableImportFindingsForProductRequest::productArn))
            .setter(setter(Builder::productArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ARN_FIELD));

    private final String productArn;

    private EnableImportFindingsForProductRequest(BuilderImpl builder) {
        super(builder);
        this.productArn = builder.productArn;
    }

    /**
     * <p>
     * The ARN of the product to enable the integration for.
     * </p>
     * 
     * @return The ARN of the product to enable the integration for.
     */
    public final String productArn() {
        return productArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableImportFindingsForProductRequest)) {
            return false;
        }
        EnableImportFindingsForProductRequest other = (EnableImportFindingsForProductRequest) obj;
        return Objects.equals(productArn(), other.productArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableImportFindingsForProductRequest").add("ProductArn", productArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductArn":
            return Optional.ofNullable(clazz.cast(productArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableImportFindingsForProductRequest, T> g) {
        return obj -> g.apply((EnableImportFindingsForProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableImportFindingsForProductRequest> {
        /**
         * <p>
         * The ARN of the product to enable the integration for.
         * </p>
         * 
         * @param productArn
         *        The ARN of the product to enable the integration for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(String productArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String productArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableImportFindingsForProductRequest model) {
            super(model);
            productArn(model.productArn);
        }

        public final String getProductArn() {
            return productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableImportFindingsForProductRequest build() {
            return new EnableImportFindingsForProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
